/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.util.BukkitUtils;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.ContainerBlock;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Bed;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PistonExtensionMaterial;
import org.bukkit.plugin.Plugin;

public class WorldEditor
implements Runnable {
    private final Logger log;
    private final LogBlock logblock;
    private final Config config;
    private final Queue<Edit> edits = new LinkedBlockingQueue<Edit>();
    private final World world;
    private int taskID;
    private int successes = 0;
    private int blacklistCollisions = 0;
    private long elapsedTime = 0L;
    public LookupCacheElement[] errors;

    public WorldEditor(LogBlock logBlock, World world) {
        this.log = logBlock.getServer().getLogger();
        this.logblock = logBlock;
        this.config = logBlock.getConfig();
        this.world = world;
    }

    public int getSize() {
        return this.edits.size();
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getErrors() {
        return this.errors.length;
    }

    public int getBlacklistCollisions() {
        return this.blacklistCollisions;
    }

    public void queueEdit(int n, int n2, int n3, int n4, int n5, byte by, String string, short s, short s2, byte by2) {
        this.edits.add(new Edit(0L, new Location(this.world, (double)n, (double)n2, (double)n3), null, n4, n5, by, string, new ChestAccess(s, s2, by2)));
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public synchronized void start() throws Exception {
        long l = System.currentTimeMillis();
        this.taskID = this.logblock.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.logblock, (Runnable)this, 0L, 1L);
        if (this.taskID == -1) {
            throw new Exception("Failed to schedule task");
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            throw new Exception("Interrupted");
        }
        this.elapsedTime = System.currentTimeMillis() - l;
    }

    @Override
    public synchronized void run() {
        ArrayList<WorldEditorException> arrayList = new ArrayList<WorldEditorException>();
        for (int i = 0; !this.edits.isEmpty() && i < 1000; ++i) {
            try {
                switch (this.edits.poll().perform()) {
                    case SUCCESS: {
                        ++this.successes;
                        break;
                    }
                    case BLACKLISTED: {
                        ++this.blacklistCollisions;
                    }
                }
                continue;
            }
            catch (WorldEditorException worldEditorException) {
                arrayList.add(worldEditorException);
                continue;
            }
            catch (Exception exception) {
                this.log.log(Level.WARNING, "[LogBlock WorldEditor] Exeption: ", exception);
            }
        }
        if (this.edits.isEmpty()) {
            this.logblock.getServer().getScheduler().cancelTask(this.taskID);
            if (arrayList.size() > 0) {
                try {
                    File file = new File("plugins/LogBlock/error/WorldEditor-" + new SimpleDateFormat("yy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + ".log");
                    file.getParentFile().mkdirs();
                    PrintWriter printWriter = new PrintWriter(file);
                    for (WorldEditorException worldEditorException : arrayList) {
                        printWriter.println(worldEditorException.getMessage());
                    }
                    printWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.errors = arrayList.toArray(new WorldEditorException[arrayList.size()]);
            this.notify();
        }
    }

    public static class WorldEditorException
    extends Exception
    implements LookupCacheElement {
        private final Location loc;

        public WorldEditorException(int n, int n2, Location location) {
            this("Failed to replace " + BukkitUtils.materialName(n) + " with " + BukkitUtils.materialName(n2), location);
        }

        public WorldEditorException(String string, Location location) {
            super(string + " at " + location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ());
            this.loc = location;
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }
    }

    private class Edit
    extends BlockChange {
        public Edit(long l, Location location, String string, int n, int n2, byte by, String string2, ChestAccess chestAccess) {
            super(l, location, string, n, n2, by, string2, chestAccess);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        PerformResult perform() throws WorldEditorException {
            if (((WorldEditor)WorldEditor.this).config.dontRollback.contains(this.replaced)) {
                return PerformResult.BLACKLISTED;
            }
            Block block = this.loc.getBlock();
            if (this.replaced == 0 && block.getTypeId() == 0) {
                return PerformResult.NO_ACTION;
            }
            BlockState blockState = block.getState();
            if (!WorldEditor.this.world.isChunkLoaded(block.getChunk())) {
                WorldEditor.this.world.loadChunk(block.getChunk());
            }
            if (this.type == this.replaced) {
                if (this.type == 0) {
                    if (block.setTypeId(0)) return PerformResult.SUCCESS;
                    throw new WorldEditorException(block.getTypeId(), 0, block.getLocation());
                }
                if (this.ca == null || this.type != 23 && this.type != 54 && this.type != 61 && this.type != 62) return PerformResult.NO_ACTION;
                int n = 0;
                try {
                    n = BukkitUtils.modifyContainer(blockState, new ItemStack((int)this.ca.itemType, (int)(-this.ca.itemAmount), 0, Byte.valueOf(this.ca.itemData)));
                    if (n > 0) {
                        for (BlockFace blockFace : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                            if (block.getRelative(blockFace).getTypeId() != 54) continue;
                            n = BukkitUtils.modifyContainer(block.getRelative(blockFace).getState(), new ItemStack((int)this.ca.itemType, this.ca.itemAmount < 0 ? n : -n, 0, Byte.valueOf(this.ca.itemData)));
                        }
                    }
                }
                catch (Exception exception) {
                    throw new WorldEditorException(exception.getMessage(), block.getLocation());
                }
                if (!blockState.update()) {
                    throw new WorldEditorException("Failed to update inventory of " + BukkitUtils.materialName(block.getTypeId()), block.getLocation());
                }
                if (n <= 0 || this.ca.itemAmount >= 0) return PerformResult.SUCCESS;
                throw new WorldEditorException("Not enough space left in " + BukkitUtils.materialName(block.getTypeId()), block.getLocation());
            }
            if (!BukkitUtils.equalTypes(block.getTypeId(), this.type) && !((WorldEditor)WorldEditor.this).config.replaceAnyway.contains(block.getTypeId())) {
                return PerformResult.NO_ACTION;
            }
            if (blockState instanceof ContainerBlock) {
                ((ContainerBlock)blockState).getInventory().clear();
                blockState.update();
            }
            if (block.getTypeId() == this.replaced) {
                if (block.getData() == (this.type == 0 ? this.data : (byte)0)) return PerformResult.NO_ACTION;
                block.setData(this.type == 0 ? this.data : (byte)0, true);
            } else if (!block.setTypeIdAndData(this.replaced, this.type == 0 ? this.data : (byte)0, true)) {
                throw new WorldEditorException(block.getTypeId(), this.replaced, block.getLocation());
            }
            int n = block.getTypeId();
            if (this.signtext != null && (n == 63 || n == 68)) {
                Sign sign = (Sign)block.getState();
                String[] stringArray = this.signtext.split("\u0000", 4);
                if (stringArray.length < 4) {
                    return PerformResult.NO_ACTION;
                }
                for (int i = 0; i < 4; ++i) {
                    sign.setLine(i, stringArray[i]);
                }
                if (sign.update()) return PerformResult.SUCCESS;
                throw new WorldEditorException("Failed to update signtext of " + BukkitUtils.materialName(block.getTypeId()), block.getLocation());
            }
            if (n == 26) {
                Block block2;
                Bed bed = (Bed)block.getState().getData();
                Block block3 = block2 = bed.isHeadOfBed() ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
                if (block2.getTypeId() != 0 || block2.setTypeIdAndData(26, (byte)(bed.getData() | 8), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(block2.getTypeId(), 26, block2.getLocation());
            }
            if (n == 64 || n == 71) {
                Block block4;
                byte by = block.getData();
                Block block5 = block4 = (by & 8) == 8 ? block.getRelative(BlockFace.DOWN) : block.getRelative(BlockFace.UP);
                if (block4.getTypeId() != 0 || block4.setTypeIdAndData(n, (byte)(by | 8), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(block4.getTypeId(), n, block4.getLocation());
            }
            if ((n == 29 || n == 33) && (block.getData() & 8) > 0) {
                PistonBaseMaterial pistonBaseMaterial = (PistonBaseMaterial)block.getState().getData();
                Block block6 = block.getRelative(pistonBaseMaterial.getFacing());
                if (block6.getTypeId() != 0 || block6.setTypeIdAndData(34, n == 29 ? (byte)(block.getData() | 8) : (byte)(block.getData() & 0xFFFFFFF7), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(block6.getTypeId(), 34, block6.getLocation());
            }
            if (n == 34) {
                PistonExtensionMaterial pistonExtensionMaterial = (PistonExtensionMaterial)block.getState().getData();
                Block block7 = block.getRelative(pistonExtensionMaterial.getFacing().getOppositeFace());
                if (block7.getTypeId() != 0 || block7.setTypeIdAndData(pistonExtensionMaterial.isSticky() ? 29 : 33, (byte)(block.getData() | 8), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(block7.getTypeId(), pistonExtensionMaterial.isSticky() ? 29 : 33, block7.getLocation());
            }
            if (n != 18 || (block.getData() & 8) <= 0) return PerformResult.SUCCESS;
            block.setData((byte)(block.getData() & 0xF7));
            return PerformResult.SUCCESS;
        }
    }

    private static enum PerformResult {
        SUCCESS,
        BLACKLISTED,
        NO_ACTION;

    }
}

