/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import java.io.Closeable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MySQLConnectionPool
implements Closeable {
    private static final int poolsize = 10;
    private static final long timeToLive = 300000L;
    private final Vector<JDCConnection> connections;
    private final ConnectionReaper reaper;
    private final String url;
    private final String user;
    private final String password;
    private final Lock lock = new ReentrantLock();

    public MySQLConnectionPool(String string, String string2, String string3) throws ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        this.url = string;
        this.user = string2;
        this.password = string3;
        this.connections = new Vector(10);
        this.reaper = new ConnectionReaper();
        this.reaper.start();
    }

    @Override
    public void close() {
        this.lock.lock();
        Enumeration<JDCConnection> enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            JDCConnection jDCConnection = enumeration.nextElement();
            this.connections.remove(jDCConnection);
            jDCConnection.terminate();
        }
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        this.lock.lock();
        try {
            JDCConnection jDCConnection;
            Enumeration<JDCConnection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                jDCConnection = enumeration.nextElement();
                if (!jDCConnection.lease()) continue;
                if (jDCConnection.isValid()) {
                    JDCConnection jDCConnection2 = jDCConnection;
                    return jDCConnection2;
                }
                this.connections.remove(jDCConnection);
                jDCConnection.terminate();
            }
            jDCConnection = new JDCConnection(DriverManager.getConnection(this.url, this.user, this.password));
            jDCConnection.lease();
            if (!jDCConnection.isValid()) {
                jDCConnection.terminate();
                throw new SQLException("Failed to validate a brand new connection");
            }
            this.connections.add(jDCConnection);
            JDCConnection jDCConnection3 = jDCConnection;
            return jDCConnection3;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reapConnections() {
        this.lock.lock();
        long l = System.currentTimeMillis() - 300000L;
        for (JDCConnection jDCConnection : this.connections) {
            if (!jDCConnection.inUse() || l <= jDCConnection.getLastUse() || jDCConnection.isValid()) continue;
            this.connections.remove(jDCConnection);
        }
        this.lock.unlock();
    }

    private class JDCConnection
    implements Connection {
        private final Connection conn;
        private boolean inuse;
        private long timestamp;
        private int networkTimeout;
        private String schema;

        JDCConnection(Connection connection) {
            this.conn = connection;
            this.inuse = false;
            this.timestamp = 0L;
            this.networkTimeout = 30;
            this.schema = "default";
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.conn.clearWarnings();
        }

        @Override
        public void close() {
            this.inuse = false;
            try {
                if (!this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                MySQLConnectionPool.this.connections.remove(this.conn);
                this.terminate();
            }
        }

        @Override
        public void commit() throws SQLException {
            this.conn.commit();
        }

        @Override
        public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
            return this.conn.createArrayOf(string, objectArray);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.conn.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.conn.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.conn.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.conn.createSQLXML();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.conn.createStatement();
        }

        @Override
        public Statement createStatement(int n, int n2) throws SQLException {
            return this.conn.createStatement(n, n2);
        }

        @Override
        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            return this.conn.createStatement(n, n2, n3);
        }

        @Override
        public Struct createStruct(String string, Object[] objectArray) throws SQLException {
            return this.conn.createStruct(string, objectArray);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.conn.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.conn.getCatalog();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.conn.getClientInfo();
        }

        @Override
        public String getClientInfo(String string) throws SQLException {
            return this.conn.getClientInfo(string);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.conn.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.conn.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.conn.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.conn.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.conn.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.conn.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.conn.isReadOnly();
        }

        @Override
        public boolean isValid(int n) throws SQLException {
            return this.conn.isValid(n);
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this.conn.isWrapperFor(clazz);
        }

        @Override
        public String nativeSQL(String string) throws SQLException {
            return this.conn.nativeSQL(string);
        }

        @Override
        public CallableStatement prepareCall(String string) throws SQLException {
            return this.conn.prepareCall(string);
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            return this.conn.prepareCall(string, n, n2);
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            return this.conn.prepareCall(string, n, n2, n3);
        }

        @Override
        public PreparedStatement prepareStatement(String string) throws SQLException {
            return this.conn.prepareStatement(string);
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            return this.conn.prepareStatement(string, n);
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            return this.conn.prepareStatement(string, n, n2);
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            return this.conn.prepareStatement(string, n, n2, n3);
        }

        @Override
        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            return this.conn.prepareStatement(string, nArray);
        }

        @Override
        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            return this.conn.prepareStatement(string, stringArray);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.conn.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.conn.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.conn.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean bl) throws SQLException {
            this.conn.setAutoCommit(bl);
        }

        @Override
        public void setCatalog(String string) throws SQLException {
            this.conn.setCatalog(string);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.conn.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String string, String string2) throws SQLClientInfoException {
            this.conn.setClientInfo(string, string2);
        }

        @Override
        public void setHoldability(int n) throws SQLException {
            this.conn.setHoldability(n);
        }

        @Override
        public void setReadOnly(boolean bl) throws SQLException {
            this.conn.setReadOnly(bl);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.conn.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String string) throws SQLException {
            return this.conn.setSavepoint(string);
        }

        @Override
        public void setTransactionIsolation(int n) throws SQLException {
            this.conn.setTransactionIsolation(n);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.conn.setTypeMap(map);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return this.conn.unwrap(clazz);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.networkTimeout;
        }

        @Override
        public void setNetworkTimeout(Executor executor, int n) throws SQLException {
            this.networkTimeout = n;
        }

        @Override
        public void abort(Executor executor) throws SQLException {
        }

        @Override
        public String getSchema() throws SQLException {
            return this.schema;
        }

        @Override
        public void setSchema(String string) throws SQLException {
            this.schema = string;
        }

        long getLastUse() {
            return this.timestamp;
        }

        boolean inUse() {
            return this.inuse;
        }

        boolean isValid() {
            try {
                return this.conn.isValid(1);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }

        synchronized boolean lease() {
            if (this.inuse) {
                return false;
            }
            this.inuse = true;
            this.timestamp = System.currentTimeMillis();
            return true;
        }

        void terminate() {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class ConnectionReaper
    extends Thread {
        private ConnectionReaper() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MySQLConnectionPool.this.reapConnections();
            }
        }
    }
}

