/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;

public class Utils {
    public static void download(Logger logger, URL uRL, File file) throws IOException {
        int n;
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        int n2 = uRL.openConnection().getContentLength();
        logger.info("Downloading " + file.getName() + " (" + n2 / 1024 + "kb) ...");
        InputStream inputStream = uRL.openStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = new byte[1024];
        int n3 = 0;
        int n4 = 0;
        long l = System.currentTimeMillis();
        while ((n = inputStream.read(byArray)) >= 0) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            n3 += n;
            if ((int)((System.currentTimeMillis() - l) / 500L) <= n4) continue;
            logger.info((int)((double)n3 / (double)n2 * 100.0) + "%");
            ++n4;
        }
        inputStream.close();
        ((OutputStream)bufferedOutputStream).close();
        logger.info("Download finished");
    }

    public static String readURL(URL uRL) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String listing(String[] stringArray, String string, String string2) {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return stringArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < n - 1; ++i) {
            stringBuilder.append(string + stringArray[i]);
        }
        stringBuilder.append(string2 + stringArray[n - 1]);
        return stringBuilder.toString();
    }

    public static int parseTimeSpec(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1 || stringArray.length > 2) {
            return -1;
        }
        if (stringArray.length == 1 && Utils.isInt(stringArray[0])) {
            return Integer.valueOf(stringArray[0]);
        }
        if (!stringArray[0].contains(":") && !stringArray[0].contains(".")) {
            if (stringArray.length == 2) {
                if (!Utils.isInt(stringArray[0])) {
                    return -1;
                }
                int n = Integer.parseInt(stringArray[0]);
                if (stringArray[1].startsWith("h")) {
                    n *= 60;
                } else if (stringArray[1].startsWith("d")) {
                    n *= 1440;
                }
                return n;
            }
            if (stringArray.length == 1) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 1;
                while (n5 <= stringArray[0].length()) {
                    while (n5 <= stringArray[0].length() && Utils.isInt(stringArray[0].substring(n4, n5))) {
                        ++n5;
                    }
                    if (n5 - 1 != n4) {
                        String string = stringArray[0].substring(n5 - 1, n5).toLowerCase();
                        if (string.equals("d")) {
                            n = Integer.parseInt(stringArray[0].substring(n4, n5 - 1));
                        } else if (string.equals("h")) {
                            n2 = Integer.parseInt(stringArray[0].substring(n4, n5 - 1));
                        } else if (string.equals("m")) {
                            n3 = Integer.parseInt(stringArray[0].substring(n4, n5 - 1));
                        }
                    }
                    n4 = n5++;
                }
                if (n == 0 && n2 == 0 && n3 == 0) {
                    return -1;
                }
                return n3 + n2 * 60 + n * 1440;
            }
            return -1;
        }
        String string = stringArray.length == 1 ? (stringArray[0].contains(":") ? new SimpleDateFormat("dd.MM.yyyy").format(System.currentTimeMillis()) + " " + stringArray[0] : stringArray[0] + " 00:00:00") : stringArray[0] + " " + stringArray[1];
        try {
            return (int)((System.currentTimeMillis() - new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse(string).getTime()) / 60000L);
        }
        catch (ParseException parseException) {
            return -1;
        }
    }

    public static String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(string).append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

