/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block;

import com.bukkit.gemo.FalseBook.Block.Areas.Area;
import com.bukkit.gemo.FalseBook.Block.Areas.AreaSelection;
import com.bukkit.gemo.FalseBook.Block.BridgeArea;
import com.bukkit.gemo.FalseBook.Block.DoorArea;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockCore;
import com.bukkit.gemo.FalseBook.Block.Gate;
import com.bukkit.gemo.FalseBook.Block.Lift;
import com.bukkit.gemo.FalseBook.Block.QueuedExecutionEvent;
import com.gemo.utils.SignUtils;
import com.gemo.utils.UtilPermissions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FalseBookBlockBlockListener
extends BlockListener
implements Runnable {
    public static FalseBookBlockCore plugin;
    private static ArrayList<Area> Areas;
    private static ArrayList<AreaSelection> Selections;
    private static ArrayList<BridgeArea> BridgeAreas;
    private static ArrayList<DoorArea> DoorAreas;
    private static HashMap<String, Block> GateAreas;
    private static ArrayList<QueuedExecutionEvent> queuedEvents;
    private static HashMap<String, Integer> queuedEventsPos;
    private int mainTaskID = -1;

    static {
        Areas = new ArrayList();
        Selections = new ArrayList();
        BridgeAreas = new ArrayList();
        DoorAreas = new ArrayList();
        GateAreas = new HashMap();
        queuedEvents = new ArrayList();
        queuedEventsPos = new HashMap();
    }

    public FalseBookBlockBlockListener(FalseBookBlockCore instance) {
        plugin = instance;
    }

    public boolean checkPistonEvent(List<Block> blockList) {
        int j = 0;
        while (j < blockList.size()) {
            int i = 0;
            while (i < BridgeAreas.size()) {
                if (BridgeAreas.get(i).isBlockInArea(blockList.get(j))) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < DoorAreas.size()) {
                if (DoorAreas.get(i).isBlockInArea(blockList.get(j))) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < Areas.size()) {
                if (Areas.get(i).isProtect() && Areas.get(i).isBlockInArea(blockList.get(j))) {
                    return false;
                }
                ++i;
            }
            if (GateAreas.containsKey(blockList.get(j).getLocation().toString())) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (!this.checkPistonEvent(event.getBlocks())) {
            event.setCancelled(true);
        }
    }

    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        Block block = event.getRetractLocation().getBlock();
        ArrayList<Block> neighbours = new ArrayList<Block>();
        neighbours.add(block);
        if (!this.checkPistonEvent(neighbours)) {
            event.setCancelled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onSignChange(SignChangeEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (event.getBlock().getTypeId() != Material.WALL_SIGN.getId() && event.getBlock().getTypeId() != Material.SIGN_POST.getId()) {
            return;
        }
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        if ((event.getLine(1).equalsIgnoreCase("[Bridge]") || event.getLine(1).equalsIgnoreCase("[Bridge End]")) && plugin.isBridgeEnabled(worldName)) {
            int w;
            if (SignUtils.getDirection((Sign)((Sign)event.getBlock().getState())) == -1) {
                event.setCancelled(true);
                event.getBlock().setTypeId(0);
                ItemStack item = new ItemStack(Material.SIGN, 1);
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage(ChatColor.RED + "Bridge signs may only be created at specific angles (90 degrees).");
                return;
            }
            if (event.getLine(1).equalsIgnoreCase("[Bridge]")) {
                event.setLine(1, "[Bridge]");
            }
            if (event.getLine(1).equalsIgnoreCase("[Bridge End]")) {
                event.setLine(1, "[Bridge End]");
            }
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.bridge")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build bridges.");
                return;
            }
            if (event.getLine(2).length() > 0) {
                try {
                    w = Integer.valueOf(event.getLine(2));
                    if (w < 0) {
                        SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be >= 0, or leave it empty.");
                        return;
                    }
                    if (w > FalseBookBlockCore.getMaxBridgeSideWidth(worldName)) {
                        SignUtils.cancelSignCreation((SignChangeEvent)event, (String)("Line 3 must be <= " + FalseBookBlockCore.getMaxBridgeSideWidth(worldName)));
                        return;
                    }
                    if (w == 1) {
                        event.setLine(2, "");
                    }
                }
                catch (Exception e) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be a number. Or leave it empty.");
                    return;
                }
            }
            if (event.getLine(3).length() <= 0) return;
            try {
                w = Integer.valueOf(event.getLine(3));
                if (w < 0) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 4 must be >= 0, or leave it empty.");
                    return;
                }
                if (w > FalseBookBlockCore.getMaxBridgeSideWidth(worldName)) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)("Line 4 must be <= " + FalseBookBlockCore.getMaxBridgeSideWidth(worldName)));
                    return;
                }
                if (w != 1) return;
                event.setLine(3, "");
                return;
            }
            catch (Exception e) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 4 must be a number. Or leave it empty.");
                return;
            }
        }
        if (event.getLine(1).equalsIgnoreCase("[Door Up]") && plugin.isDoorEnabled(worldName)) {
            int w;
            if (event.getBlock().getData() != 0 && event.getBlock().getData() != 4 && event.getBlock().getData() != 8 && event.getBlock().getData() != 12) {
                event.setCancelled(true);
                event.getBlock().setTypeId(0);
                ItemStack item = new ItemStack(Material.SIGN, 1);
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage(ChatColor.RED + "Door signs may only be created at specific angles (90 degrees).");
                return;
            }
            event.setLine(1, "[Door Up]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.door")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build doors.");
                return;
            }
            if (event.getLine(2).length() > 0) {
                try {
                    w = Integer.valueOf(event.getLine(2));
                    if (w < 0) {
                        SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be >= 0, or leave it empty.");
                        return;
                    }
                    if (w > FalseBookBlockCore.getMaxDoorSideWidth(worldName)) {
                        SignUtils.cancelSignCreation((SignChangeEvent)event, (String)("Line 3 must be <= " + FalseBookBlockCore.getMaxBridgeSideWidth(worldName)));
                        return;
                    }
                    if (w == 1) {
                        event.setLine(2, "");
                    }
                }
                catch (Exception e) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be a number. Or leave it empty.");
                    return;
                }
            }
            if (event.getLine(3).length() <= 0) return;
            try {
                w = Integer.valueOf(event.getLine(3));
                if (w < 0) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 4 must be >= 0, or leave it empty.");
                    return;
                }
                if (w > FalseBookBlockCore.getMaxDoorSideWidth(worldName)) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)("Line 4 must be <= " + FalseBookBlockCore.getMaxBridgeSideWidth(worldName)));
                    return;
                }
                if (w != 1) return;
                event.setLine(3, "");
                return;
            }
            catch (Exception e) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 4 must be a number. Or leave it empty.");
                return;
            }
        }
        if (event.getLine(1).equalsIgnoreCase("[Door Down]") && plugin.isDoorEnabled(worldName)) {
            if (event.getBlock().getData() != 0 && event.getBlock().getData() != 4 && event.getBlock().getData() != 8 && event.getBlock().getData() != 12) {
                event.setCancelled(true);
                event.getBlock().setTypeId(0);
                ItemStack item = new ItemStack(Material.SIGN, 1);
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage(ChatColor.RED + "Door signs may only be created at specific angles (90 degrees).");
                return;
            }
            event.setLine(1, "[Door Down]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.door")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build doors.");
                return;
            }
            if (event.getLine(2).length() > 0) {
                try {
                    int w = Integer.valueOf(event.getLine(2));
                    if (w < 0) {
                        SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be >= 0, or leave it empty.");
                        return;
                    }
                    if (w > FalseBookBlockCore.getMaxDoorSideWidth(worldName)) {
                        SignUtils.cancelSignCreation((SignChangeEvent)event, (String)("Line 3 must be <= " + FalseBookBlockCore.getMaxBridgeSideWidth(worldName)));
                        return;
                    }
                    if (w == 1) {
                        event.setLine(2, "");
                    }
                }
                catch (Exception e) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be a number. Or leave it empty.");
                }
            }
            if (event.getLine(3).length() <= 0) return;
            try {
                int w = Integer.valueOf(event.getLine(3));
                if (w < 0) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 4 must be >= 0, or leave it empty.");
                    return;
                }
                if (w > FalseBookBlockCore.getMaxDoorSideWidth(worldName)) {
                    SignUtils.cancelSignCreation((SignChangeEvent)event, (String)("Line 4 must be <= " + FalseBookBlockCore.getMaxBridgeSideWidth(worldName)));
                    return;
                }
                if (w != 1) return;
                event.setLine(3, "");
                return;
            }
            catch (Exception e) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 4 must be a number. Or leave it empty.");
                return;
            }
        }
        if (event.getLine(1).equalsIgnoreCase("[Toggle]")) {
            event.setLine(1, "[Toggle]");
            if (UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) return;
            SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build toggleable areas.");
            return;
        }
        if (event.getLine(1).equalsIgnoreCase("[Area]")) {
            event.setLine(1, "[Area]");
            if (UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) return;
            SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build toggleable areas.");
            return;
        }
        if (event.getLine(1).equalsIgnoreCase("[Gate]") && plugin.isGateEnabled(worldName)) {
            event.setLine(1, "[Gate]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.gate")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build gates.");
                return;
            }
            try {
                int TypeID = FalseBookBlockCore.getAllowedGateBlocks(event.getBlock().getWorld().getName()).get(0);
                if (event.getLine(2).length() > 0) {
                    TypeID = Integer.valueOf(event.getLine(2));
                }
                if (Gate.isBlockTypeAllowed(TypeID, event.getBlock().getWorld().getName())) return;
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"This blocktype is not allowed for building gates.");
                return;
            }
            catch (Exception e) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be an integer or blank.");
                return;
            }
        }
        if (event.getLine(1).equalsIgnoreCase("[DGate]") && plugin.isGateEnabled(worldName)) {
            event.setLine(1, "[DGate]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.gate")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build gates.");
                return;
            }
            try {
                int TypeID = FalseBookBlockCore.getAllowedGateBlocks(event.getBlock().getWorld().getName()).get(0);
                if (event.getLine(2).length() > 0) {
                    TypeID = Integer.valueOf(event.getLine(2));
                }
                if (Gate.isBlockTypeAllowed(TypeID, event.getBlock().getWorld().getName())) return;
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"This blocktype is not allowed for building gates.");
                return;
            }
            catch (Exception e) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"Line 3 must be an integer or blank.");
                return;
            }
        }
        if ((event.getLine(1).equalsIgnoreCase("[i]") || event.getLine(1).equalsIgnoreCase("[|]")) && FalseBookBlockCore.isLightswitchEnabled(worldName)) {
            event.setLine(1, event.getLine(1).toUpperCase());
            if (UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.lightswitch.create")) return;
            SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build a lightswitch.");
            return;
        }
        if (event.getLine(1).equalsIgnoreCase("[Lift Up]")) {
            event.setLine(1, "[Lift Up]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.lift")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build Elevators.");
                return;
            }
            if (Lift.searchLiftDown(event.getBlock())) {
                player.sendMessage(ChatColor.GREEN + "Elevatorsign created and linked.");
                return;
            } else {
                player.sendMessage(ChatColor.GRAY + "Elevatorsign created but not linked yet.");
            }
            return;
        } else if (event.getLine(1).equalsIgnoreCase("[Lift Down]")) {
            event.setLine(1, "[Lift Down]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.lift")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build Elevators.");
                return;
            }
            if (Lift.searchLiftUp(event.getBlock())) {
                player.sendMessage(ChatColor.GREEN + "Elevatorsign created and linked.");
                return;
            } else {
                player.sendMessage(ChatColor.GRAY + "Elevatorsign created but not linked yet.");
            }
            return;
        } else {
            if (!event.getLine(1).equalsIgnoreCase("[Lift]")) return;
            event.setLine(1, "[Lift]");
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.lift")) {
                SignUtils.cancelSignCreation((SignChangeEvent)event, (String)"You are not allowed to build Elevators.");
                return;
            }
            if (Lift.searchLiftUp(event.getBlock()) || Lift.searchLiftDown(event.getBlock())) {
                player.sendMessage(ChatColor.GREEN + "Elevatorsign created and linked.");
                return;
            } else {
                player.sendMessage(ChatColor.GRAY + "Elevatorsign created but not linked yet.");
            }
        }
    }

    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        this.doRedstoneEvent(block.getRelative(1, 0, 0), event);
        this.doRedstoneEvent(block.getRelative(-1, 0, 0), event);
        this.doRedstoneEvent(block.getRelative(0, 0, 1), event);
        this.doRedstoneEvent(block.getRelative(0, 0, -1), event);
        this.doRedstoneEvent(block.getRelative(1, 1, 0), event);
        this.doRedstoneEvent(block.getRelative(-1, 1, 0), event);
        this.doRedstoneEvent(block.getRelative(1, -1, 0), event);
        this.doRedstoneEvent(block.getRelative(-1, -1, 0), event);
        this.doRedstoneEvent(block.getRelative(0, -1, 1), event);
        this.doRedstoneEvent(block.getRelative(0, -1, -1), event);
        this.doRedstoneEvent(block.getRelative(0, 1, 1), event);
        this.doRedstoneEvent(block.getRelative(0, 1, -1), event);
    }

    public void doRedstoneEvent(Block block, BlockRedstoneEvent event) {
        if (block.getTypeId() != Material.WALL_SIGN.getId() && block.getTypeId() != Material.SIGN_POST.getId()) {
            return;
        }
        if (queuedEventsPos.containsKey(block.getLocation().toString())) {
            return;
        }
        queuedEventsPos.put(block.getLocation().toString(), 0);
        queuedEvents.add(new QueuedExecutionEvent(plugin, block, event.getBlock().getLocation()));
        if (this.mainTaskID == -1) {
            this.mainTaskID = plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)this, 1L);
        }
    }

    @Override
    public void run() {
        for (QueuedExecutionEvent event : queuedEvents) {
            event.Execute();
            queuedEventsPos.remove(event.getLocation().toString());
        }
        queuedEvents.clear();
        this.mainTaskID = -1;
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        boolean isOp = UtilPermissions.playerCanUseCommand((Player)event.getPlayer(), (String)"falsebook.destroy.blocks");
        int i = 0;
        while (i < Areas.size()) {
            if (Areas.get(i).isProtect() && Areas.get(i).isBlockInArea(event.getBlock()) && !isOp) {
                event.setCancelled(true);
                break;
            }
            ++i;
        }
    }

    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        boolean isOp = UtilPermissions.playerCanUseCommand((Player)event.getPlayer(), (String)"falsebook.destroy.blocks");
        int i = 0;
        while (i < Areas.size()) {
            if (Areas.get(i).isProtect() && Areas.get(i).isBlockInArea(event.getBlock()) && !isOp) {
                event.setCancelled(true);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < BridgeAreas.size()) {
            if (BridgeAreas.get(i).isBlockInArea(event.getBlock()) && !isOp) {
                event.setCancelled(true);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < DoorAreas.size()) {
            if (DoorAreas.get(i).isBlockInArea(event.getBlock()) && !isOp) {
                event.setCancelled(true);
                return;
            }
            ++i;
        }
        if (GateAreas.containsKey(event.getBlock().getLocation().toString())) {
            if (!isOp) {
                event.setCancelled(true);
                return;
            }
            GateAreas.remove(event.getBlock().getLocation().toString());
            this.saveGates();
        }
        if (event.getBlock().getTypeId() == Material.WALL_SIGN.getId()) {
            Sign sign = (Sign)event.getBlock().getState();
            Player player = event.getPlayer();
            if ((sign.getLine(1).equalsIgnoreCase("[i]") || sign.getLine(1).equalsIgnoreCase("[|]")) && !UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.lightswitch.create")) {
                player.sendMessage(ChatColor.RED + "You are not allowed to destroy lightswitchsigns.");
                event.setCancelled(true);
                return;
            }
            if ((sign.getLine(1).equalsIgnoreCase("[Area]") || sign.getLine(1).equalsIgnoreCase("[Toggle]")) && !UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) {
                player.sendMessage(ChatColor.RED + "You are not allowed to destroy areasigns.");
                event.setCancelled(true);
                return;
            }
            if ((sign.getLine(1).equalsIgnoreCase("[Bridge]") || sign.getLine(1).equalsIgnoreCase("[Bridge End]")) && !UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.bridge")) {
                player.sendMessage(ChatColor.RED + "You are not allowed to destroy bridgesigns.");
                event.setCancelled(true);
                return;
            }
            if ((sign.getLine(1).equalsIgnoreCase("[Door Up]") || sign.getLine(1).equalsIgnoreCase("[Door Down]")) && !UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.door")) {
                player.sendMessage(ChatColor.RED + "You are not allowed to destroy doorsigns.");
                event.setCancelled(true);
                return;
            }
            if ((sign.getLine(1).equalsIgnoreCase("[Gate]") || sign.getLine(1).equalsIgnoreCase("[DGate]")) && !UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.gate")) {
                player.sendMessage(ChatColor.RED + "You are not allowed to destroy gatesigns.");
                event.setCancelled(true);
                return;
            }
            if ((sign.getLine(1).equalsIgnoreCase("[Lift Up]") || sign.getLine(1).equalsIgnoreCase("[Lift Down]") || sign.getLine(1).equalsIgnoreCase("[Lift]")) && !UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.lift")) {
                player.sendMessage(ChatColor.RED + "You are not allowed to destroy liftsigns.");
                event.setCancelled(true);
                return;
            }
        }
        if (event.getBlock().getType().equals((Object)Material.LEAVES) && FalseBookBlockCore.getAppleDropChance(event.getBlock().getWorld().getName()) > 0.0f) {
            Random random = new Random();
            if (random.nextFloat() * 100.0f <= FalseBookBlockCore.getAppleDropChance(event.getBlock().getWorld().getName())) {
                ItemStack item = new ItemStack(Material.APPLE, 1);
                event.getBlock().getWorld().dropItem(event.getBlock().getLocation(), item);
            }
            Object var3_5 = null;
        }
    }

    public static ArrayList<Area> getAreas() {
        return Areas;
    }

    public static ArrayList<AreaSelection> getSelection() {
        return Selections;
    }

    public static ArrayList<BridgeArea> getBridgeAreas() {
        return BridgeAreas;
    }

    public static ArrayList<DoorArea> getDoorAreas() {
        return DoorAreas;
    }

    public static HashMap<String, Block> getGateAreas() {
        return GateAreas;
    }

    public static boolean LocationEquals(Location loc1, Location loc2) {
        return loc1.getBlockX() == loc2.getBlockX() && loc1.getBlockY() == loc2.getBlockY() && loc1.getBlockZ() == loc2.getBlockZ() && loc1.getWorld() == loc2.getWorld();
    }

    public static int isInDoorList(DoorArea a) {
        int i = 0;
        while (i < DoorAreas.size()) {
            DoorArea a2 = DoorAreas.get(i);
            if (FalseBookBlockBlockListener.LocationEquals(a.getSign1().getBlock().getLocation(), a2.getSign1().getBlock().getLocation()) && FalseBookBlockBlockListener.LocationEquals(a.getSign2().getBlock().getLocation(), a2.getSign2().getBlock().getLocation()) || FalseBookBlockBlockListener.LocationEquals(a.getSign1().getBlock().getLocation(), a2.getSign2().getBlock().getLocation()) && FalseBookBlockBlockListener.LocationEquals(a.getSign2().getBlock().getLocation(), a2.getSign1().getBlock().getLocation())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isDoorActive(Sign signBlock) {
        int i = 0;
        while (i < DoorAreas.size()) {
            DoorArea a2 = DoorAreas.get(i);
            if (FalseBookBlockBlockListener.LocationEquals(a2.getSign1().getBlock().getLocation(), signBlock.getBlock().getLocation()) || FalseBookBlockBlockListener.LocationEquals(a2.getSign2().getBlock().getLocation(), signBlock.getBlock().getLocation())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void saveGates() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter("plugins/FalseBook/Gates.db"));
            output.write("GateCount=" + GateAreas.values().size() + "\r\n");
            int i = 0;
            while (i < GateAreas.values().size()) {
                String str = "";
                str = String.valueOf(((Block)GateAreas.values().toArray()[i]).getX()) + "," + ((Block)GateAreas.values().toArray()[i]).getY() + "," + ((Block)GateAreas.values().toArray()[i]).getZ() + ";";
                str = String.valueOf(str) + ((Block)GateAreas.values().toArray()[i]).getWorld().getName() + ";";
                output.write(String.valueOf(str) + "\r\n");
                ++i;
            }
            ((Writer)output).close();
        }
        catch (IOException e) {
            FalseBookBlockCore.printInConsole("Error while saving file: plugins/FalseBook/Gates.db");
            e.printStackTrace();
        }
    }

    public boolean loadGates() {
        File f = new File("plugins/FalseBook/Gates.db");
        if (f.exists()) {
            String strLine;
            BufferedReader br;
            block7: {
                FileInputStream fstream = new FileInputStream("plugins/FalseBook/Gates.db");
                DataInputStream in = new DataInputStream(fstream);
                br = new BufferedReader(new InputStreamReader(in));
                strLine = br.readLine();
                if (strLine != null) break block7;
                FalseBookBlockCore.printInConsole("No Gates loaded");
                return false;
            }
            try {
                String[] split = strLine.split("=");
                int count = Integer.valueOf(split[1]);
                int i = 0;
                while (i < count) {
                    String[] splitData;
                    strLine = br.readLine();
                    if (strLine != null && (splitData = strLine.split(";")).length == 2) {
                        String[] sign1 = splitData[0].split(",");
                        String worldName = splitData[1];
                        Block block = FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign1[0]).intValue(), Integer.valueOf(sign1[1]).intValue(), Integer.valueOf(sign1[2]).intValue());
                        if (Gate.isBlockTypeAllowed(block.getTypeId(), worldName)) {
                            GateAreas.put(block.getLocation().toString(), block);
                        }
                    }
                    ++i;
                }
                FalseBookBlockCore.printInConsole(String.valueOf(GateAreas.values().size()) + " protected gateblocks successfully loaded.");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                FalseBookBlockCore.printInConsole("Error while reading file: plugins/FalseBook/Gates.db");
                return false;
            }
        }
        return false;
    }

    public void saveDoors() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter("plugins/FalseBook/Doors.db"));
            output.write("DoorCount=" + DoorAreas.size() + "\r\n");
            int i = 0;
            while (i < DoorAreas.size()) {
                String str = "";
                str = String.valueOf(DoorAreas.get(i).getSign1().getBlock().getX()) + "," + DoorAreas.get(i).getSign1().getBlock().getY() + "," + DoorAreas.get(i).getSign1().getBlock().getZ() + ";";
                str = String.valueOf(str) + DoorAreas.get(i).getSign2().getBlock().getX() + "," + DoorAreas.get(i).getSign2().getBlock().getY() + "," + DoorAreas.get(i).getSign2().getBlock().getZ() + ";";
                str = String.valueOf(str) + DoorAreas.get(i).getSign1().getBlock().getWorld().getName();
                output.write(String.valueOf(str) + "\r\n");
                ++i;
            }
            ((Writer)output).close();
        }
        catch (IOException e) {
            FalseBookBlockCore.printInConsole("Error while saving file: plugins/FalseBook/Doors.db");
            e.printStackTrace();
        }
    }

    public boolean loadDoors() {
        File f = new File("plugins/FalseBook/Doors.db");
        if (f.exists()) {
            String strLine;
            BufferedReader br;
            block24: {
                FileInputStream fstream = new FileInputStream("plugins/FalseBook/Doors.db");
                DataInputStream in = new DataInputStream(fstream);
                br = new BufferedReader(new InputStreamReader(in));
                strLine = br.readLine();
                if (strLine != null) break block24;
                FalseBookBlockCore.printInConsole("No Doors loaded");
                return false;
            }
            try {
                String[] split = strLine.split("=");
                int count = Integer.valueOf(split[1]);
                int i = 0;
                while (i < count) {
                    String[] splitData;
                    strLine = br.readLine();
                    if (strLine != null && (splitData = strLine.split(";")).length == 3) {
                        String[] sign1 = splitData[0].split(",");
                        String[] sign2 = splitData[1].split(",");
                        String worldName = splitData[2];
                        if (FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign1[0]).intValue(), Integer.valueOf(sign1[1]).intValue(), Integer.valueOf(sign1[2]).intValue()).getType().equals((Object)Material.SIGN_POST) && FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign2[0]).intValue(), Integer.valueOf(sign2[1]).intValue(), Integer.valueOf(sign2[2]).intValue()).getType().equals((Object)Material.SIGN_POST)) {
                            int j;
                            int k;
                            int dir;
                            Sign firstSign;
                            Block second;
                            Block first;
                            World w;
                            Sign signBlock1 = (Sign)FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign1[0]).intValue(), Integer.valueOf(sign1[1]).intValue(), Integer.valueOf(sign1[2]).intValue()).getState();
                            Sign signBlock2 = (Sign)FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign2[0]).intValue(), Integer.valueOf(sign2[1]).intValue(), Integer.valueOf(sign2[2]).intValue()).getState();
                            DoorArea now = new DoorArea(signBlock1, signBlock2);
                            int left = 1;
                            int right = 1;
                            if (signBlock1.getLine(2).length() > 0) {
                                left = Integer.valueOf(signBlock1.getLine(2));
                            }
                            if (signBlock1.getLine(3).length() > 0) {
                                right = Integer.valueOf(signBlock1.getLine(3));
                            }
                            if (signBlock1.getRawData() == 0 || signBlock1.getRawData() == 8) {
                                w = FalseBookBlockCore.server.getWorld(worldName);
                                if (signBlock1.getLine(1).equalsIgnoreCase("[Door Up]")) {
                                    first = w.getBlockAt(signBlock1.getX(), signBlock1.getY() + 1, signBlock1.getZ());
                                    second = w.getBlockAt(signBlock2.getX(), signBlock2.getY() - 1, signBlock2.getZ());
                                } else {
                                    first = w.getBlockAt(signBlock2.getX(), signBlock2.getY() + 1, signBlock2.getZ());
                                    second = w.getBlockAt(signBlock1.getX(), signBlock1.getY() - 1, signBlock1.getZ());
                                }
                                now.addBlock(w.getBlockAt(first.getX(), first.getY(), first.getZ()));
                                now.addBlock(w.getBlockAt(first.getX(), first.getY() - 1, first.getZ()));
                                now.addBlock(w.getBlockAt(first.getX(), first.getY() - 2, first.getZ()));
                                now.addBlock(w.getBlockAt(second.getX(), second.getY(), second.getZ()));
                                now.addBlock(w.getBlockAt(second.getX(), second.getY() + 1, second.getZ()));
                                firstSign = (Sign)first.getWorld().getBlockAt(first.getX(), first.getY() - 1, first.getZ()).getState();
                                dir = 1;
                                if (firstSign.getRawData() == 8) {
                                    dir = -1;
                                }
                                k = 0;
                                while (k <= Math.abs(first.getY() - second.getY())) {
                                    now.addBlock(w.getBlockAt(first.getX(), first.getY() + k, first.getZ()));
                                    j = 1;
                                    while (j <= left) {
                                        now.addBlock(w.getBlockAt(first.getX() + j * -dir, first.getY() + k, first.getZ()));
                                        ++j;
                                    }
                                    j = 1;
                                    while (j <= right) {
                                        now.addBlock(w.getBlockAt(first.getX() + j * dir, first.getY() + k, first.getZ()));
                                        ++j;
                                    }
                                    ++k;
                                }
                            } else if (signBlock1.getRawData() == 4 || signBlock1.getRawData() == 12) {
                                w = FalseBookBlockCore.server.getWorld(worldName);
                                if (signBlock1.getLine(1).equalsIgnoreCase("[Door Up]")) {
                                    first = w.getBlockAt(signBlock1.getX(), signBlock1.getY() + 1, signBlock1.getZ());
                                    second = w.getBlockAt(signBlock2.getX(), signBlock2.getY() - 1, signBlock2.getZ());
                                } else {
                                    first = w.getBlockAt(signBlock2.getX(), signBlock2.getY() + 1, signBlock2.getZ());
                                    second = w.getBlockAt(signBlock1.getX(), signBlock1.getY() - 1, signBlock1.getZ());
                                }
                                now.addBlock(w.getBlockAt(first.getX(), first.getY(), first.getZ()));
                                now.addBlock(w.getBlockAt(first.getX(), first.getY() - 1, first.getZ()));
                                now.addBlock(w.getBlockAt(first.getX(), first.getY() - 2, first.getZ()));
                                now.addBlock(w.getBlockAt(second.getX(), second.getY(), second.getZ()));
                                now.addBlock(w.getBlockAt(second.getX(), second.getY() + 1, second.getZ()));
                                firstSign = (Sign)first.getWorld().getBlockAt(first.getX(), first.getY() - 1, first.getZ()).getState();
                                dir = 1;
                                if (firstSign.getRawData() == 12) {
                                    dir = -1;
                                }
                                k = 0;
                                while (k <= Math.abs(first.getY() - second.getY())) {
                                    now.addBlock(w.getBlockAt(first.getX(), first.getY() + k, first.getZ()));
                                    j = 1;
                                    while (j <= left) {
                                        now.addBlock(w.getBlockAt(first.getX(), first.getY() + k, first.getZ() + j * -dir));
                                        ++j;
                                    }
                                    j = 1;
                                    while (j <= right) {
                                        now.addBlock(w.getBlockAt(first.getX(), first.getY() + k, first.getZ() + j * dir));
                                        ++j;
                                    }
                                    ++k;
                                }
                            }
                            DoorAreas.add(now);
                        }
                    }
                    ++i;
                }
                FalseBookBlockCore.printInConsole(String.valueOf(DoorAreas.size()) + " Doors successfully loaded.");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                FalseBookBlockCore.printInConsole("Error while reading file: plugins/FalseBook/Doors.db");
                return false;
            }
        }
        return false;
    }

    public static int isInBridgeList(BridgeArea a) {
        int i = 0;
        while (i < BridgeAreas.size()) {
            BridgeArea a2 = BridgeAreas.get(i);
            if ((FalseBookBlockBlockListener.LocationEquals(a.getSign1().getBlock().getLocation(), a2.getSign1().getBlock().getLocation()) && FalseBookBlockBlockListener.LocationEquals(a.getSign2().getBlock().getLocation(), a2.getSign2().getBlock().getLocation()) || FalseBookBlockBlockListener.LocationEquals(a.getSign1().getBlock().getLocation(), a2.getSign2().getBlock().getLocation()) && FalseBookBlockBlockListener.LocationEquals(a.getSign2().getBlock().getLocation(), a2.getSign1().getBlock().getLocation())) && a.getUp() == a2.getUp()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isBridgeActive(Sign signBlock) {
        int i = 0;
        while (i < BridgeAreas.size()) {
            BridgeArea a2 = BridgeAreas.get(i);
            if (FalseBookBlockBlockListener.LocationEquals(a2.getSign1().getBlock().getLocation(), signBlock.getBlock().getLocation()) || FalseBookBlockBlockListener.LocationEquals(a2.getSign2().getBlock().getLocation(), signBlock.getBlock().getLocation())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void saveBridges() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter("plugins/FalseBook/Bridges.db"));
            output.write("BridgesCount=" + BridgeAreas.size() + "\r\n");
            int i = 0;
            while (i < BridgeAreas.size()) {
                String str = "";
                str = String.valueOf(BridgeAreas.get(i).getSign1().getBlock().getX()) + "," + BridgeAreas.get(i).getSign1().getBlock().getY() + "," + BridgeAreas.get(i).getSign1().getBlock().getZ() + ";";
                str = String.valueOf(str) + BridgeAreas.get(i).getSign2().getBlock().getX() + "," + BridgeAreas.get(i).getSign2().getBlock().getY() + "," + BridgeAreas.get(i).getSign2().getBlock().getZ() + ";";
                str = String.valueOf(str) + BridgeAreas.get(i).getUp() + ";";
                str = String.valueOf(str) + BridgeAreas.get(i).getSign1().getBlock().getWorld().getName();
                output.write(String.valueOf(str) + "\r\n");
                ++i;
            }
            ((Writer)output).close();
        }
        catch (IOException e) {
            FalseBookBlockCore.printInConsole("Error while saving file: plugins/FalseBook/Bridges.db");
            e.printStackTrace();
        }
    }

    public boolean loadBridges() {
        File f = new File("plugins/FalseBook/Bridges.db");
        if (f.exists()) {
            String strLine;
            BufferedReader br;
            block41: {
                FileInputStream fstream = new FileInputStream("plugins/FalseBook/Bridges.db");
                DataInputStream in = new DataInputStream(fstream);
                br = new BufferedReader(new InputStreamReader(in));
                strLine = br.readLine();
                if (strLine != null) break block41;
                FalseBookBlockCore.printInConsole("No Bridges loaded");
                return false;
            }
            try {
                String[] split = strLine.split("=");
                int count = Integer.valueOf(split[1]);
                int i = 0;
                while (i < count) {
                    String[] splitData;
                    strLine = br.readLine();
                    if (strLine != null && (splitData = strLine.split(";")).length == 4) {
                        String[] sign1 = splitData[0].split(",");
                        String[] sign2 = splitData[1].split(",");
                        Boolean isUp = Boolean.valueOf(splitData[2]);
                        String worldName = splitData[3];
                        if (FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign1[0]).intValue(), Integer.valueOf(sign1[1]).intValue(), Integer.valueOf(sign1[2]).intValue()).getType().equals((Object)Material.SIGN_POST) && FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign2[0]).intValue(), Integer.valueOf(sign2[1]).intValue(), Integer.valueOf(sign2[2]).intValue()).getType().equals((Object)Material.SIGN_POST)) {
                            int j;
                            int k;
                            Block under;
                            World w;
                            int xDir;
                            int zDir;
                            Sign signBlock1 = (Sign)FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign1[0]).intValue(), Integer.valueOf(sign1[1]).intValue(), Integer.valueOf(sign1[2]).intValue()).getState();
                            Sign signBlock2 = (Sign)FalseBookBlockCore.server.getWorld(worldName).getBlockAt(Integer.valueOf(sign2[0]).intValue(), Integer.valueOf(sign2[1]).intValue(), Integer.valueOf(sign2[2]).intValue()).getState();
                            BridgeArea now = new BridgeArea(signBlock1, signBlock2);
                            now.setUp(isUp);
                            int left = 1;
                            int right = 1;
                            if (signBlock1.getLine(2) != null && signBlock1.getLine(2).length() > 0) {
                                left = Integer.valueOf(signBlock1.getLine(2));
                            }
                            if (signBlock1.getLine(3) != null && signBlock1.getLine(3).length() > 0) {
                                right = Integer.valueOf(signBlock1.getLine(3));
                            }
                            if (isUp.booleanValue()) {
                                zDir = 0;
                                xDir = 0;
                                if (signBlock1.getRawData() == 0) {
                                    zDir = -1;
                                } else if (signBlock1.getRawData() == 4) {
                                    xDir = 1;
                                } else if (signBlock1.getRawData() == 8) {
                                    zDir = 1;
                                } else if (signBlock1.getRawData() == 12) {
                                    xDir = -1;
                                }
                                w = FalseBookBlockCore.server.getWorld(worldName);
                                under = w.getBlockAt(signBlock1.getX(), signBlock1.getY() + 1, signBlock1.getZ());
                                if (zDir != 0) {
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() - 1, under.getZ()));
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() - 2, under.getZ()));
                                    k = 0;
                                    while (k <= Math.abs(signBlock1.getZ() - signBlock2.getZ())) {
                                        now.addBlock(w.getBlockAt(under.getX(), under.getY(), under.getZ() + k * zDir));
                                        j = 1;
                                        while (j <= left) {
                                            now.addBlock(w.getBlockAt(under.getX() + j * zDir, under.getY(), under.getZ() + k * zDir));
                                            ++j;
                                        }
                                        j = 1;
                                        while (j <= right) {
                                            now.addBlock(w.getBlockAt(under.getX() + j * -zDir, under.getY(), under.getZ() + k * zDir));
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() - 1, under.getZ() + (k - 1) * zDir));
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() - 2, under.getZ() + (k - 1) * zDir));
                                } else {
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() - 1, under.getZ()));
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() - 2, under.getZ()));
                                    k = 0;
                                    while (k <= Math.abs(signBlock1.getX() - signBlock2.getX())) {
                                        now.addBlock(w.getBlockAt(under.getX() + k * xDir, under.getY(), under.getZ()));
                                        j = 1;
                                        while (j <= left) {
                                            now.addBlock(w.getBlockAt(under.getX() + k * xDir, under.getY(), under.getZ() + j * -xDir));
                                            ++j;
                                        }
                                        j = 1;
                                        while (j <= right) {
                                            now.addBlock(w.getBlockAt(under.getX() + k * xDir, under.getY(), under.getZ() + j * xDir));
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    now.addBlock(w.getBlockAt(under.getX() + (k - 1) * xDir, under.getY() - 1, under.getZ()));
                                    now.addBlock(w.getBlockAt(under.getX() + (k - 1) * xDir, under.getY() - 2, under.getZ()));
                                }
                            } else {
                                zDir = 0;
                                xDir = 0;
                                if (signBlock1.getRawData() == 0) {
                                    zDir = -1;
                                } else if (signBlock1.getRawData() == 4) {
                                    xDir = 1;
                                } else if (signBlock1.getRawData() == 8) {
                                    zDir = 1;
                                } else if (signBlock1.getRawData() == 12) {
                                    xDir = -1;
                                }
                                w = FalseBookBlockCore.server.getWorld(worldName);
                                under = w.getBlockAt(signBlock1.getX(), signBlock1.getY() - 1, signBlock1.getZ());
                                if (zDir != 0) {
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() + 1, under.getZ()));
                                    k = 0;
                                    while (k <= Math.abs(signBlock1.getZ() - signBlock2.getZ())) {
                                        now.addBlock(w.getBlockAt(under.getX(), under.getY(), under.getZ() + k * zDir));
                                        j = 1;
                                        while (j <= left) {
                                            now.addBlock(w.getBlockAt(under.getX() + j * zDir, under.getY(), under.getZ() + k * zDir));
                                            ++j;
                                        }
                                        j = 1;
                                        while (j <= right) {
                                            now.addBlock(w.getBlockAt(under.getX() + j * -zDir, under.getY(), under.getZ() + k * zDir));
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() + 1, under.getZ() + (k - 1) * zDir));
                                } else {
                                    now.addBlock(w.getBlockAt(under.getX(), under.getY() + 1, under.getZ()));
                                    k = 0;
                                    while (k <= Math.abs(signBlock1.getX() - signBlock2.getX())) {
                                        now.addBlock(w.getBlockAt(under.getX() + k * xDir, under.getY(), under.getZ()));
                                        j = 1;
                                        while (j <= left) {
                                            now.addBlock(w.getBlockAt(under.getX() + k * xDir, under.getY(), under.getZ() + j * -xDir));
                                            ++j;
                                        }
                                        j = 1;
                                        while (j <= right) {
                                            now.addBlock(w.getBlockAt(under.getX() + k * xDir, under.getY(), under.getZ() + j * xDir));
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    now.addBlock(w.getBlockAt(under.getX() + (k - 1) * xDir, under.getY() + 1, under.getZ()));
                                }
                            }
                            BridgeAreas.add(now);
                        }
                    }
                    ++i;
                }
                FalseBookBlockCore.printInConsole(String.valueOf(BridgeAreas.size()) + " Bridges successfully loaded.");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                FalseBookBlockCore.printInConsole("Error while reading file: plugins/FalseBook/Bridges.db");
                return false;
            }
        }
        return false;
    }
}

