/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block;

import com.bukkit.gemo.FalseBook.Block.FalseBookBlockBlockListener;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockCore;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class Gate {
    public static boolean isBlockTypeAllowed(int ID, String worldName) {
        ArrayList<Integer> list = FalseBookBlockCore.getAllowedGateBlocks(worldName);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == ID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int toggleGate(Block origin, boolean DGate, boolean override, boolean newStatus, int thisID) {
        if (!Gate.isBlockTypeAllowed(thisID, origin.getWorld().getName())) {
            return 0;
        }
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>();
        int ySearch = 16;
        int xzSearch = 3;
        if (DGate) {
            xzSearch = 1;
            ySearch = 2;
        }
        boolean gateFound = false;
        int yOrigin = origin.getY();
        int x = -xzSearch;
        while (x <= xzSearch) {
            int z = -xzSearch;
            while (z <= xzSearch) {
                if (!visited.containsKey(String.valueOf(x) + "_" + z) && Gate.getTopFence(origin, x, yOrigin, z, ySearch, thisID) != null) {
                    Gate.searchColumn(origin, x, yOrigin, z, override, newStatus, visited, null, thisID);
                    gateFound = true;
                    return 1;
                }
                ++z;
            }
            ++x;
        }
        visited.clear();
        visited = null;
        if (gateFound) {
            return 1;
        }
        return -1;
    }

    public static void searchColumn(Block origin, int xOffset, int y, int zOffset, boolean override, boolean newStatus, HashMap<String, Boolean> visited, Block lastTop, int GateTypeID) {
        Block topFence = Gate.getTopFence(origin, xOffset, y, zOffset, 16, GateTypeID);
        if (topFence == null) {
            return;
        }
        if (lastTop != null && Math.abs(lastTop.getY() - topFence.getY()) > 5) {
            return;
        }
        if (visited.containsKey(String.valueOf(topFence.getX()) + "_" + topFence.getZ())) {
            return;
        }
        visited.put(String.valueOf(topFence.getX()) + "_" + topFence.getZ(), false);
        if (Math.abs(xOffset) > FalseBookBlockCore.getMaxGateWidth(origin.getWorld().getName()) || Math.abs(zOffset) > FalseBookBlockCore.getMaxGateWidth(origin.getWorld().getName())) {
            return;
        }
        int TypeID = -1;
        Block block = null;
        boolean off = newStatus;
        if (!override) {
            off = topFence.getRelative(0, -1, 0).getTypeId() == GateTypeID;
        }
        int i = 1;
        while (i <= 16) {
            block = topFence.getRelative(0, -i, 0);
            TypeID = block.getTypeId();
            if (TypeID != Material.AIR.getId() && TypeID != GateTypeID && TypeID != Material.WATER.getId() && TypeID != Material.STATIONARY_WATER.getId() && TypeID != Material.LAVA.getId() && TypeID != Material.STATIONARY_LAVA.getId()) break;
            if (off) {
                block.setTypeIdAndData(Material.AIR.getId(), (byte)0, true);
                FalseBookBlockBlockListener.getGateAreas().remove(block.getLocation().toString());
                FalseBookBlockBlockListener.getGateAreas().remove(topFence.getLocation().toString());
            } else {
                block.setTypeIdAndData(GateTypeID, (byte)0, true);
                FalseBookBlockBlockListener.getGateAreas().put(block.getLocation().toString(), block);
                FalseBookBlockBlockListener.getGateAreas().put(topFence.getLocation().toString(), topFence);
            }
            ++i;
        }
        int tX = -1;
        while (tX <= 1) {
            int tZ = -1;
            while (tZ <= 1) {
                Gate.searchColumn(origin, xOffset + tX, y, zOffset + tZ, override, newStatus, visited, topFence, GateTypeID);
                ++tZ;
            }
            ++tX;
        }
    }

    public static Block getTopFence(Block origin, int xOffset, int y, int zOffset, int searchWidth, int TypeID) {
        int i = 0;
        while (i <= searchWidth) {
            if (y + i <= 127 && origin.getRelative(xOffset, i, zOffset).getTypeId() == TypeID && origin.getRelative(xOffset, i + 1, zOffset).getTypeId() != TypeID && (origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.AIR.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == TypeID || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.WATER.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.STATIONARY_WATER.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.LAVA.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.STATIONARY_LAVA.getId())) {
                return origin.getRelative(xOffset, i, zOffset);
            }
            ++i;
        }
        i = -1;
        while (i >= -searchWidth) {
            if (y + i >= 2 && origin.getRelative(xOffset, i, zOffset).getTypeId() == TypeID && origin.getRelative(xOffset, i + 1, zOffset).getTypeId() != TypeID && (origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.AIR.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == TypeID || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.WATER.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.STATIONARY_WATER.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.LAVA.getId() || origin.getRelative(xOffset, i - 1, zOffset).getTypeId() == Material.STATIONARY_LAVA.getId())) {
                return origin.getRelative(xOffset, i, zOffset);
            }
            --i;
        }
        return null;
    }
}

