/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.material.MaterialData;
import org.bukkit.material.PistonBaseMaterial;

public class LWCBlockListener
extends BlockListener {
    private LWCPlugin plugin;

    public LWCBlockListener(LWCPlugin plugin) {
        this.plugin = plugin;
    }

    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        Protection protection = lwc.findProtection(block);
        if (protection == null) {
            return;
        }
        Module.Result result = lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.REDSTONE, protection, block, event.getOldCurrent());
        LWCRedstoneEvent evt = new LWCRedstoneEvent(event, protection);
        lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled() || result == Module.Result.CANCEL) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    public void onSignChange(SignChangeEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block == null) {
            return;
        }
        Protection protection = lwc.findProtection(block);
        if (protection == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtection(player, protection);
        if (!canAccess) {
            event.setCancelled(true);
        }
    }

    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material material = block.getType();
        boolean ignoreBlockDestruction = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(material, "ignoreBlockDestruction"));
        if (ignoreBlockDestruction) {
            return;
        }
        Protection protection = lwc.findProtection(block);
        if (protection == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtection(player, protection);
        boolean canAdmin = lwc.canAdminProtection(player, protection);
        try {
            Module.Result result = lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.DESTROY_PROTECTION, player, protection, block, canAccess, canAdmin);
            LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, canAccess, canAdmin);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled() || result == Module.Result.CANCEL) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "BLOCK_BREAK");
            e.printStackTrace();
        }
    }

    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block piston = event.getBlock();
        BlockState state = piston.getState();
        MaterialData data = state.getData();
        if (!(data instanceof PistonBaseMaterial)) {
            return;
        }
        BlockFace direction = ((PistonBaseMaterial)data).getFacing();
        Block block = event.getBlock().getRelative(direction);
        Protection protection = lwc.findProtection(block);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        if (block.getType() == Material.CHEST && lwc.findAdjacentDoubleChest(block) != null) {
            event.setCancelled(true);
            return;
        }
        if (!lwc.isProtectable(block)) {
            return;
        }
        String autoRegisterType = this.plugin.getLWC().resolveProtectionConfiguration(block.getType(), "autoRegister");
        if (!autoRegisterType.equalsIgnoreCase("private") && !autoRegisterType.equalsIgnoreCase("public")) {
            return;
        }
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + autoRegisterType, "lwc.create", "lwc.protect")) {
            return;
        }
        int type = 0;
        if (autoRegisterType.equalsIgnoreCase("private")) {
            type = 2;
        }
        if (block.getType() == Material.CHEST) {
            BlockFace[] faces;
            for (BlockFace blockFace : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                Block face = block.getRelative(blockFace);
                if (face.getType() != Material.CHEST || lwc.getPhysicalDatabase().loadProtection(face.getWorld().getName(), face.getX(), face.getY(), face.getZ()) == null) continue;
                return;
            }
        }
        try {
            Module.Result registerProtection = lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.REGISTER_PROTECTION, player, block);
            LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, block);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled() || registerProtection == Module.Result.CANCEL) {
                return;
            }
            Protection protection = lwc.getPhysicalDatabase().registerProtection(block.getTypeId(), type, block.getWorld().getName(), player.getName(), "", block.getX(), block.getY(), block.getZ());
            lwc.sendLocale((CommandSender)player, "protection.onplace.create.finalize", "type", lwc.getLocale(autoRegisterType.toLowerCase(), new Object[0]), "block", LWC.materialToString(block));
            if (protection != null) {
                lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.POST_REGISTRATION, protection);
                lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
            }
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }
}

