/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.griefcraft.listeners.LWCBlockListener;
import com.griefcraft.listeners.LWCEntityListener;
import com.griefcraft.listeners.LWCPlayerListener;
import com.griefcraft.listeners.LWCServerListener;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.util.LWCResourceBundle;
import com.griefcraft.util.LocaleClassLoader;
import com.griefcraft.util.StringUtils;
import com.griefcraft.util.UTF8Control;
import com.griefcraft.util.Updater;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.server.ServerListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LWCPlugin
extends JavaPlugin {
    private BlockListener blockListener;
    private EntityListener entityListener;
    private PlayerListener playerListener;
    private ServerListener serverListener;
    private LWCResourceBundle locale;
    private Logger logger = Logger.getLogger("LWC");
    private LWC lwc;
    private Updater updater;

    public LWCPlugin() {
        this.log("Loading shared objects");
        this.updater = new Updater();
        this.lwc = new LWC(this);
        this.playerListener = new LWCPlayerListener(this);
        this.blockListener = new LWCBlockListener(this);
        this.entityListener = new LWCEntityListener(this);
        this.serverListener = new LWCServerListener(this);
        System.setProperty("org.sqlite.lib.path", this.updater.getOSSpecificFolder());
        System.setProperty("sqlite.purejava", "");
        String isPureJava = System.getProperty("lwc.purejava");
        if (isPureJava != null && isPureJava.equalsIgnoreCase("true")) {
            System.setProperty("sqlite.purejava", "true");
        }
        this.log("Native library: " + this.updater.getFullNativeLibraryPath());
    }

    public ResourceBundle getLocale() {
        return this.locale;
    }

    public LWC getLWC() {
        return this.lwc;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public boolean isValidCommand(String name) {
        if ((name = name.toLowerCase()).equals("lwc")) {
            return true;
        }
        if (name.equals("cpublic")) {
            return true;
        }
        if (name.equals("cpassword")) {
            return true;
        }
        if (name.equals("cprivate")) {
            return true;
        }
        if (name.equals("cinfo")) {
            return true;
        }
        if (name.equals("cmodify")) {
            return true;
        }
        if (name.equals("cunlock")) {
            return true;
        }
        if (name.equals("cremove")) {
            return true;
        }
        if (name.equals("climits")) {
            return true;
        }
        if (name.equals("credstone")) {
            return true;
        }
        if (name.equals("cmagnet")) {
            return true;
        }
        if (name.equals("cdroptransfer")) {
            return true;
        }
        if (name.equals("cpersist")) {
            return true;
        }
        if (name.equals("cnospam")) {
            return true;
        }
        if (name.equals("cexempt")) {
            return true;
        }
        return name.equals("cadmin");
    }

    public void loadDatabase() {
        String database = this.lwc.getConfiguration().getString("database.adapter");
        Database.DefaultType = database.equals("mysql") ? Database.Type.MySQL : Database.Type.SQLite;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase();
        String argString = StringUtils.join(args, 0);
        boolean isPlayer = sender instanceof Player;
        if (!this.isValidCommand(commandName)) {
            return false;
        }
        if (isPlayer) {
            String aliasCommand = null;
            String[] aliasArgs = new String[]{};
            if (commandName.equals("cpublic")) {
                aliasCommand = "create";
                aliasArgs = new String[]{"public"};
            } else if (commandName.equals("cpassword")) {
                aliasCommand = "create";
                aliasArgs = ("password " + argString).split(" ");
            } else if (commandName.equals("cprivate")) {
                aliasCommand = "create";
                aliasArgs = ("private " + argString).split(" ");
            } else if (commandName.equals("cmodify")) {
                aliasCommand = "modify";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cinfo")) {
                aliasCommand = "info";
            } else if (commandName.equals("cunlock")) {
                aliasCommand = "unlock";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cremove")) {
                aliasCommand = "remove";
                aliasArgs = new String[]{"protection"};
            } else if (commandName.equals("climits")) {
                aliasCommand = "limits";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cadmin")) {
                aliasCommand = "admin";
                String[] stringArray = aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            }
            if (commandName.equals("credstone")) {
                aliasCommand = "flag";
                aliasArgs = ("redstone " + argString).split(" ");
            } else if (commandName.equals("cmagnet")) {
                aliasCommand = "flag";
                aliasArgs = ("magnet " + argString).split(" ");
            } else if (commandName.equals("cexempt")) {
                aliasCommand = "flag";
                aliasArgs = ("exemption " + argString).split(" ");
            }
            if (commandName.equals("cdroptransfer")) {
                aliasCommand = "mode";
                aliasArgs = ("droptransfer " + argString).split(" ");
            } else if (commandName.equals("cpersist")) {
                aliasCommand = "mode";
                aliasArgs = ("persist " + argString).split(" ");
            } else if (commandName.equals("cnospam")) {
                aliasCommand = "mode";
                aliasArgs = ("nospam " + argString).split(" ");
            }
            if (aliasCommand != null) {
                this.lwc.getModuleLoader().dispatchEvent(new LWCCommandEvent(sender, aliasCommand, aliasArgs));
                this.lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.COMMAND, sender, aliasCommand, aliasArgs);
                return true;
            }
        }
        if (args.length == 0) {
            this.lwc.sendFullHelp(sender);
            return true;
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = sender;
        objectArray[1] = args[0].toLowerCase();
        String[] stringArray = objectArray[2] = args.length > 1 ? StringUtils.join(args, 1).split(" ") : new String[]{};
        if (this.lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.COMMAND, objectArray) == Module.Result.CANCEL) {
            return true;
        }
        LWCCommandEvent evt = new LWCCommandEvent(sender, args[0].toLowerCase(), args.length > 1 ? StringUtils.join(args, 1).split(" ") : new String[]{});
        this.lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            return true;
        }
        if (!isPlayer) {
            sender.sendMessage("\u00a74That LWC command is not supported through the console :-)");
            return true;
        }
        return false;
    }

    public void onDisable() {
        LWC.ENABLED = false;
        if (this.lwc != null) {
            this.lwc.destruct();
        }
    }

    public void onEnable() {
        String version = this.getDescription().getVersion();
        LWCInfo.setVersion(version);
        LWC.ENABLED = true;
        String localization = this.lwc.getConfiguration().getString("core.locale");
        try {
            ResourceBundle defaultBundle = null;
            ResourceBundle optionalBundle = null;
            defaultBundle = ResourceBundle.getBundle("lang.lwc", new Locale("en"), new UTF8Control());
            try {
                optionalBundle = ResourceBundle.getBundle("lang.lwc", new Locale(localization), new UTF8Control());
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (defaultBundle == optionalBundle) {
                optionalBundle = null;
            }
            this.locale = new LWCResourceBundle(defaultBundle);
            if (optionalBundle != null) {
                this.locale.addExtensionBundle(optionalBundle);
            }
        }
        catch (MissingResourceException e) {
            this.log("We are missing the default locale in LWC.jar.. What happened to it? :-(");
            throw e;
        }
        ResourceBundle optionalBundle = null;
        try {
            optionalBundle = ResourceBundle.getBundle("lwc", new Locale(localization), new LocaleClassLoader(), new UTF8Control());
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (optionalBundle != null) {
            this.locale.addExtensionBundle(optionalBundle);
            this.log("Loaded override bundle: " + optionalBundle.getLocale().toString());
        }
        int overrides = optionalBundle != null ? optionalBundle.keySet().size() : 0;
        this.log("Loaded " + this.locale.keySet().size() + " locale strings (" + overrides + " overrides)");
        this.loadDatabase();
        this.registerEvents();
        this.lwc.load();
        this.updater.loadVersions(true);
        this.log("At version: " + LWCInfo.FULL_VERSION);
    }

    private void log(String str) {
        this.logger.info("LWC: " + str);
    }

    private void registerEvent(Listener listener, Event.Type eventType) {
        this.registerEvent(listener, eventType, Event.Priority.Highest);
    }

    private void registerEvent(Listener listener, Event.Type eventType, Event.Priority priority) {
        this.getServer().getPluginManager().registerEvent(eventType, listener, priority, (Plugin)this);
    }

    private void registerEvents() {
        this.registerEvent((Listener)this.playerListener, Event.Type.PLAYER_QUIT, Event.Priority.Monitor);
        this.registerEvent((Listener)this.playerListener, Event.Type.PLAYER_DROP_ITEM);
        this.registerEvent((Listener)this.playerListener, Event.Type.PLAYER_INTERACT);
        this.registerEvent((Listener)this.playerListener, Event.Type.PLAYER_CHAT);
        this.registerEvent((Listener)this.entityListener, Event.Type.ENTITY_EXPLODE);
        this.registerEvent((Listener)this.blockListener, Event.Type.BLOCK_BREAK);
        this.registerEvent((Listener)this.blockListener, Event.Type.BLOCK_PLACE);
        this.registerEvent((Listener)this.blockListener, Event.Type.REDSTONE_CHANGE);
        this.registerEvent((Listener)this.blockListener, Event.Type.SIGN_CHANGE);
        this.registerEvent((Listener)this.blockListener, Event.Type.BLOCK_PISTON_EXTEND);
        this.registerEvent((Listener)this.serverListener, Event.Type.PLUGIN_DISABLE);
    }
}

