/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;

public class AdminCleanup
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("cleanup")) {
            return;
        }
        event.setCancelled(true);
        boolean silent = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("silent")) {
            silent = true;
        }
        lwc.sendLocale(sender, "protection.admin.cleanup.start", "count", lwc.getPhysicalDatabase().getProtectionCount());
        new Admin_Cleanup_Thread(lwc, sender, silent).run();
    }

    private static class Admin_Cleanup_Thread
    implements Runnable {
        private LWC lwc;
        private CommandSender sender;
        private boolean silent;

        public Admin_Cleanup_Thread(LWC lwc, CommandSender sender, boolean silent) {
            this.lwc = lwc;
            this.sender = sender;
            this.silent = silent;
        }

        public void push(List<Integer> toRemove) throws SQLException {
            StringBuilder builder = new StringBuilder();
            int total = toRemove.size();
            int count = 0;
            Iterator<Integer> iter = toRemove.iterator();
            String prefix = this.lwc.getPhysicalDatabase().getPrefix();
            Statement statement = this.lwc.getPhysicalDatabase().getConnection().createStatement();
            while (iter.hasNext()) {
                int protectionId = iter.next();
                if (count % 100000 == 0) {
                    builder.append("DELETE FROM " + prefix + "protections WHERE id IN (" + protectionId);
                } else {
                    builder.append("," + protectionId);
                }
                if (count % 100000 == 99999 || count == total - 1) {
                    builder.append(")");
                    statement.executeUpdate(builder.toString());
                    builder.setLength(0);
                    this.sender.sendMessage("\u00a72REMOVED " + (count + 1) + " / " + total);
                }
                ++count;
            }
            statement.close();
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int completed = 0;
            int count = 0;
            LinkedList<Integer> toRemove = new LinkedList<Integer>();
            int totalProtections = this.lwc.getPhysicalDatabase().getProtectionCount();
            this.sender.sendMessage("Loading protections via STREAM mode");
            try {
                Statement resultStatement = this.lwc.getPhysicalDatabase().getConnection().createStatement(1003, 1007);
                if (this.lwc.getPhysicalDatabase().getType() == Database.Type.MySQL) {
                    resultStatement.setFetchSize(Integer.MIN_VALUE);
                }
                String prefix = this.lwc.getPhysicalDatabase().getPrefix();
                ResultSet result = resultStatement.executeQuery("SELECT " + prefix + "protections.id AS protectionId, " + prefix + "protections.type AS protectionType, x, y, z, flags, blockId, world, owner, password, date, last_accessed FROM " + prefix + "protections");
                while (result.next()) {
                    Protection protection = this.lwc.getPhysicalDatabase().resolveProtectionNoRights(result);
                    World world = protection.getBukkitWorld();
                    if (++count % 100000 == 0 || count == totalProtections || count == 1) {
                        this.sender.sendMessage("\u00a74" + count + " / " + totalProtections);
                    }
                    if (world == null) {
                        if (this.silent) continue;
                        this.lwc.sendLocale(this.sender, "protection.admin.cleanup.noworld", "world", protection.getWorld());
                        continue;
                    }
                    Block block = protection.getBlock();
                    if (block != null && this.lwc.isProtectable(block)) continue;
                    toRemove.add(protection.getId());
                    ++completed;
                    if (this.silent) continue;
                    this.lwc.sendLocale(this.sender, "protection.admin.cleanup.removednoexist", "protection", protection.toString());
                }
                result.close();
                resultStatement.close();
                this.push(toRemove);
            }
            catch (Exception e) {
                this.sender.sendMessage("Uh-oh, something bad happened while cleaning up the LWC database!");
                this.lwc.sendLocale(this.sender, "protection.internalerror", "id", "cleanup");
                e.printStackTrace();
            }
            long finish = System.currentTimeMillis();
            float timeInSeconds = (float)(finish - start) / 1000.0f;
            this.lwc.sendLocale(this.sender, "protection.admin.cleanup.complete", "count", completed, "seconds", Float.valueOf(timeInSeconds));
        }

        private List<Protection> getAll(List<Protection> protections, String world, int x, int y, int z) {
            ArrayList<Protection> tmp = new ArrayList<Protection>();
            for (Protection protection : protections) {
                if (protection.getWorld() == null || world == null || !protection.getWorld().equals(world) || protection.getX() != x || protection.getY() != y || protection.getZ() != z) continue;
                tmp.add(protection);
            }
            return tmp;
        }
    }
}

