/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.modes;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCCommandEvent;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DropTransferModule
extends JavaModule {
    private LWC lwc;

    @Override
    public void load(LWC lwc) {
        this.lwc = lwc;
    }

    private boolean isPlayerDropTransferring(String player) {
        return this.lwc.getMemoryDatabase().hasMode(player, "+dropTransfer");
    }

    private int getPlayerDropTransferTarget(String player) {
        String target = this.lwc.getMemoryDatabase().getModeData(player, "dropTransfer");
        try {
            return Integer.parseInt(target);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public Module.Result onDropItem(LWC lwc, Player player, Item item, ItemStack itemStack) {
        int protectionId = this.getPlayerDropTransferTarget(player.getName());
        if (protectionId == -1) {
            return DEFAULT;
        }
        if (!this.isPlayerDropTransferring(player.getName())) {
            return DEFAULT;
        }
        Protection protection = lwc.getPhysicalDatabase().loadProtection(protectionId);
        if (protection == null) {
            player.sendMessage("\u00a74Protection no longer exists");
            lwc.getMemoryDatabase().unregisterMode(player.getName(), "dropTransfer");
            return DEFAULT;
        }
        World world = player.getServer().getWorld(protection.getWorld());
        if (world == null) {
            player.sendMessage("\u00a74Invalid world!");
            lwc.getMemoryDatabase().unregisterMode(player.getName(), "dropTransfer");
            return DEFAULT;
        }
        Block block = world.getBlockAt(protection.getX(), protection.getY(), protection.getZ());
        Map<Integer, ItemStack> remaining = lwc.depositItems(block, itemStack);
        if (remaining.size() > 0) {
            player.sendMessage("Chest could not hold all the items! Have the remaining items back.");
            for (ItemStack temp : remaining.values()) {
                player.getInventory().addItem(new ItemStack[]{temp});
            }
        }
        player.updateInventory();
        item.remove();
        return DEFAULT;
    }

    @Override
    public Module.Result onProtectionInteract(LWC lwc, Player player, Protection protection, List<String> actions, boolean canAccess, boolean canAdmin) {
        if (!actions.contains("dropTransferSelect")) {
            return DEFAULT;
        }
        if (!canAccess) {
            lwc.sendLocale((CommandSender)player, "protection.interact.dropxfer.noaccess", new Object[0]);
        } else {
            if (protection.getBlockId() != Material.CHEST.getId()) {
                lwc.sendLocale((CommandSender)player, "protection.interact.dropxfer.notchest", new Object[0]);
                lwc.getMemoryDatabase().unregisterAllActions(player.getName());
                return CANCEL;
            }
            lwc.getMemoryDatabase().registerMode(player.getName(), "dropTransfer", protection.getId() + "");
            lwc.getMemoryDatabase().registerMode(player.getName(), "+dropTransfer");
            lwc.sendLocale((CommandSender)player, "protection.interact.dropxfer.finalize", new Object[0]);
        }
        lwc.getMemoryDatabase().unregisterAllActions(player.getName());
        return DEFAULT;
    }

    @Override
    public Module.Result onBlockInteract(LWC lwc, Player player, Block block, List<String> actions) {
        if (!actions.contains("dropTransferSelect")) {
            return DEFAULT;
        }
        lwc.sendLocale((CommandSender)player, "protection.interact.dropxfer.notprotected", new Object[0]);
        lwc.getMemoryDatabase().unregisterAllActions(player.getName());
        return DEFAULT;
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (!event.hasFlag("p", "mode")) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        Player player = (Player)sender;
        String mode = args[0].toLowerCase();
        if (!mode.equals("droptransfer")) {
            return;
        }
        event.setCancelled(true);
        mode = "dropTransfer";
        if (args.length < 2) {
            lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.help", new Object[0]);
            return;
        }
        String action = args[1].toLowerCase();
        String playerName = player.getName();
        if (action.equals("select")) {
            if (this.isPlayerDropTransferring(playerName)) {
                lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.select.error", new Object[0]);
                return;
            }
            lwc.getMemoryDatabase().unregisterMode(playerName, mode);
            lwc.getMemoryDatabase().registerAction("dropTransferSelect", playerName, "");
            lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.select.finalize", new Object[0]);
        } else if (action.equals("on")) {
            int target = this.getPlayerDropTransferTarget(playerName);
            if (target == -1) {
                lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.selectchest", new Object[0]);
                return;
            }
            lwc.getMemoryDatabase().registerMode(playerName, "+dropTransfer");
            lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.on.finalize", new Object[0]);
        } else if (action.equals("off")) {
            int target = this.getPlayerDropTransferTarget(playerName);
            if (target == -1) {
                lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.selectchest", new Object[0]);
                return;
            }
            lwc.getMemoryDatabase().unregisterMode(playerName, "+dropTransfer");
            lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.off.finalize", new Object[0]);
        } else if (action.equals("status")) {
            if (this.getPlayerDropTransferTarget(playerName) == -1) {
                lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.status.off", new Object[0]);
            } else if (this.isPlayerDropTransferring(playerName)) {
                lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.status.active", new Object[0]);
            } else {
                lwc.sendLocale((CommandSender)player, "protection.modes.dropxfer.status.inactive", new Object[0]);
            }
        }
    }
}

