/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.worldguard;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.util.config.Configuration;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.GlobalRegionManager;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardModule
extends JavaModule {
    private Configuration configuration = Configuration.load("worldguard.yml");
    private WorldGuardPlugin worldGuard = null;

    @Override
    public void load(LWC lwc) {
        Plugin plugin = lwc.getPlugin().getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin != null) {
            this.worldGuard = (WorldGuardPlugin)plugin;
        }
    }

    @Override
    public Module.Result onRegisterProtection(LWC lwc, Player player, Block block) {
        if (this.worldGuard == null) {
            return DEFAULT;
        }
        if (!this.configuration.getBoolean("worldguard.enabled", false)) {
            return DEFAULT;
        }
        try {
            GlobalRegionManager regions = this.worldGuard.getGlobalRegionManager();
            RegionManager regionManager = regions.get(player.getWorld());
            Class<?> bukkitUtil = this.worldGuard.getClass().getClassLoader().loadClass("com.sk89q.worldguard.bukkit.BukkitUtil");
            Method toVector = bukkitUtil.getMethod("toVector", Block.class);
            Vector blockVector = (Vector)toVector.invoke(null, block);
            List regionSet = regionManager.getApplicableRegionsIDs(blockVector);
            List<String> allowedRegions = this.configuration.getStringList("worldguard.regions", new ArrayList<String>());
            boolean deny = true;
            if (allowedRegions.contains("*") && regionSet.size() > 0) {
                return ALLOW;
            }
            for (String region : regionSet) {
                if (!allowedRegions.contains(region)) continue;
                deny = false;
                break;
            }
            if (deny) {
                player.sendMessage("\u00a74You cannot protect that " + LWC.materialToString(block) + " outside of WorldGuard regions");
                return CANCEL;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return DEFAULT;
    }

    public void set(String path, Object value) {
        this.configuration.setProperty(path, value);
    }

    public boolean save() {
        return this.configuration.save();
    }
}

