/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.cache.LRUCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.AccessRight;
import com.griefcraft.model.History;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.sql.Column;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.Table;
import com.griefcraft.util.Performance;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bukkit.entity.Player;

public class PhysDB
extends Database {
    public PhysDB() {
    }

    public PhysDB(Database.Type currentType) {
        super(currentType);
    }

    @Override
    protected void postPrepare() {
        Performance.addPhysDBQuery();
    }

    public int countRightsForProtection(int protectionId) {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "rights WHERE chest=?", "count", protectionId) + "");
    }

    public Object fetch(String sql, String column, Object ... toBind) {
        try {
            int index = 1;
            PreparedStatement statement = this.prepare(sql);
            for (Object bind : toBind) {
                statement.setObject(index, bind);
                ++index;
            }
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                Object object = set.getObject(column);
                set.close();
                return object;
            }
            set.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return null;
    }

    public String getMenuStyle(String player) {
        try {
            PreparedStatement statement = this.prepare("SELECT menu FROM " + this.prefix + "menu_styles WHERE player = ?");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                String style = set.getString("menu");
                set.close();
                return style;
            }
            set.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return LWC.getInstance().getConfiguration().getString("core.defaultMenuStyle");
    }

    @Deprecated
    public int getPrivateAccess(int type, int protectionId, String ... entities) {
        int access = -1;
        try {
            PreparedStatement statement = this.prepare("SELECT entity, rights FROM " + this.prefix + "rights WHERE type = ? AND chest = ?");
            statement.setInt(1, type);
            statement.setInt(2, protectionId);
            ResultSet set = statement.executeQuery();
            block2: while (set.next()) {
                String entity = set.getString("entity");
                for (String str : entities) {
                    if (!str.equalsIgnoreCase(entity)) continue;
                    access = set.getInt("rights");
                    break block2;
                }
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return access;
    }

    public int getProtectionCount() {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "protections", "count", new Object[0]).toString());
    }

    public int getHistoryCount() {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "history", "count", new Object[0]).toString());
    }

    public int getProtectionCount(String player) {
        int amount = 0;
        try {
            PreparedStatement statement = this.prepare("SELECT id FROM " + this.prefix + "protections WHERE owner = ?");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                ++amount;
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return amount;
    }

    public int getProtectionCount(String player, int blockId) {
        int amount = 0;
        try {
            PreparedStatement statement = this.prepare("SELECT id FROM " + this.prefix + "protections WHERE owner = ? AND blockId = ?");
            statement.setString(1, player);
            statement.setInt(2, blockId);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                ++amount;
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return amount;
    }

    public int getRightsCount() {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "rights", "count", new Object[0]) + "");
    }

    @Override
    public void load() {
        if (this.loaded) {
            return;
        }
        this.doUpdate140();
        this.doUpdate150();
        this.doUpdate170();
        this.doUpdate220();
        this.doUpdate301();
        this.doUpdate302();
        this.doUpdate330();
        this.doBetaUpdate340();
        try {
            this.connection.setAutoCommit(false);
            Table protections = new Table(this, "protections");
            Column column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            protections.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("flags");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("blockId");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("world");
            column.setType("VARCHAR(255)");
            protections.add(column);
            column = new Column("owner");
            column.setType("VARCHAR(255)");
            protections.add(column);
            column = new Column("password");
            column.setType("VARCHAR(255)");
            protections.add(column);
            column = new Column("x");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("y");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("z");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("date");
            column.setType("VARCHAR(255)");
            protections.add(column);
            column = new Column("last_accessed");
            column.setType("INTEGER");
            protections.add(column);
            Table rights = new Table(this, "rights");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            rights.add(column);
            column = new Column("chest");
            column.setType("INTEGER");
            rights.add(column);
            column = new Column("entity");
            column.setType("TEXT");
            rights.add(column);
            column = new Column("rights");
            column.setType("INTEGER");
            rights.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            rights.add(column);
            Table menuStyles = new Table(this, "menu_styles");
            column = new Column("player");
            column.setType("VARCHAR(255)");
            column.setPrimary(true);
            column.setAutoIncrement(false);
            menuStyles.add(column);
            column = new Column("menu");
            column.setType("VARCHAR(255)");
            menuStyles.add(column);
            Table history = new Table(this, "history");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            history.add(column);
            column = new Column("protectionId");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("player");
            column.setType("VARCHAR(255)");
            history.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("status");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("metadata");
            column.setType("VARCHAR(255)");
            history.add(column);
            column = new Column("timestamp");
            column.setType("long");
            history.add(column);
            Table tasks = new Table(this, "tasks");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            tasks.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            tasks.add(column);
            column = new Column("data");
            column.setType("VARCHAR(255)");
            tasks.add(column);
            protections.execute();
            rights.execute();
            menuStyles.execute();
            history.execute();
            this.connection.commit();
            this.doIndexes();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        try {
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            this.printException(e);
        }
        this.doUpdate100();
        this.loaded = true;
    }

    public List<AccessRight> loadAccessRights(int protectionId, int start, int max) {
        ArrayList<AccessRight> accessRights = new ArrayList<AccessRight>();
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "rights WHERE chest = ? ORDER BY rights DESC LIMIT ?,?");
            statement.setInt(1, protectionId);
            statement.setInt(2, start);
            statement.setInt(3, max);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                AccessRight accessRight = new AccessRight();
                accessRight.setId(set.getInt("id"));
                accessRight.setProtectionId(protectionId);
                accessRight.setName(set.getString("entity"));
                accessRight.setRights(set.getInt("rights"));
                accessRight.setType(set.getInt("type"));
                accessRights.add(accessRight);
            }
            set.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return accessRights;
    }

    public Protection loadProtection(int protectionId) {
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest WHERE " + this.prefix + "protections.id = ?");
            statement.setInt(1, protectionId);
            return this.resolveProtection(statement);
        }
        catch (SQLException e) {
            this.printException(e);
            return null;
        }
    }

    public List<Protection> loadProtectionsUsingType(int type) {
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest WHERE " + this.prefix + "protections.type = ?");
            statement.setInt(1, type);
            return this.resolveProtections(statement);
        }
        catch (SQLException e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public Protection resolveProtectionNoRights(ResultSet set) {
        if (set == null) {
            return null;
        }
        Protection protection = new Protection();
        try {
            int protectionId = set.getInt("protectionId");
            int x = set.getInt("x");
            int y = set.getInt("y");
            int z = set.getInt("z");
            int flags = set.getInt("flags");
            int blockId = set.getInt("blockId");
            int type = set.getInt("protectionType");
            String world = set.getString("world");
            String owner = set.getString("owner");
            String password = set.getString("password");
            String date = set.getString("date");
            long lastAccessed = set.getLong("last_accessed");
            protection.setId(protectionId);
            protection.setX(x);
            protection.setY(y);
            protection.setZ(z);
            protection.setFlags(flags);
            protection.setBlockId(blockId);
            protection.setType(type);
            protection.setWorld(world);
            protection.setOwner(owner);
            protection.setData(password);
            protection.setDate(date);
            protection.setLastAccessed(lastAccessed);
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return protection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Protection> resolveProtections(PreparedStatement statement) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        int lastId = -1;
        ResultSet set = null;
        Protection protection = null;
        boolean init = true;
        try {
            set = statement.executeQuery();
            while (set.next()) {
                String entity;
                int protectionId = set.getInt("protectionId");
                if (lastId != protectionId) {
                    if (protection != null) {
                        protections.add(protection);
                    }
                    lastId = protectionId;
                    init = true;
                    protection = new Protection();
                }
                if (init) {
                    int x = set.getInt("x");
                    int y = set.getInt("y");
                    int z = set.getInt("z");
                    int flags = set.getInt("flags");
                    int blockId = set.getInt("blockId");
                    int type = set.getInt("protectionType");
                    String world = set.getString("world");
                    String owner = set.getString("owner");
                    String password = set.getString("password");
                    String date = set.getString("date");
                    long lastAccessed = set.getLong("last_accessed");
                    protection.setId(protectionId);
                    protection.setX(x);
                    protection.setY(y);
                    protection.setZ(z);
                    protection.setFlags(flags);
                    protection.setBlockId(blockId);
                    protection.setType(type);
                    protection.setWorld(world);
                    protection.setOwner(owner);
                    protection.setData(password);
                    protection.setDate(date);
                    protection.setLastAccessed(lastAccessed);
                    init = false;
                }
                if ((entity = set.getString("entity")) == null) continue;
                int rightsId = set.getInt("rightsId");
                int rights = set.getInt("rights");
                int type = set.getInt("rightsType");
                AccessRight right = new AccessRight();
                right.setId(rightsId);
                right.setProtectionId(protectionId);
                right.setName(entity);
                right.setRights(rights);
                right.setType(type);
                protection.addAccessRight(right);
            }
            if (protection != null && !protections.contains(protection)) {
                protections.add(protection);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (set != null) {
                try {
                    set.close();
                }
                catch (SQLException e) {}
            }
        }
        return protections;
    }

    private Protection resolveProtection(PreparedStatement statement) {
        List<Protection> protections = this.resolveProtections(statement);
        if (protections.size() == 0) {
            return null;
        }
        return protections.get(0);
    }

    public void precache() {
        LWC lwc = LWC.getInstance();
        LRUCache<String, Protection> cache = lwc.getCaches().getProtections();
        cache.clear();
        int precacheSize = lwc.getConfiguration().getInt("core.precache", -1);
        if (precacheSize == -1) {
            precacheSize = lwc.getConfiguration().getInt("core.cacheSize", 10000);
        }
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest ORDER BY " + this.prefix + "protections.id DESC LIMIT ?");
            statement.setInt(1, precacheSize);
            statement.setFetchSize(10);
            List<Protection> protections = this.resolveProtections(statement);
            for (Protection protection : protections) {
                String cacheKey = protection.getCacheKey();
                cache.put(cacheKey, protection);
            }
            this.log("Precached " + protections.size() + " protections.");
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void addCachedProtection(String worldName, int x, int y, int z, Protection p) {
        String cacheKey = worldName + ":" + x + ":" + y + ":" + z;
        LRUCache<String, Protection> cache = LWC.getInstance().getCaches().getProtections();
        cache.put(cacheKey, p);
    }

    public Protection getCachedProtection(String worldName, int x, int y, int z) {
        String cacheKey = worldName + ":" + x + ":" + y + ":" + z;
        LRUCache<String, Protection> cache = LWC.getInstance().getCaches().getProtections();
        return (Protection)cache.get(cacheKey);
    }

    public Protection loadProtection(String worldName, int x, int y, int z) {
        String cacheKey = worldName + ":" + x + ":" + y + ":" + z;
        LRUCache<String, Protection> cache = LWC.getInstance().getCaches().getProtections();
        if (cache.containsKey(cacheKey)) {
            return (Protection)cache.get(cacheKey);
        }
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest WHERE " + this.prefix + "protections.x = ? AND " + this.prefix + "protections.y = ? AND " + this.prefix + "protections.z = ? AND " + this.prefix + "protections.world = ?");
            statement.setInt(1, x);
            statement.setInt(2, y);
            statement.setInt(3, z);
            statement.setString(4, worldName);
            Protection protection = this.resolveProtection(statement);
            cache.put(cacheKey, protection);
            return protection;
        }
        catch (SQLException e) {
            this.printException(e);
            return null;
        }
    }

    public List<Protection> loadProtections() {
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest");
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public List<Protection> loadProtections(String world, int x, int y, int z, int radius) {
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest WHERE " + this.prefix + "protections.world = ? AND " + this.prefix + "protections.x >= ? AND " + this.prefix + "protections.x <= ? AND " + this.prefix + "protections.y >= ? AND " + this.prefix + "protections.y <= ? AND " + this.prefix + "protections.z >= ? AND " + this.prefix + "protections.z <= ?");
            statement.setString(1, world);
            statement.setInt(2, x - radius);
            statement.setInt(3, x + radius);
            statement.setInt(4, y - radius);
            statement.setInt(5, y + radius);
            statement.setInt(6, z - radius);
            statement.setInt(7, z + radius);
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public List<Protection> loadProtectionsByPlayer(String player, int start, int count) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        try {
            PreparedStatement statement = this.prepare("SELECT " + this.prefix + "protections.id AS protectionId, " + this.prefix + "rights.id AS rightsId, " + this.prefix + "protections.type AS protectionType, " + this.prefix + "rights.type AS rightsType, x, y, z, flags, blockId, world, owner, password, date, entity, " + this.prefix + "rights.rights, last_accessed FROM " + this.prefix + "protections LEFT OUTER JOIN " + this.prefix + "rights ON " + this.prefix + "protections.id = " + this.prefix + "rights.chest WHERE " + this.prefix + "protections.owner = ? ORDER BY " + this.prefix + "protections.id DESC limit ?,?");
            statement.setString(1, player);
            statement.setInt(2, start);
            statement.setInt(3, count);
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return protections;
        }
    }

    public List<AccessRight> loadRights(int protectionId) {
        ArrayList<AccessRight> accessRights = new ArrayList<AccessRight>();
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "rights WHERE chest = ?");
            statement.setInt(1, protectionId);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                AccessRight accessRight = new AccessRight();
                accessRight.setId(set.getInt("id"));
                accessRight.setProtectionId(set.getInt("chest"));
                accessRight.setName(set.getString("entity"));
                accessRight.setRights(set.getInt("rights"));
                accessRight.setType(set.getInt("type"));
                accessRights.add(accessRight);
            }
            set.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return accessRights;
    }

    public Protection registerProtection(int blockId, int type, String world, String player, String data, int x, int y, int z) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "protections (blockId, type, world, owner, password, x, y, z, date, last_accessed) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, blockId);
            statement.setInt(2, type);
            statement.setString(3, world);
            statement.setString(4, player);
            statement.setString(5, data);
            statement.setInt(6, x);
            statement.setInt(7, y);
            statement.setInt(8, z);
            statement.setString(9, new Timestamp(new Date().getTime()).toString());
            statement.setLong(10, System.currentTimeMillis() / 1000L);
            statement.executeUpdate();
            LWC.getInstance().getCaches().getProtections().remove(world + ":" + x + ":" + y + ":" + z);
            Protection protection = this.loadProtection(world, x, y, z);
            if (LWC.getInstance().isHistoryEnabled() && protection != null) {
                History transaction = protection.createHistoryObject();
                transaction.setPlayer(player);
                transaction.setType(History.Type.TRANSACTION);
                transaction.setStatus(History.Status.ACTIVE);
                transaction.addMetaData("creator=" + player);
                transaction.sync();
            }
            return protection;
        }
        catch (SQLException e) {
            this.printException(e);
            return null;
        }
    }

    public void saveHistory(History history) {
        try {
            PreparedStatement statement;
            int index = 1;
            if (history.doesExist()) {
                statement = this.prepare("REPLACE INTO " + this.prefix + "history (id, protectionId, player, type, status, metadata) VALUES (?, ?, ?, ?, ?, ?)");
                statement.setInt(index++, history.getId());
            } else {
                statement = this.prepare("INSERT INTO " + this.prefix + "history (protectionId, player, type, status, metadata, timestamp) VALUES (?, ?, ?, ?, ?, ?)", true);
            }
            statement.setInt(index++, history.getProtectionId());
            statement.setString(index++, history.getPlayer());
            statement.setInt(index++, history.getType().ordinal());
            statement.setInt(index++, history.getStatus().ordinal());
            statement.setString(index++, history.getSafeMetaData());
            if (!history.doesExist()) {
                statement.setLong(index++, System.currentTimeMillis() / 1000L);
            }
            int affectedRows = statement.executeUpdate();
            if (!history.doesExist() && affectedRows > 0) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    history.setId(generatedKeys.getInt(1));
                }
                generatedKeys.close();
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public List<History> loadHistory(Protection protection) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE protectionId = ?");
            statement.setInt(1, protection.getId());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                int historyId = set.getInt("id");
                int protectionId = set.getInt("protectionId");
                String player = set.getString("player");
                int type_ord = set.getInt("type");
                int status_ord = set.getInt("status");
                String[] metadata = set.getString("metadata").split(",");
                long timestamp = set.getLong("timestamp");
                History.Type type = History.Type.values()[type_ord];
                History.Status status = History.Status.values()[status_ord];
                History history = protection.createHistoryObject();
                history.setId(historyId);
                history.setType(type);
                history.setPlayer(player);
                history.setStatus(status);
                history.setMetaData(metadata);
                history.setTimestamp(timestamp);
                temp.add(history);
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory(Player player) {
        ArrayList<History> temp = new ArrayList<History>();
        LWCPlayer lwcPlayer = LWC.getInstance().wrapPlayer(player);
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE player = ?");
            statement.setString(1, player.getName());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                int historyId = set.getInt("id");
                int protectionId = set.getInt("protectionId");
                int type_ord = set.getInt("type");
                int status_ord = set.getInt("status");
                String[] metadata = set.getString("metadata").split(",");
                long timestamp = set.getLong("timestamp");
                History.Type type = History.Type.values()[type_ord];
                History.Status status = History.Status.values()[status_ord];
                History history = lwcPlayer.createHistoryObject();
                history.setId(historyId);
                history.setProtectionId(protectionId);
                history.setType(type);
                history.setPlayer(player.getName());
                history.setStatus(status);
                history.setMetaData(metadata);
                history.setTimestamp(timestamp);
                temp.add(history);
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory() {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history");
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                int historyId = set.getInt("id");
                int protectionId = set.getInt("protectionId");
                String player = set.getString("player");
                int type_ord = set.getInt("type");
                int status_ord = set.getInt("status");
                String[] metadata = set.getString("metadata").split(",");
                long timestamp = set.getLong("timestamp");
                History.Type type = History.Type.values()[type_ord];
                History.Status status = History.Status.values()[status_ord];
                History history = new History();
                history.setId(historyId);
                history.setProtectionId(protectionId);
                history.setType(type);
                history.setPlayer(player);
                history.setStatus(status);
                history.setMetaData(metadata);
                history.setTimestamp(timestamp);
                temp.add(history);
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public void registerProtectionRights(int protectionId, String entity, int rights, int type) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "rights (chest, entity, rights, type) VALUES (?, ?, ?, ?)");
            statement.setInt(1, protectionId);
            statement.setString(2, entity.toLowerCase());
            statement.setInt(3, rights);
            statement.setInt(4, type);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void saveProtection(Protection protection) {
        try {
            PreparedStatement statement = this.prepare("REPLACE INTO " + this.prefix + "protections (id, type, blockId, world, flags, owner, password, x, y, z, date, last_accessed) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, protection.getId());
            statement.setInt(2, protection.getType());
            statement.setInt(3, protection.getBlockId());
            statement.setString(4, protection.getWorld());
            statement.setInt(5, protection.getFlags());
            statement.setString(6, protection.getOwner());
            statement.setString(7, protection.getData());
            statement.setInt(8, protection.getX());
            statement.setInt(9, protection.getY());
            statement.setInt(10, protection.getZ());
            statement.setString(11, protection.getDate());
            statement.setLong(12, protection.getLastAccessed());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void setMenuStyle(String player, String menu) {
        try {
            PreparedStatement statement = this.prepare("REPLACE INTO " + this.prefix + "menu_styles (player, menu) VALUES (?,?)");
            statement.setString(1, player);
            statement.setString(2, menu);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterProtection(int protectionId) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "protections WHERE id = ?");
            statement.setInt(1, protectionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        this.unregisterProtectionRights(protectionId);
    }

    public void unregisterProtectionHistory(int protectionId) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "history WHERE protectionId = ?");
            statement.setInt(1, protectionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void unregisterHistory(int historyId) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "history WHERE id = ?");
            statement.setInt(1, historyId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void unregisterProtectionRights() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM " + this.prefix + "rights");
            statement.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterProtectionRights(int chestID) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "rights WHERE chest = ?");
            statement.setInt(1, chestID);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void unregisterProtectionRights(int chestID, String entity) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "rights WHERE chest = ? AND entity = ?");
            statement.setInt(1, chestID);
            statement.setString(2, entity.toLowerCase());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void unregisterProtections() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM " + this.prefix + "protections");
            statement.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    private void doIndexes() {
        try {
            this.connection.setAutoCommit(false);
            Statement statement = this.connection.createStatement();
            if (this.currentType == Database.Type.SQLite) {
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS in1 ON " + this.prefix + "protections (owner, x, y, z)");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS in3 ON " + this.prefix + "rights (chest, entity)");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS in6 ON " + this.prefix + "protections (id)");
            } else {
                statement.executeUpdate("CREATE INDEX in1 ON " + this.prefix + "protections (x, y, z)");
                statement.executeUpdate("CREATE INDEX in3 ON " + this.prefix + "rights (chest)");
                statement.executeUpdate("CREATE INDEX in6 ON " + this.prefix + "protections (id)");
            }
            this.connection.commit();
            statement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connection.setAutoCommit(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doUpdate100() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT type FROM protections");
            statement.close();
        }
        catch (SQLException e) {
            this.addColumn("protections", "type", "INTEGER");
            this.executeUpdateNoException("UPDATE protections SET type='1'");
        }
    }

    private void doUpdate140() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT id FROM protections");
            statement.close();
        }
        catch (Exception e) {
            this.renameTable("chests", "protections");
        }
    }

    private void doUpdate150() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT blockId FROM protections");
            statement.close();
        }
        catch (Exception e) {
            this.addColumn("protections", "blockId", "INTEGER");
        }
    }

    private void doUpdate170() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT world FROM protections");
            statement.close();
        }
        catch (Exception e) {
            this.addColumn("protections", "world", "TEXT");
        }
    }

    private void doUpdate301() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT * FROM limits LIMIT 1");
            statement.close();
        }
        catch (Exception e) {
            return;
        }
        LWC lwc = LWC.getInstance();
        Module rawModule = lwc.getModuleLoader().getModule(LimitsModule.class);
        if (rawModule == null) {
            this.log("Failed to load the Limits module. Something is wrong!");
            return;
        }
        LimitsModule limits = (LimitsModule)rawModule;
        PreparedStatement statement = this.prepare("SELECT * FROM limits");
        try {
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                int type = result.getInt("type");
                int amount = result.getInt("amount");
                String entity = result.getString("entity");
                switch (type) {
                    case 2: {
                        limits.set("master.type", "default");
                        limits.set("master.limit", amount);
                        break;
                    }
                    case 0: {
                        limits.set("groups." + entity + ".type", "default");
                        limits.set("groups." + entity + ".limit", amount);
                        break;
                    }
                    case 1: {
                        limits.set("players." + entity + ".type", "default");
                        limits.set("players." + entity + ".limit", amount);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.printException(e);
            return;
        }
        limits.save();
        this.dropTable("limits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate302() {
        if (this.prefix == null || this.prefix.length() == 0) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT id FROM " + this.prefix + "protections limit 1");
        }
        catch (SQLException e) {
            this.renameTable("protections", this.prefix + "protections");
            this.renameTable("rights", this.prefix + "rights");
            this.renameTable("menu_styles", this.prefix + "menu_styles");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate330() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT last_accessed FROM " + this.prefix + "protections");
        }
        catch (SQLException e) {
            this.addColumn(this.prefix + "protections", "last_accessed", "INTEGER");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBetaUpdate340() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT player FROM " + this.prefix + "history");
        }
        catch (SQLException e) {
            this.dropTable(this.prefix + "history");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void doUpdate220() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT flags FROM protections");
            statement.close();
        }
        catch (Exception e) {
            this.addColumn("protections", "flags", "INTEGER");
        }
    }
}

