/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.GroupWorld;
import com.nijiko.data.SqlEntryStorage;
import com.nijiko.data.SqlStorage;
import com.nijiko.permissions.EntryType;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlGroupStorage
extends SqlEntryStorage
implements GroupStorage {
    private String defaultGroup = null;
    private static final String defGroupText = "SELECT defaultid FROM PrWorldBase WHERE worldid = ?;";
    private static final String trackListText = "SELECT trackname FROM PrTracks WHERE worldid = ?;";
    private static final String trackGetText = "SELECT PrWorlds.worldname, PrEntries.name FROM PrWorlds, PrEntries, PrTracks, PrTrackGroups WHERE PrTrackGroups.trackid = PrTracks.trackid AND PrTracks.worldid = ? AND PrTracks.trackname = ? AND PrEntries.entryid = PrTrackGroups.gid AND PrWorlds.worldid = PrEntries.worldid ORDER BY PrTrackGroups.groupOrder;";

    public SqlGroupStorage(String world, int id) {
        super(world, id);
    }

    public EntryType getType() {
        return EntryType.GROUP;
    }

    public boolean isDefault(String name) {
        Object def;
        if (this.defaultGroup != null) {
            return this.defaultGroup.equals(name);
        }
        List<Map<Integer, Object>> results = SqlStorage.runQuery(defGroupText, new Object[]{this.worldId}, true, 1);
        Iterator<Map<Integer, Object>> iter = results.iterator();
        if (iter.hasNext() && (def = iter.next().get(1)) instanceof String) {
            this.defaultGroup = (String)def;
            return this.defaultGroup.equals(name);
        }
        return false;
    }

    public Set<String> getTracks() {
        List<Map<Integer, Object>> results = SqlStorage.runQuery(trackListText, new Object[]{this.worldId}, false, 1);
        Iterator<Map<Integer, Object>> iter = results.iterator();
        LinkedHashSet<String> tracks = new LinkedHashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next().get(1);
            if (!(o instanceof String)) continue;
            String s = (String)o;
            if (s.equals("deftrack")) {
                s = null;
            }
            tracks.add(s);
        }
        return tracks;
    }

    public LinkedList<GroupWorld> getTrack(String track) {
        if (track == null) {
            track = "deftrack";
        }
        List<Map<Integer, Object>> results = SqlStorage.runQuery(trackGetText, new Object[]{this.worldId, track}, false, 1);
        Iterator<Map<Integer, Object>> iter = results.iterator();
        LinkedList<GroupWorld> trackGroups = new LinkedList<GroupWorld>();
        while (iter.hasNext()) {
            Object oWorld = iter.next().get(1);
            Object oName = iter.next().get(2);
            if (!(oWorld instanceof String) || !(oName instanceof String)) continue;
            trackGroups.add(new GroupWorld((String)oWorld, (String)oName));
        }
        return null;
    }

    @Override
    protected int getId(String name) throws SQLException {
        int gid = -1;
        if (this.idCache.containsKey(name)) {
            gid = (Integer)this.idCache.get(name);
        } else {
            gid = SqlStorage.getEntry(this.world, name, true);
            this.idCache.put(name, gid);
        }
        return gid;
    }
}

