/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.Dbms;
import com.nijiko.data.SqlEntryStorage;
import com.nijiko.data.SqlGroupStorage;
import com.nijiko.data.SqlUserStorage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class SqlStorage {
    private static Dbms dbms;
    private static DataSource dbSource;
    private static boolean init;
    private static HashMap<String, SqlUserStorage> userStores;
    private static Map<String, SqlGroupStorage> groupStores;
    private static Map<String, Integer> worldMap;
    private static final List<String> create;
    static final String getWorld = "SELECT worldid FROM PrWorlds WHERE worldname = ?;";
    static final String getEntry = "SELECT entryid FROM PrEntries WHERE worldid = ? AND type = ? AND name = ?;";
    static final String createWorld = "INSERT IGNORE INTO PrWorlds (worldname) VALUES (?);";
    static final String createEntry = "INSERT IGNORE INTO PrEntries (worldid,type,name) VALUES (?,?,?);";
    static final String getWorldName = "SELECT worldname FROM PrWorlds WHERE worldid = ?;";
    static final String getEntryName = "SELECT name, worldid FROM PrEntries WHERE entryid = ?;";
    private static Connection dbConn;

    static Dbms getDbms() {
        return dbms;
    }

    public static synchronized void init(String dbmsName, String uri, String username, String password, int reloadDelay) throws Exception {
        if (init) {
            return;
        }
        System.out.println("[Permissions] Initializing Permissions 3 SQL interface.");
        try {
            dbms = Dbms.valueOf(dbmsName);
        }
        catch (IllegalArgumentException e) {
            System.err.println("[Permissions] Error occurred while selecting permissions config DBMS. Reverting to SQLite.");
            dbms = Dbms.SQLITE;
        }
        try {
            Class.forName(dbms.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new Exception("[Permissions] Unable to load SQL driver!", e);
        }
        dbSource = dbms.getSource(username, password, uri);
        SqlStorage.verifyAndCreateTables();
        dbConn = dbSource.getConnection();
        init = true;
        SqlStorage.clearWorldCache();
    }

    public static synchronized void clearWorldCache() {
        if (init) {
            worldMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyAndCreateTables() throws SQLException {
        Connection dbConn = null;
        Statement s = null;
        try {
            dbConn = dbSource.getConnection();
            s = dbConn.createStatement();
            if (dbms == Dbms.SQLITE) {
                s.execute("PRAGMA foreign_keys = ON;");
            }
            String engine = dbms.equals((Object)Dbms.MYSQL) ? " ENGINE = InnoDB;" : ";";
            for (String state : create) {
                if (dbms == Dbms.MYSQL) {
                    state = state.replace("AUTOINCREMENT", "AUTO_INCREMENT");
                    state = state.replace(" ENTRYINDEX", " INDEX pr_entryname_index(name),");
                } else {
                    state = state.replace(" ENTRYINDEX", "");
                }
                s.executeUpdate(state + engine);
            }
            if (dbms != Dbms.MYSQL) {
                s.executeUpdate("CREATE INDEX IF NOT EXISTS pr_entry_index ON PrEntries(name);");
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (dbConn != null) {
                dbConn.close();
            }
        }
    }

    static DataSource getSource() {
        return dbSource;
    }

    static int getWorld(String name) {
        Object o;
        if (worldMap.containsKey(name)) {
            return worldMap.get(name);
        }
        Object[] params = new Object[]{name};
        List<Map<Integer, Object>> results = SqlStorage.runQuery(getWorld, params, true, 1);
        if (results.isEmpty()) {
            System.out.println("[Permissions] Creating world '" + name + "'.");
            SqlStorage.runUpdate(createWorld, params);
            results = SqlStorage.runQuery(getWorld, params, true, 1);
        }
        int id = -1;
        Iterator<Map<Integer, Object>> iter = results.iterator();
        if (iter.hasNext() && (o = iter.next().get(1)) instanceof Integer) {
            id = (Integer)o;
        }
        worldMap.put(name, id);
        return id;
    }

    static int getEntry(String world, String name, boolean isGroup) {
        Object o;
        SqlEntryStorage ses = isGroup ? SqlStorage.getGroupStorage(world) : SqlStorage.getUserStorage(world);
        Integer cachedId = ses.getCachedId(name);
        if (cachedId != null) {
            return cachedId;
        }
        int worldid = SqlStorage.getWorld(world);
        Object[] params = new Object[]{worldid, (byte)(isGroup ? 1 : 0), name};
        List<Map<Integer, Object>> results = SqlStorage.runQuery(getEntry, params, true, 1);
        if (results.isEmpty()) {
            System.out.println("[Permissions] Creating " + (isGroup ? "group" : "user") + " '" + name + "' in world '" + world + "'.");
            SqlStorage.runUpdate(createEntry, params);
            results = SqlStorage.runQuery(getEntry, params, true, 1);
        }
        int id = -1;
        Iterator<Map<Integer, Object>> iter = results.iterator();
        if (iter.hasNext() && (o = iter.next().get(1)) instanceof Integer) {
            id = (Integer)o;
        }
        return id;
    }

    static String getWorldName(int id) {
        Object o;
        List<Map<Integer, Object>> results = SqlStorage.runQuery(getWorldName, new Object[]{id}, true, 1);
        Iterator<Map<Integer, Object>> iter = results.iterator();
        String name = "Error";
        if (iter.hasNext() && (o = iter.next().get(1)) instanceof String) {
            name = (String)o;
        }
        worldMap.put(name, id);
        return name;
    }

    static NameWorldId getEntryName(int id) {
        List<Map<Integer, Object>> results = SqlStorage.runQuery(getEntryName, new Object[]{id}, true, 1, 2);
        Iterator<Map<Integer, Object>> iter = results.iterator();
        NameWorldId nw = new NameWorldId();
        if (!iter.hasNext()) {
            nw.name = "Error";
            nw.worldid = -1;
            return nw;
        }
        Map<Integer, Object> row = iter.next();
        Object oName = row.get(1);
        Object oWId = row.get(2);
        String name = null;
        int worldid = -1;
        if (oName instanceof String && oWId instanceof Integer) {
            name = (String)oName;
            worldid = (Integer)oWId;
        }
        nw.name = name;
        nw.worldid = worldid;
        return nw;
    }

    static SqlUserStorage getUserStorage(String world) {
        if (userStores.containsKey(world)) {
            return userStores.get(world);
        }
        SqlUserStorage sus = new SqlUserStorage(world, SqlStorage.getWorld(world));
        userStores.put(sus.getWorld(), sus);
        return sus;
    }

    static SqlGroupStorage getGroupStorage(String world) {
        if (groupStores.containsKey(world)) {
            return groupStores.get(world);
        }
        SqlGroupStorage sgs = new SqlGroupStorage(world, SqlStorage.getWorld(world));
        groupStores.put(sgs.getWorld(), sgs);
        return sgs;
    }

    public static synchronized void closeAll() {
        try {
            if (init) {
                userStores.clear();
                groupStores.clear();
                worldMap.clear();
                dbConn.close();
                dbSource = null;
                init = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static Connection getConnection() throws SQLException {
        return dbSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Map<Integer, Object>> runQuery(String statement, Object[] params, boolean single, int ... dataCols) {
        LinkedList<Map<Integer, Object>> results;
        block15: {
            SqlStorage.checkConn();
            if (dataCols == null || dataCols.length == 0) {
                return null;
            }
            results = new LinkedList<Map<Integer, Object>>();
            PreparedStatement stmt = null;
            try {
                stmt = dbConn.prepareStatement(statement);
                SqlStorage.fillStatement(stmt, params);
                if (!stmt.execute()) break block15;
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    HashMap<Integer, Object> row = new HashMap<Integer, Object>();
                    for (int index : dataCols) {
                        row.put(index, rs.getObject(index));
                        if (dbms == Dbms.MYSQL && rs.isClosed()) break;
                    }
                    results.add(row);
                    if (!single) continue;
                    break;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int runUpdate(String statement, Object[] params) {
        SqlStorage.checkConn();
        String sql = dbms == Dbms.SQLITE ? statement.replace("INSERT IGNORE", "INSERT OR IGNORE") : statement;
        int result = -1;
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement(sql);
            SqlStorage.fillStatement(stmt, params);
            stmt.execute();
            result = stmt.getUpdateCount();
        }
        catch (SQLException e) {
            e.printStackTrace();
            result = -1;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    static void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        stmt.clearParameters();
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) continue;
            stmt.setObject(i + 1, param);
        }
    }

    private static void checkConn() {
        try {
            if (!(dbms != Dbms.MYSQL || dbConn != null && dbConn.isValid(1))) {
                dbConn = dbSource.getConnection();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static {
        init = false;
        userStores = new HashMap();
        groupStores = new HashMap<String, SqlGroupStorage>();
        worldMap = new HashMap<String, Integer>();
        create = new ArrayList<String>(8);
        create.add("CREATE TABLE IF NOT EXISTS PrWorlds ( worldid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, worldname VARCHAR(32) NOT NULL UNIQUE)");
        create.add("CREATE TABLE IF NOT EXISTS PrEntries ( entryid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, name VARCHAR(32) NOT NULL, worldid INTEGER NOT NULL, type TINYINT NOT NULL, CONSTRAINT NameWorld UNIQUE (name, worldid, type), ENTRYINDEX FOREIGN KEY(worldid) REFERENCES PrWorlds(worldid) ON DELETE CASCADE ON UPDATE CASCADE)");
        create.add("CREATE TABLE IF NOT EXISTS PrPermissions ( permid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, permstring VARCHAR(64) NOT NULL, entryid INTEGER NOT NULL, CONSTRAINT PrEntryPerm UNIQUE (entryid, permstring), FOREIGN KEY(entryid) REFERENCES PrEntries(entryid) ON DELETE CASCADE ON UPDATE CASCADE)");
        create.add("CREATE TABLE IF NOT EXISTS PrInheritance ( uinheritid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, childid INTEGER NOT NULL, parentid INTEGER NOT NULL, parentorder INTEGER NOT NULL, CONSTRAINT PrParent UNIQUE (childid, parentid), CONSTRAINT PrOrderedInheritance UNIQUE (childid, parentorder), CONSTRAINT PrNoSelfInherit CHECK (childid <> parentid), FOREIGN KEY(childid) REFERENCES PrEntries(entryid) ON DELETE CASCADE ON UPDATE CASCADE, FOREIGN KEY(parentid) REFERENCES PrEntries(entryid) ON DELETE CASCADE ON UPDATE CASCADE)");
        create.add("CREATE TABLE IF NOT EXISTS PrWorldBase ( worldid INTEGER NOT NULL, defaultid INTEGER, FOREIGN KEY(worldid) REFERENCES PrWorlds(worldid) ON DELETE CASCADE ON UPDATE CASCADE, FOREIGN KEY(defaultid) REFERENCES PrEntries(entryid) ON DELETE CASCADE ON UPDATE CASCADE)");
        create.add("CREATE TABLE IF NOT EXISTS PrData ( dataid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, entryid INTEGER NOT NULL , path VARCHAR(64) NOT NULL, data VARCHAR(64) NOT NULL, CONSTRAINT PrDataUnique UNIQUE (entryid, path), FOREIGN KEY(entryid) REFERENCES PrEntries(entryid) ON DELETE CASCADE ON UPDATE CASCADE)");
        create.add("CREATE TABLE IF NOT EXISTS PrTracks ( trackid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, trackname VARCHAR(64) NOT NULL UNIQUE, worldid INTEGER NOT NULL, CONSTRAINT TracksUnique UNIQUE (trackid, worldid), FOREIGN KEY(worldid) REFERENCES PrWorlds(worldid) ON DELETE CASCADE ON UPDATE CASCADE)");
        create.add("CREATE TABLE IF NOT EXISTS PrTrackGroups ( trackgroupid INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, trackid INTEGER NOT NULL, gid INTEGER NOT NULL, groupOrder INTEGER NOT NULL, CONSTRAINT TrackGroupsUnique UNIQUE (trackid, gid), FOREIGN KEY(trackid) REFERENCES PrTracks(trackid) ON DELETE CASCADE ON UPDATE CASCADE, FOREIGN KEY(gid) REFERENCES PrEntries(entryid) ON DELETE CASCADE ON UPDATE CASCADE)");
    }

    public static class NameWorldId {
        public int worldid;
        public String name;
    }
}

