/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.blacklist.events.BlockBreakBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.BlockPlaceBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.DestroyWithBlacklistEvent;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.SpongeUtil;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.block.SnowFormEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardBlockListener
extends BlockListener {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;

    public WorldGuardBlockListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        this.registerEvent("BLOCK_DAMAGE", Event.Priority.High);
        this.registerEvent("BLOCK_BREAK", Event.Priority.High);
        this.registerEvent("BLOCK_FROMTO", Event.Priority.Normal);
        this.registerEvent("BLOCK_IGNITE", Event.Priority.High);
        this.registerEvent("BLOCK_PHYSICS", Event.Priority.Normal);
        this.registerEvent("BLOCK_PLACE", Event.Priority.High);
        this.registerEvent("BLOCK_BURN", Event.Priority.High);
        this.registerEvent("SIGN_CHANGE", Event.Priority.High);
        this.registerEvent("REDSTONE_CHANGE", Event.Priority.High);
        this.registerEvent("SNOW_FORM", Event.Priority.High);
        this.registerEvent("LEAVES_DECAY", Event.Priority.High);
        this.registerEvent("BLOCK_FORM", Event.Priority.High);
        this.registerEvent("BLOCK_SPREAD", Event.Priority.High);
        this.registerEvent("BLOCK_FADE", Event.Priority.High);
    }

    private void registerEvent(String typeName, Event.Priority priority) {
        try {
            Event.Type type = Event.Type.valueOf((String)typeName);
            PluginManager pm = this.plugin.getServer().getPluginManager();
            pm.registerEvent(type, (Listener)this, priority, (Plugin)this.plugin);
        }
        catch (IllegalArgumentException e) {
            logger.info("WorldGuard: Unable to register missing event type " + typeName);
        }
    }

    protected WorldConfiguration getWorldConfig(World world) {
        return this.plugin.getGlobalStateManager().get(world);
    }

    protected WorldConfiguration getWorldConfig(Player player) {
        return this.plugin.getGlobalStateManager().get(player.getWorld());
    }

    public void onBlockDamage(BlockDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block blockDamaged = event.getBlock();
        if (blockDamaged.getType() == Material.CAKE_BLOCK && !this.plugin.getGlobalRegionManager().canBuild(player, blockDamaged)) {
            player.sendMessage(ChatColor.DARK_RED + "You're not invited to this tea party!");
            event.setCancelled(true);
            return;
        }
    }

    public void onBlockBreak(BlockBreakEvent event) {
        ItemStack held;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        WorldConfiguration wcfg = this.getWorldConfig(player);
        if (!(wcfg.itemDurability || (held = player.getItemInHand()).getTypeId() <= 0 || ItemType.usesDamageValue(held.getTypeId()) || BlockType.usesData(held.getTypeId()))) {
            held.setDurability((short)-1);
            player.setItemInHand(held);
        }
        if (!this.plugin.getGlobalRegionManager().canBuild(player, event.getBlock())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
        if (wcfg.getBlacklist() != null) {
            if (!wcfg.getBlacklist().check(new BlockBreakBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(event.getBlock()), event.getBlock().getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
            if (!wcfg.getBlacklist().check(new DestroyWithBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(event.getBlock()), player.getItemInHand().getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
        }
        if (wcfg.isChestProtected(event.getBlock(), player)) {
            player.sendMessage(ChatColor.DARK_RED + "The chest is protected.");
            event.setCancelled(true);
            return;
        }
    }

    public void onBlockFromTo(BlockFromToEvent event) {
        int targetId;
        if (event.isCancelled()) {
            return;
        }
        World world = event.getBlock().getWorld();
        Block blockFrom = event.getBlock();
        Block blockTo = event.getToBlock();
        boolean isWater = blockFrom.getTypeId() == 8 || blockFrom.getTypeId() == 9;
        boolean isLava = blockFrom.getTypeId() == 10 || blockFrom.getTypeId() == 11;
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.simulateSponge && isWater) {
            int ox = blockTo.getX();
            int oy = blockTo.getY();
            int oz = blockTo.getZ();
            for (int cx = -wcfg.spongeRadius; cx <= wcfg.spongeRadius; ++cx) {
                for (int cy = -wcfg.spongeRadius; cy <= wcfg.spongeRadius; ++cy) {
                    for (int cz = -wcfg.spongeRadius; cz <= wcfg.spongeRadius; ++cz) {
                        Block sponge = world.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getTypeId() != 19 || wcfg.redstoneSponges && sponge.isBlockIndirectlyPowered()) continue;
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
        if (wcfg.preventWaterDamage.size() > 0) {
            targetId = blockTo.getTypeId();
            if ((blockFrom.getTypeId() == 0 || isWater) && wcfg.preventWaterDamage.contains(targetId)) {
                event.setCancelled(true);
                return;
            }
        }
        if (wcfg.allowedLavaSpreadOver.size() > 0 && isLava && !wcfg.allowedLavaSpreadOver.contains(targetId = blockTo.getRelative(0, -1, 0).getTypeId())) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.highFreqFlags && isWater && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.WATER_FLOW, blockFrom.getLocation())) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.highFreqFlags && isLava && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.LAVA_FLOW, blockFrom.getLocation())) {
            event.setCancelled(true);
            return;
        }
    }

    public void onBlockIgnite(BlockIgniteEvent event) {
        int z;
        int y;
        int x;
        boolean isFireSpread;
        if (event.isCancelled()) {
            return;
        }
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        Block block = event.getBlock();
        World world = block.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isFireSpread = cause == BlockIgniteEvent.IgniteCause.SPREAD;
        if (wcfg.preventLightningFire && cause == BlockIgniteEvent.IgniteCause.LIGHTNING) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.preventLavaFire && cause == BlockIgniteEvent.IgniteCause.LAVA) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpread && isFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.blockLighter && cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL && event.getPlayer() != null && !this.plugin.hasPermission((CommandSender)event.getPlayer(), "worldguard.override.lighter")) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.fireSpreadDisableToggle && isFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpreadBlocks.size() > 0 && isFireSpread && (wcfg.disableFireSpreadBlocks.contains(world.getBlockTypeIdAt(x = block.getX(), (y = block.getY()) - 1, z = block.getZ())) || wcfg.disableFireSpreadBlocks.contains(world.getBlockTypeIdAt(x + 1, y, z)) || wcfg.disableFireSpreadBlocks.contains(world.getBlockTypeIdAt(x - 1, y, z)) || wcfg.disableFireSpreadBlocks.contains(world.getBlockTypeIdAt(x, y, z - 1)) || wcfg.disableFireSpreadBlocks.contains(world.getBlockTypeIdAt(x, y, z + 1)))) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            BlockVector pt = BukkitUtil.toVector(block);
            Player player = event.getPlayer();
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            if (player != null && !this.plugin.getGlobalRegionManager().hasBypass(player, world)) {
                LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
                if (cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
                    if (!set.canBuild(localPlayer)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (!set.allows(DefaultFlag.LIGHTER) && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.lighter")) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            if (wcfg.highFreqFlags && isFireSpread && !set.allows(DefaultFlag.FIRE_SPREAD)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.highFreqFlags && cause == BlockIgniteEvent.IgniteCause.LAVA && !set.allows(DefaultFlag.LAVA_FIRE)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onBlockBurn(BlockBurnEvent event) {
        Block block;
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.fireSpreadDisableToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpreadBlocks.size() > 0 && wcfg.disableFireSpreadBlocks.contains((block = event.getBlock()).getTypeId())) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.isChestProtected(event.getBlock())) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            block = event.getBlock();
            BlockVector pt = BukkitUtil.toVector(block);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(block.getWorld());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            if (!set.allows(DefaultFlag.FIRE_SPREAD)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        int id = event.getChangedTypeId();
        if (id == 13 && wcfg.noPhysicsGravel) {
            event.setCancelled(true);
            return;
        }
        if (id == 12 && wcfg.noPhysicsSand) {
            event.setCancelled(true);
            return;
        }
        if (id == 90 && wcfg.allowPortalAnywhere) {
            event.setCancelled(true);
            return;
        }
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block blockPlaced = event.getBlock();
        Player player = event.getPlayer();
        World world = blockPlaced.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().canBuild(player, blockPlaced.getLocation())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new BlockPlaceBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(blockPlaced), blockPlaced.getTypeId()), false, false)) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.signChestProtection && wcfg.getChestProtection().isChest(blockPlaced.getType()) && wcfg.isAdjacentChestProtected(event.getBlock(), player)) {
            player.sendMessage(ChatColor.DARK_RED + "This spot is for a chest that you don't have permission for.");
            event.setCancelled(true);
            return;
        }
        if (wcfg.simulateSponge && blockPlaced.getTypeId() == 19) {
            if (wcfg.redstoneSponges && blockPlaced.isBlockIndirectlyPowered()) {
                return;
            }
            int ox = blockPlaced.getX();
            int oy = blockPlaced.getY();
            int oz = blockPlaced.getZ();
            SpongeUtil.clearSpongeWater(this.plugin, world, ox, oy, oz);
        }
    }

    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block blockTo = event.getBlock();
        World world = blockTo.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.simulateSponge && wcfg.redstoneSponges) {
            int ox = blockTo.getX();
            int oy = blockTo.getY();
            int oz = blockTo.getZ();
            for (int cx = -1; cx <= 1; ++cx) {
                for (int cy = -1; cy <= 1; ++cy) {
                    for (int cz = -1; cz <= 1; ++cz) {
                        Block sponge = world.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getTypeId() == 19 && sponge.isBlockIndirectlyPowered()) {
                            SpongeUtil.clearSpongeWater(this.plugin, world, ox + cx, oy + cy, oz + cz);
                            continue;
                        }
                        if (sponge.getTypeId() != 19 || sponge.isBlockIndirectlyPowered()) continue;
                        SpongeUtil.addSpongeWater(this.plugin, world, ox + cx, oy + cy, oz + cz);
                    }
                }
            }
            return;
        }
    }

    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        WorldConfiguration wcfg = this.getWorldConfig(player);
        if (wcfg.signChestProtection) {
            if (event.getLine(0).equalsIgnoreCase("[Lock]")) {
                if (wcfg.isChestProtectedPlacement(event.getBlock(), player)) {
                    player.sendMessage(ChatColor.DARK_RED + "You do not own the adjacent chest.");
                    BukkitUtil.dropSign(event.getBlock());
                    event.setCancelled(true);
                    return;
                }
                if (event.getBlock().getType() != Material.SIGN_POST) {
                    player.sendMessage(ChatColor.RED + "The [Lock] sign must be a sign post, not a wall sign.");
                    BukkitUtil.dropSign(event.getBlock());
                    event.setCancelled(true);
                    return;
                }
                if (!event.getLine(1).equalsIgnoreCase(player.getName())) {
                    player.sendMessage(ChatColor.RED + "The first owner line must be your name.");
                    BukkitUtil.dropSign(event.getBlock());
                    event.setCancelled(true);
                    return;
                }
                Material below = event.getBlock().getRelative(0, -1, 0).getType();
                if (below == Material.TNT || below == Material.SAND || below == Material.GRAVEL || below == Material.SIGN_POST) {
                    player.sendMessage(ChatColor.RED + "That is not a safe block that you're putting this sign on.");
                    BukkitUtil.dropSign(event.getBlock());
                    event.setCancelled(true);
                    return;
                }
                event.setLine(0, "[Lock]");
                player.sendMessage(ChatColor.YELLOW + "A chest or double chest above is now protected.");
            }
        } else if (event.getLine(0).equalsIgnoreCase("[Lock]")) {
            player.sendMessage(ChatColor.RED + "WorldGuard's sign chest protection is disabled.");
            BukkitUtil.dropSign(event.getBlock());
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getGlobalRegionManager().canBuild(player, event.getBlock())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
    }

    public void onSnowForm(SnowFormEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableSnowFormation) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.SNOW_FALL, event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    public void onLeavesDecay(LeavesDecayEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableLeafDecay) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().allows(DefaultFlag.LEAF_DECAY, event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    public void onBlockForm(BlockFormEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material type = event.getNewState().getType();
        if (wcfg.disableIceFormation && type == Material.ICE) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableSnowFormation && type == Material.SNOW) {
            event.setCancelled(true);
            return;
        }
    }

    public void onBlockSpread(BlockSpreadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material fromType = event.getSource().getType();
        if (wcfg.disableMushroomSpread && (fromType == Material.RED_MUSHROOM || fromType == Material.BROWN_MUSHROOM)) {
            event.setCancelled(true);
            return;
        }
    }

    public void onBlockFade(BlockFadeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getBlock().getWorld());
        Material type = event.getBlock().getType();
        if (wcfg.disableIceMelting && type == Material.ICE) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableSnowMelting && type == Material.SNOW) {
            event.setCancelled(true);
            return;
        }
    }
}

