/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.weather.WeatherListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardWeatherListener
extends WeatherListener {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;

    public WorldGuardWeatherListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        this.registerEvent("LIGHTNING_STRIKE", Event.Priority.High);
        this.registerEvent("THUNDER_CHANGE", Event.Priority.High);
        this.registerEvent("WEATHER_CHANGE", Event.Priority.High);
    }

    private void registerEvent(String typeName, Event.Priority priority) {
        try {
            Event.Type type = Event.Type.valueOf((String)typeName);
            PluginManager pm = this.plugin.getServer().getPluginManager();
            pm.registerEvent(type, (Listener)this, priority, (Plugin)this.plugin);
        }
        catch (IllegalArgumentException e) {
            logger.info("WorldGuard: Unable to register missing event type " + typeName);
        }
    }

    public void onWeatherChange(WeatherChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getWorld());
        if (event.toWeatherState()) {
            if (wcfg.disableWeather) {
                event.setCancelled(true);
            }
        } else if (!wcfg.disableWeather && wcfg.alwaysRaining) {
            event.setCancelled(true);
        }
    }

    public void onThunderChange(ThunderChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getWorld());
        if (event.toThunderState()) {
            if (wcfg.disableThunder) {
                event.setCancelled(true);
            }
        } else if (!wcfg.disableWeather && wcfg.alwaysThundering) {
            event.setCancelled(true);
        }
    }

    public void onLightningStrike(LightningStrikeEvent event) {
        int targetId;
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getWorld());
        if (wcfg.disallowedLightningBlocks.size() > 0 && wcfg.disallowedLightningBlocks.contains(targetId = event.getLightning().getLocation().getBlock().getTypeId())) {
            event.setCancelled(true);
        }
        Location loc = event.getLightning().getLocation();
        if (wcfg.useRegions) {
            Vector pt = BukkitUtil.toVector(loc);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(loc.getWorld());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            if (!set.allows(DefaultFlag.LIGHTNING)) {
                event.setCancelled(true);
            }
        }
    }
}

