/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.flags;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.flags.RegionGroupFlag;
import org.bukkit.command.CommandSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateFlag
extends Flag<State> {
    private boolean def;
    private RegionGroupFlag groupFlag;

    public StateFlag(String name, char legacyCode, boolean def) {
        super(name, legacyCode);
        this.def = def;
    }

    public StateFlag(String name, boolean def) {
        super(name);
        this.def = def;
    }

    public boolean getDefault() {
        return this.def;
    }

    public RegionGroupFlag getGroupFlag() {
        return this.groupFlag;
    }

    public void setGroupFlag(RegionGroupFlag groupFlag) {
        this.groupFlag = groupFlag;
    }

    @Override
    public State parseInput(WorldGuardPlugin plugin, CommandSender sender, String input) throws InvalidFlagFormat {
        if ((input = input.trim()).equalsIgnoreCase("allow")) {
            return State.ALLOW;
        }
        if (input.equalsIgnoreCase("deny")) {
            return State.DENY;
        }
        if (input.equalsIgnoreCase("none")) {
            return null;
        }
        throw new InvalidFlagFormat("Not none/allow/deny: " + input);
    }

    @Override
    public State unmarshal(Object o) {
        String str = o.toString();
        if (str.equalsIgnoreCase("allow")) {
            return State.ALLOW;
        }
        if (str.equalsIgnoreCase("deny")) {
            return State.DENY;
        }
        return null;
    }

    @Override
    public Object marshal(State o) {
        if (o == State.ALLOW) {
            return "allow";
        }
        if (o == State.DENY) {
            return "deny";
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ALLOW,
        DENY;

    }
}

