/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.protection.UnsupportedIntersectionException;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedCuboidRegion
extends ProtectedRegion {
    private BlockVector min;
    private BlockVector max;

    public ProtectedCuboidRegion(String id, BlockVector min, BlockVector max) {
        super(id);
        this.min = min;
        this.max = max;
    }

    @Override
    public BlockVector getMinimumPoint() {
        return this.min;
    }

    public void setMinimumPoint(BlockVector pt) {
        this.min = pt;
    }

    @Override
    public BlockVector getMaximumPoint() {
        return this.max;
    }

    public void setMaximumPoint(BlockVector pt) {
        this.max = pt;
    }

    @Override
    public boolean contains(Vector pt) {
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        return x >= this.min.getBlockX() && x <= this.max.getBlockX() && y >= this.min.getBlockY() && y <= this.max.getBlockY() && z >= this.min.getBlockZ() && z <= this.max.getBlockZ();
    }

    @Override
    public List<ProtectedRegion> getIntersectingRegions(List<ProtectedRegion> regions) throws UnsupportedIntersectionException {
        int numRegions = regions.size();
        ArrayList<ProtectedRegion> intersectingRegions = new ArrayList<ProtectedRegion>();
        block0: for (int i = 0; i < numRegions; ++i) {
            int i2;
            ProtectedRegion region = regions.get(i);
            BlockVector rMinPoint = region.getMinimumPoint();
            BlockVector rMaxPoint = region.getMaximumPoint();
            if (rMinPoint.getBlockX() < this.min.getBlockX() && rMaxPoint.getBlockX() < this.min.getBlockX() || rMinPoint.getBlockX() > this.max.getBlockX() && rMaxPoint.getBlockX() > this.max.getBlockX() && (rMinPoint.getBlockY() < this.min.getBlockY() && rMaxPoint.getBlockY() < this.min.getBlockY() || rMinPoint.getBlockY() > this.max.getBlockY() && rMaxPoint.getBlockY() > this.max.getBlockY()) && (rMinPoint.getBlockZ() < this.min.getBlockZ() && rMaxPoint.getBlockZ() < this.min.getBlockZ() || rMinPoint.getBlockZ() > this.max.getBlockZ() && rMaxPoint.getBlockZ() > this.max.getBlockZ())) continue;
            if (region.contains(new Vector(this.min.getBlockX(), this.min.getBlockY(), this.min.getBlockZ())) || region.contains(new Vector(this.min.getBlockX(), this.min.getBlockY(), this.max.getBlockZ())) || region.contains(new Vector(this.min.getBlockX(), this.max.getBlockY(), this.max.getBlockZ())) || region.contains(new Vector(this.min.getBlockX(), this.max.getBlockY(), this.min.getBlockZ())) || region.contains(new Vector(this.max.getBlockX(), this.max.getBlockY(), this.max.getBlockZ())) || region.contains(new Vector(this.max.getBlockX(), this.max.getBlockY(), this.min.getBlockZ())) || region.contains(new Vector(this.max.getBlockX(), this.min.getBlockY(), this.min.getBlockZ())) || region.contains(new Vector(this.max.getBlockX(), this.min.getBlockY(), this.max.getBlockZ()))) {
                intersectingRegions.add(regions.get(i));
                continue;
            }
            if (region instanceof ProtectedPolygonalRegion) {
                for (i2 = 0; i2 < ((ProtectedPolygonalRegion)region).getPoints().size(); ++i2) {
                    BlockVector2D pt2Dr = ((ProtectedPolygonalRegion)region).getPoints().get(i2);
                    int minYr = ((ProtectedPolygonalRegion)region).minY;
                    int maxYr = ((ProtectedPolygonalRegion)region).maxY;
                    Vector ptr = new Vector(pt2Dr.getBlockX(), minYr, pt2Dr.getBlockZ());
                    Vector ptr2 = new Vector(pt2Dr.getBlockX(), maxYr, pt2Dr.getBlockZ());
                    if (!this.contains(ptr) && !this.contains(ptr2)) continue;
                    intersectingRegions.add(regions.get(i));
                }
            } else if (region instanceof ProtectedCuboidRegion) {
                BlockVector ptcMin = region.getMinimumPoint();
                BlockVector ptcMax = region.getMaximumPoint();
                if (this.contains(new Vector(ptcMin.getBlockX(), ptcMin.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMin.getBlockX(), ptcMin.getBlockY(), ptcMax.getBlockZ())) || this.contains(new Vector(ptcMin.getBlockX(), ptcMax.getBlockY(), ptcMax.getBlockZ())) || this.contains(new Vector(ptcMin.getBlockX(), ptcMax.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMax.getBlockY(), ptcMax.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMax.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMin.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMin.getBlockY(), ptcMax.getBlockZ()))) {
                    intersectingRegions.add(regions.get(i));
                    continue;
                }
            } else {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            boolean regionIsIntersecting = false;
            ArrayList<BlockVector2D> points = new ArrayList<BlockVector2D>();
            points.add(new BlockVector2D(this.min.getBlockX(), this.min.getBlockZ()));
            points.add(new BlockVector2D(this.min.getBlockX(), this.max.getBlockZ()));
            points.add(new BlockVector2D(this.max.getBlockX(), this.max.getBlockZ()));
            points.add(new BlockVector2D(this.max.getBlockX(), this.min.getBlockZ()));
            for (i2 = 0; i2 < points.size(); ++i2) {
                boolean checkNextPoint = false;
                BlockVector2D currPoint = (BlockVector2D)points.get(i2);
                BlockVector2D nextPoint = i2 == points.size() - 1 ? (BlockVector2D)points.get(0) : (BlockVector2D)points.get(i2 + 1);
                int currX = currPoint.getBlockX();
                int currZ = currPoint.getBlockZ();
                while (!checkNextPoint) {
                    for (int i3 = this.min.getBlockY(); i3 <= this.max.getBlockY(); ++i3) {
                        if (!region.contains(new Vector(currX, i3, currZ))) continue;
                        intersectingRegions.add(regions.get(i));
                        regionIsIntersecting = true;
                        break;
                    }
                    if (currX == nextPoint.getBlockX() || currZ == nextPoint.getBlockZ() || regionIsIntersecting) {
                        checkNextPoint = true;
                    }
                    currX = nextPoint.getBlockX() > currPoint.getBlockX() ? ++currX : --currX;
                    if (nextPoint.getBlockZ() > currPoint.getBlockZ()) {
                        ++currZ;
                        continue;
                    }
                    --currZ;
                }
                if (regionIsIntersecting) continue block0;
            }
        }
        return intersectingRegions;
    }

    @Override
    public String getTypeName() {
        return "cuboid";
    }

    @Override
    public int volume() {
        int xLength = this.max.getBlockX() - this.min.getBlockX() + 1;
        int yLength = this.max.getBlockY() - this.min.getBlockY() + 1;
        int zLength = this.max.getBlockZ() - this.min.getBlockZ() + 1;
        int volume = xLength * yLength * zLength;
        return volume;
    }
}

