/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.ItemDb;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EssentialsBlockListener
extends BlockListener {
    private final Essentials ess;
    public static final ArrayList<Material> protectedBlocks = new ArrayList(4);
    private static final int NOT_ALLOWED = 0;
    private static final int ALLOWED = 1;
    private static final int NOSIGN = 2;
    private static final int OWNER = 3;

    public EssentialsBlockListener(Essentials ess) {
        this.ess = ess;
    }

    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.ess.getSettings().areSignsDisabled()) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (protectedBlocks.contains(event.getBlock().getType()) && !user.isAuthorized("essentials.signs.protection.override") && this.isBlockProtected(event.getBlock(), user)) {
            event.setCancelled(true);
            user.sendMessage(Util.format("noDestroyPermission", event.getBlock().getType().toString().toLowerCase()));
            return;
        }
        if (this.checkProtectionSign(event.getBlock(), user) != 2 && this.checkProtectionSign(event.getBlock(), user) != 3) {
            event.setCancelled(true);
            user.sendMessage(Util.format("noDestroyPermission", event.getBlock().getType().toString().toLowerCase()));
        }
    }

    public void onSignChange(SignChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.ess.getSettings().areSignsDisabled()) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        String username = user.getName().substring(0, user.getName().length() > 14 ? 14 : user.getName().length());
        try {
            if (event.getLine(0).equalsIgnoreCase("[Protection]")) {
                Block block = event.getBlock();
                if (user.isAuthorized("essentials.signs.protection.create") && this.hasAdjacentChest(block) && !this.isBlockProtected(block, user)) {
                    event.setLine(0, "\u00a71[Protection]");
                } else {
                    event.setLine(0, "\u00a74[Protection]");
                }
                event.setLine(3, username);
                return;
            }
            if (event.getLine(0).equalsIgnoreCase("[Disposal]")) {
                if (user.isAuthorized("essentials.signs.disposal.create")) {
                    event.setLine(0, "\u00a71[Disposal]");
                } else {
                    event.setLine(0, "\u00a74[Disposal]");
                }
                return;
            }
            if (event.getLine(0).equalsIgnoreCase("[Heal]")) {
                event.setLine(0, "\u00a74[Heal]");
                if (user.isAuthorized("essentials.signs.heal.create")) {
                    if (!event.getLine(1).isEmpty()) {
                        String[] l1 = event.getLine(1).split("[ :-]+", 2);
                        boolean m1 = l1[0].matches("\\$[0-9]+");
                        int q1 = Integer.parseInt(m1 ? l1[0].substring(1) : l1[0]);
                        if (q1 < 1) {
                            throw new Exception(Util.i18n("moreThanZero"));
                        }
                        if (!m1) {
                            ItemDb.get(l1[1]);
                        }
                        event.setLine(1, m1 ? "$" + q1 : q1 + " " + l1[1]);
                    }
                    event.setLine(0, "\u00a71[Heal]");
                }
                return;
            }
            if (event.getLine(0).equalsIgnoreCase("[Free]")) {
                event.setLine(0, "\u00a74[Free]");
                ItemDb.get(event.getLine(1));
                if (user.isAuthorized("essentials.signs.free.create")) {
                    event.setLine(0, "\u00a71[Free]");
                }
                return;
            }
            if (event.getLine(0).equalsIgnoreCase("[Mail]")) {
                if (user.isAuthorized("essentials.signs.mail.create")) {
                    event.setLine(0, "\u00a71[Mail]");
                } else {
                    event.setLine(0, "\u00a74[Mail]");
                }
                return;
            }
            if (event.getLine(0).equalsIgnoreCase("[Balance]")) {
                if (user.isAuthorized("essentials.signs.balance.create")) {
                    event.setLine(0, "\u00a71[Balance]");
                } else {
                    event.setLine(0, "\u00a74[Balance]");
                }
                return;
            }
            if (event.getLine(0).equalsIgnoreCase("[Warp]")) {
                event.setLine(0, "\u00a74[Warp]");
                if (user.isAuthorized("essentials.signs.warp.create")) {
                    if (!event.getLine(3).isEmpty()) {
                        String[] l1 = event.getLine(3).split("[ :-]+", 2);
                        boolean m1 = l1[0].matches("\\$[0-9]+");
                        int q1 = Integer.parseInt(m1 ? l1[0].substring(1) : l1[0]);
                        if (q1 < 1) {
                            throw new Exception(Util.i18n("moreThanZero"));
                        }
                        if (!m1) {
                            ItemDb.get(l1[1]);
                        }
                        event.setLine(3, m1 ? "$" + q1 : q1 + " " + l1[1]);
                    }
                    if (event.getLine(1).isEmpty()) {
                        event.setLine(1, "\u00a7dWarp name here!");
                        return;
                    }
                    Essentials.getWarps().getWarp(event.getLine(1));
                    if (event.getLine(2).equalsIgnoreCase("Everyone")) {
                        event.setLine(2, "\u00a72Everyone");
                    }
                    event.setLine(0, "\u00a71[Warp]");
                }
                return;
            }
        }
        catch (Throwable ex) {
            user.sendMessage(Util.format("errorWithMessage", ex.getMessage()));
        }
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        CraftSign sign;
        if (event.isCancelled()) {
            return;
        }
        Block signBlock = event.getBlockAgainst();
        if ((signBlock.getType() == Material.WALL_SIGN || signBlock.getType() == Material.SIGN_POST) && (sign = new CraftSign(signBlock)).getLine(0).matches("\u00a71\\[[a-zA-Z]+\\]")) {
            event.setCancelled(true);
            return;
        }
        final User user = this.ess.getUser(event.getPlayer());
        final ItemStack is = new ItemStack(event.getBlockPlaced().getType(), 1, 0, Byte.valueOf(event.getBlockPlaced().getData()));
        switch (is.getType()) {
            case WOODEN_DOOR: {
                is.setType(Material.WOOD_DOOR);
                is.setDurability((short)0);
                break;
            }
            case IRON_DOOR_BLOCK: {
                is.setType(Material.IRON_DOOR);
                is.setDurability((short)0);
                break;
            }
            case SIGN_POST: 
            case WALL_SIGN: {
                is.setType(Material.SIGN);
                is.setDurability((short)0);
                break;
            }
            case CROPS: {
                is.setType(Material.SEEDS);
                is.setDurability((short)0);
                break;
            }
            case CAKE_BLOCK: {
                is.setType(Material.CAKE);
                is.setDurability((short)0);
                break;
            }
            case BED_BLOCK: {
                is.setType(Material.BED);
                is.setDurability((short)0);
                break;
            }
            case REDSTONE_WIRE: {
                is.setType(Material.REDSTONE);
                is.setDurability((short)0);
                break;
            }
            case REDSTONE_TORCH_OFF: 
            case REDSTONE_TORCH_ON: {
                is.setType(Material.REDSTONE_TORCH_ON);
                is.setDurability((short)0);
                break;
            }
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: {
                is.setType(Material.DIODE);
                is.setDurability((short)0);
                break;
            }
            case DOUBLE_STEP: {
                is.setType(Material.STEP);
                break;
            }
            case TORCH: 
            case RAILS: 
            case LADDER: 
            case WOOD_STAIRS: 
            case COBBLESTONE_STAIRS: 
            case LEVER: 
            case STONE_BUTTON: 
            case FURNACE: 
            case DISPENSER: 
            case PUMPKIN: 
            case JACK_O_LANTERN: 
            case WOOD_PLATE: 
            case STONE_PLATE: {
                is.setDurability((short)0);
            }
        }
        boolean unlimitedForUser = user.hasUnlimited(is);
        if (unlimitedForUser) {
            this.ess.getScheduler().scheduleSyncDelayedTask((Plugin)this.ess, new Runnable(){

                public void run() {
                    user.getInventory().addItem(new ItemStack[]{is});
                    user.updateInventory();
                }
            });
        }
    }

    public boolean hasAdjacentChest(Block block) {
        Block[] faces;
        for (Block b : faces = EssentialsBlockListener.getAdjacentBlocks(block)) {
            if (!protectedBlocks.contains(b.getType())) continue;
            return true;
        }
        return false;
    }

    private int checkProtectionSign(Block block, User user) {
        CraftSign sign;
        String username = user.getName().substring(0, user.getName().length() > 14 ? 14 : user.getName().length());
        if ((block.getType() == Material.SIGN_POST || block.getType() == Material.WALL_SIGN) && (sign = new CraftSign(block)).getLine(0).equalsIgnoreCase("\u00a71[Protection]") && !user.isAuthorized("essentials.signs.protection.override")) {
            for (int i = 1; i <= 2; ++i) {
                String line = sign.getLine(i);
                if (!(line.startsWith("(") && line.endsWith(")") ? user.inGroup(line = line.substring(1, line.length() - 1)) : line.equalsIgnoreCase(username))) continue;
                return 1;
            }
            if (sign.getLine(3).equalsIgnoreCase(username)) {
                return 3;
            }
            return 0;
        }
        return 2;
    }

    private static Block[] getAdjacentBlocks(Block block) {
        return new Block[]{block.getFace(BlockFace.NORTH), block.getFace(BlockFace.SOUTH), block.getFace(BlockFace.EAST), block.getFace(BlockFace.WEST), block.getFace(BlockFace.DOWN), block.getFace(BlockFace.UP)};
    }

    public boolean isBlockProtected(Block block, User user) {
        Block[] faces = EssentialsBlockListener.getAdjacentBlocks(block);
        boolean protect = false;
        for (Block b : faces) {
            Block[] faceChest;
            int check = this.checkProtectionSign(b, user);
            if (check == 0) {
                protect = true;
            }
            if (check == 1 || check == 3) {
                return false;
            }
            if (!protectedBlocks.contains(b.getType())) continue;
            for (Block a : faceChest = EssentialsBlockListener.getAdjacentBlocks(b)) {
                check = this.checkProtectionSign(a, user);
                if (check == 0) {
                    protect = true;
                }
                if (check != 1 && check != 3) continue;
                return false;
            }
        }
        return protect;
    }

    public static boolean isBlockProtected(Block block) {
        Block[] faces;
        for (Block b : faces = EssentialsBlockListener.getAdjacentBlocks(block)) {
            Block[] faceChest;
            CraftSign sign;
            if ((b.getType() == Material.SIGN_POST || b.getType() == Material.WALL_SIGN) && (sign = new CraftSign(b)).getLine(0).equalsIgnoreCase("\u00a71[Protection]")) {
                return true;
            }
            if (!protectedBlocks.contains(b.getType())) continue;
            for (Block a : faceChest = EssentialsBlockListener.getAdjacentBlocks(b)) {
                CraftSign sign2;
                if (a.getType() != Material.SIGN_POST && a.getType() != Material.WALL_SIGN || !(sign2 = new CraftSign(a)).getLine(0).equalsIgnoreCase("\u00a71[Protection]")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        protectedBlocks.add(Material.CHEST);
        protectedBlocks.add(Material.BURNING_FURNACE);
        protectedBlocks.add(Material.FURNACE);
        protectedBlocks.add(Material.DISPENSER);
    }
}

