/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.PlayerExtension;
import com.earth2me.essentials.Util;
import com.iConomy.iConomy;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserData
extends PlayerExtension
implements IConf {
    private EssentialsConf config;
    private static final Logger logger = Logger.getLogger("Minecraft");
    protected Essentials ess;
    private List<Integer> unlimited;
    private Map<Integer, String> powertools;
    private Location lastLocation;
    private long lastTeleportTimestamp;
    private long lastHealTimestamp;
    private String jail;
    private List<String> mails;
    private ItemStack[] savedInventory;
    private boolean teleportEnabled;
    private List<String> ignoredPlayers;
    private boolean godmode;
    private boolean muted;
    private long muteTimeout;
    private boolean jailed;
    private long jailTimeout;
    private long lastLogin;
    private long lastLogout;
    private boolean afk;
    private boolean newplayer;
    private String geolocation;
    private boolean isSocialSpyEnabled;

    protected UserData(Player base, Essentials ess) {
        super(base);
        this.ess = ess;
        File folder = new File(ess.getDataFolder(), "userdata");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.config = new EssentialsConf(new File(folder, Util.sanitizeFileName(base.getName()) + ".yml"));
        this.reloadConfig();
    }

    @Override
    public final void reloadConfig() {
        this.config.load();
        this.unlimited = this._getUnlimited();
        this.powertools = this.getPowertools();
        this.lastLocation = this._getLastLocation();
        this.lastTeleportTimestamp = this._getLastTeleportTimestamp();
        this.lastHealTimestamp = this._getLastHealTimestamp();
        this.jail = this._getJail();
        this.mails = this._getMails();
        this.savedInventory = this._getSavedInventory();
        this.teleportEnabled = this.getTeleportEnabled();
        this.ignoredPlayers = this.getIgnoredPlayers();
        this.godmode = this.getGodModeEnabled();
        this.muted = this.getMuted();
        this.muteTimeout = this._getMuteTimeout();
        this.jailed = this.getJailed();
        this.jailTimeout = this._getJailTimeout();
        this.lastLogin = this._getLastLogin();
        this.lastLogout = this._getLastLogout();
        this.afk = this.getAfk();
        this.geolocation = this._getGeoLocation();
        this.isSocialSpyEnabled = this._isSocialSpyEnabled();
    }

    public double getMoney() {
        if (this.config.hasProperty("money")) {
            return this.config.getDouble("money", this.ess.getSettings().getStartingBalance());
        }
        if (this.ess.isIConomyFallbackEnabled()) {
            try {
                return iConomy.getAccount((String)this.getName()).getHoldings().balance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ess.getSettings().getStartingBalance();
    }

    public void setMoney(double value) {
        if (this.ess.isIConomyFallbackEnabled()) {
            try {
                iConomy.getAccount((String)this.getName()).getHoldings().set(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.config.setProperty("money", value);
        this.config.save();
    }

    public boolean hasHome() {
        return this.config.hasProperty("home");
    }

    public Location getHome() {
        if (!this.hasHome()) {
            return null;
        }
        World world = this.getLocation().getWorld();
        String worldHome = "home.worlds." + world.getName().toLowerCase();
        if (!this.config.hasProperty(worldHome)) {
            String defaultWorld = this.config.getString("home.default");
            worldHome = "home.worlds." + defaultWorld;
        }
        Location loc = this.config.getLocation(worldHome, this.getServer());
        return loc;
    }

    public void setHome(Location loc, boolean b) {
        String worldName = loc.getWorld().getName().toLowerCase();
        if (worldName == null || worldName.isEmpty()) {
            logger.log(Level.WARNING, Util.i18n("emptyWorldName"));
            return;
        }
        if (b || !this.config.hasProperty("home.default")) {
            this.config.setProperty("home.default", worldName);
        }
        this.config.setProperty("home.worlds." + worldName, loc);
        this.config.save();
    }

    public String getNickname() {
        return this.config.getString("nickname");
    }

    public void setNickname(String nick) {
        this.config.setProperty("nickname", nick);
        this.config.save();
    }

    private List<Integer> _getUnlimited() {
        return this.config.getIntList("unlimited", new ArrayList());
    }

    public List<Integer> getUnlimited() {
        return this.unlimited;
    }

    public boolean hasUnlimited(ItemStack stack) {
        return this.unlimited.contains(stack.getTypeId());
    }

    public void setUnlimited(ItemStack stack, boolean state) {
        if (this.unlimited.contains(stack.getTypeId())) {
            this.unlimited.remove((Object)stack.getTypeId());
        }
        if (state) {
            this.unlimited.add(stack.getTypeId());
        }
        this.config.setProperty("unlimited", this.unlimited);
        this.config.save();
    }

    private Map<Integer, String> getPowertools() {
        Object o = this.config.getProperty("powertools");
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return new HashMap<Integer, String>();
    }

    public String getPowertool(ItemStack stack) {
        return this.powertools.get(stack.getTypeId());
    }

    public void setPowertool(ItemStack stack, String command) {
        if (command == null || command.isEmpty()) {
            this.powertools.remove(stack.getTypeId());
        } else {
            this.powertools.put(stack.getTypeId(), command);
        }
        this.config.setProperty("powertools", this.powertools);
        this.config.save();
    }

    private Location _getLastLocation() {
        return this.config.getLocation("lastlocation", this.getServer());
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public void setLastLocation(Location loc) {
        this.lastLocation = loc;
        this.config.setProperty("lastlocation", loc);
        this.config.save();
    }

    private long _getLastTeleportTimestamp() {
        return this.config.getLong("timestamps.lastteleport", 0L);
    }

    public long getLastTeleportTimestamp() {
        return this.lastTeleportTimestamp;
    }

    public void setLastTeleportTimestamp(long time) {
        this.lastTeleportTimestamp = time;
        this.config.setProperty("timestamps.lastteleport", time);
        this.config.save();
    }

    private long _getLastHealTimestamp() {
        return this.config.getLong("timestamps.lastheal", 0L);
    }

    public long getLastHealTimestamp() {
        return this.lastHealTimestamp;
    }

    public void setLastHealTimestamp(long time) {
        this.lastHealTimestamp = time;
        this.config.setProperty("timestamps.lastheal", time);
        this.config.save();
    }

    private String _getJail() {
        return this.config.getString("jail");
    }

    public String getJail() {
        return this.jail;
    }

    public void setJail(String jail) {
        if (jail == null || jail.isEmpty()) {
            this.jail = null;
            this.config.removeProperty("jail");
        } else {
            this.jail = jail;
            this.config.setProperty("jail", jail);
        }
        this.config.save();
    }

    private List<String> _getMails() {
        return this.config.getStringList("mail", new ArrayList());
    }

    public List<String> getMails() {
        return this.mails;
    }

    public void setMails(List<String> mails) {
        if (mails == null) {
            this.config.removeProperty("mail");
            mails = this._getMails();
        } else {
            this.config.setProperty("mail", mails);
        }
        this.mails = mails;
        this.config.save();
    }

    public void addMail(String mail) {
        this.mails.add(mail);
        this.setMails(this.mails);
    }

    public ItemStack[] getSavedInventory() {
        return this.savedInventory;
    }

    private ItemStack[] _getSavedInventory() {
        int size = this.config.getInt("inventory.size", 0);
        if (size < 1 || size > this.getInventory().getSize()) {
            return null;
        }
        ItemStack[] is = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            is[i] = this.config.getItemStack("inventory." + i);
        }
        return is;
    }

    public void setSavedInventory(ItemStack[] is) {
        if (is == null || is.length == 0) {
            this.savedInventory = null;
            this.config.removeProperty("inventory");
        } else {
            this.savedInventory = is;
            this.config.setProperty("inventory.size", is.length);
            for (int i = 0; i < is.length; ++i) {
                if (is[i] == null || is[i].getType() == Material.AIR) continue;
                this.config.setProperty("inventory." + i, is[i]);
            }
        }
        this.config.save();
    }

    private boolean getTeleportEnabled() {
        return this.config.getBoolean("teleportenabled", true);
    }

    public boolean isTeleportEnabled() {
        return this.teleportEnabled;
    }

    public void setTeleportEnabled(boolean set) {
        this.teleportEnabled = set;
        this.config.setProperty("teleportenabled", set);
        this.config.save();
    }

    public boolean toggleTeleportEnabled() {
        boolean ret = !this.isTeleportEnabled();
        this.setTeleportEnabled(ret);
        return ret;
    }

    public boolean toggleSocialSpy() {
        boolean ret = !this.isSocialSpyEnabled();
        this.setSocialSpyEnabled(ret);
        return ret;
    }

    public List<String> getIgnoredPlayers() {
        return this.config.getStringList("ignore", new ArrayList());
    }

    public void setIgnoredPlayers(List<String> players) {
        if (players == null || players.isEmpty()) {
            this.ignoredPlayers = new ArrayList<String>();
            this.config.removeProperty("ignore");
        } else {
            this.ignoredPlayers = players;
            this.config.setProperty("ignore", players);
        }
        this.config.save();
    }

    public boolean isIgnoredPlayer(String name) {
        return this.ignoredPlayers.contains(name);
    }

    public void setIgnoredPlayer(String name, boolean set) {
        if (set) {
            this.ignoredPlayers.add(name);
        } else {
            this.ignoredPlayers.remove(name);
        }
        this.setIgnoredPlayers(this.ignoredPlayers);
    }

    private boolean getGodModeEnabled() {
        return this.config.getBoolean("godmode", false);
    }

    public boolean isGodModeEnabled() {
        return this.godmode;
    }

    public void setGodModeEnabled(boolean set) {
        this.godmode = set;
        this.config.setProperty("godmode", set);
        this.config.save();
    }

    public boolean toggleGodModeEnabled() {
        boolean ret = !this.isGodModeEnabled();
        this.setGodModeEnabled(ret);
        return ret;
    }

    private boolean getMuted() {
        return this.config.getBoolean("muted", false);
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean set) {
        this.muted = set;
        this.config.setProperty("muted", set);
        this.config.save();
    }

    public boolean toggleMuted() {
        boolean ret = !this.isMuted();
        this.setMuted(ret);
        return ret;
    }

    private long _getMuteTimeout() {
        return this.config.getLong("timestamps.mute", 0L);
    }

    public long getMuteTimeout() {
        return this.muteTimeout;
    }

    public void setMuteTimeout(long time) {
        this.muteTimeout = time;
        this.config.setProperty("timestamps.mute", time);
        this.config.save();
    }

    private boolean getJailed() {
        return this.config.getBoolean("jailed", false);
    }

    public boolean isJailed() {
        return this.jailed;
    }

    public void setJailed(boolean set) {
        this.jailed = set;
        this.config.setProperty("jailed", set);
        this.config.save();
    }

    public boolean toggleJailed() {
        boolean ret = !this.isJailed();
        this.setJailed(ret);
        return ret;
    }

    private long _getJailTimeout() {
        return this.config.getLong("timestamps.jail", 0L);
    }

    public long getJailTimeout() {
        return this.jailTimeout;
    }

    public void setJailTimeout(long time) {
        this.jailTimeout = time;
        this.config.setProperty("timestamps.jail", time);
        this.config.save();
    }

    public String getBanReason() {
        return this.config.getString("ban.reason");
    }

    public void setBanReason(String reason) {
        this.config.setProperty("ban.reason", reason);
        this.config.save();
    }

    public long getBanTimeout() {
        return this.config.getLong("ban.timeout", 0L);
    }

    public void setBanTimeout(long time) {
        this.config.setProperty("ban.timeout", time);
        this.config.save();
    }

    private long _getLastLogin() {
        return this.config.getLong("timestamps.login", 0L);
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long time) {
        this.lastLogin = time;
        this.config.setProperty("timestamps.login", time);
        this.config.save();
    }

    private long _getLastLogout() {
        return this.config.getLong("timestamps.logout", 0L);
    }

    public long getLastLogout() {
        return this.lastLogout;
    }

    public void setLastLogout(long time) {
        this.lastLogout = time;
        this.config.setProperty("timestamps.logout", time);
        this.config.save();
    }

    private boolean getAfk() {
        return this.config.getBoolean("afk", false);
    }

    public boolean isAfk() {
        return this.afk;
    }

    public void setAfk(boolean set) {
        this.afk = set;
        this.config.setProperty("afk", set);
        this.config.save();
    }

    public boolean toggleAfk() {
        boolean ret = !this.isAfk();
        this.setAfk(ret);
        return ret;
    }

    private boolean getNew() {
        return this.config.getBoolean("newplayer", true);
    }

    public boolean isNew() {
        return this.newplayer;
    }

    public void setNew(boolean set) {
        this.newplayer = set;
        this.config.setProperty("newplayer", set);
        this.config.save();
    }

    private String _getGeoLocation() {
        return this.config.getString("geolocation");
    }

    public String getGeoLocation() {
        return this.geolocation;
    }

    public void setGeoLocation(String geolocation) {
        if (geolocation == null || geolocation.isEmpty()) {
            this.geolocation = null;
            this.config.removeProperty("geolocation");
        } else {
            this.geolocation = geolocation;
            this.config.setProperty("geolocation", geolocation);
        }
        this.config.save();
    }

    private boolean _isSocialSpyEnabled() {
        return this.config.getBoolean("socialspy", false);
    }

    public boolean isSocialSpyEnabled() {
        return this.isSocialSpyEnabled;
    }

    public void setSocialSpyEnabled(Boolean status) {
        this.isSocialSpyEnabled = status;
        this.config.setProperty("socialspy", status);
        this.config.save();
    }
}

