/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.inventory.ItemStack;

public class Worth
implements IConf {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private EssentialsConf config;

    public Worth(File dataFolder) {
        this.config = new EssentialsConf(new File(dataFolder, "worth.yml"));
        this.config.setTemplateName("/worth.yml");
        this.config.load();
    }

    public double getPrice(ItemStack itemStack) {
        String itemname = itemStack.getType().toString().toLowerCase().replace("_", "");
        double result = this.config.getDouble("worth." + itemname + "." + itemStack.getDurability(), Double.NaN);
        if (Double.isNaN(result)) {
            result = this.config.getDouble("worth." + itemname + ".0", Double.NaN);
        }
        if (Double.isNaN(result)) {
            result = this.config.getDouble("worth." + itemname, Double.NaN);
        }
        if (Double.isNaN(result)) {
            result = this.config.getDouble("worth-" + itemStack.getTypeId(), Double.NaN);
        }
        return result;
    }

    public void setPrice(ItemStack itemStack, double price) {
        if (itemStack.getType().getData() == null) {
            this.config.setProperty("worth." + itemStack.getType().toString().toLowerCase().replace("_", ""), price);
        } else {
            this.config.setProperty("worth." + itemStack.getType().toString().toLowerCase().replace("_", "") + "." + itemStack.getDurability(), price);
        }
        this.config.removeProperty("worth-" + itemStack.getTypeId());
        this.config.save();
    }

    public void reloadConfig() {
        this.config.load();
    }
}

