/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class Commandtp
extends EssentialsCommand {
    public Commandtp() {
        super("tp");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        switch (args.length) {
            case 0: {
                throw new NotEnoughArgumentsException();
            }
            case 1: {
                User p = this.getPlayer(server, args, 0);
                if (!p.isTeleportEnabled()) {
                    throw new Exception(p.getDisplayName() + " has teleportation disabled.");
                }
                user.sendMessage("\u00a77Teleporting...");
                user.canAfford(this);
                user.getTeleport().teleport((Entity)p, this.getName());
                break;
            }
            case 2: {
                if (!user.isAuthorized("essentials.tpohere")) {
                    throw new Exception("You need access to /tpohere to teleport other players.");
                }
                user.sendMessage("\u00a77Teleporting...");
                this.charge((CommandSender)user);
                User target = this.getPlayer(server, args, 0);
                User toPlayer = this.getPlayer(server, args, 1);
                target.getTeleport().now((Entity)toPlayer);
                target.sendMessage("\u00a77" + user.getDisplayName() + "\u00a77 teleported you to " + toPlayer.getDisplayName() + "\u00a77.");
            }
        }
    }

    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        sender.sendMessage("\u00a77Teleporting...");
        User target = this.getPlayer(server, args, 0);
        User toPlayer = this.getPlayer(server, args, 1);
        target.getTeleport().now((Entity)toPlayer);
        target.sendMessage("\u00a77{Console}\u00a77 teleported you to " + toPlayer.getDisplayName() + "\u00a77.");
    }
}

