/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop.Chests;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.Chests.ChestObject;
import com.Acrobot.iConomyChestShop.ConfigManager;
import com.aranai.virtualchest.VirtualChest;
import org.bukkit.inventory.ItemStack;

public class GiftPost
implements ChestObject {
    private final VirtualChest chest;

    public GiftPost(VirtualChest v) {
        this.chest = v;
    }

    @Override
    public ItemStack[] getContents() {
        return this.chest.getContents();
    }

    @Override
    public void setSlot(int slot, ItemStack item) {
        this.chest.setItem(slot, item);
    }

    @Override
    public void clearSlot(int slot) {
        this.chest.setItem(slot, null);
    }

    @Override
    public void addItem(ItemStack item, int amount) {
        item.setAmount(amount);
        this.chest.addItem(new ItemStack[]{item});
    }

    @Override
    public void removeItem(ItemStack item, int amount) {
        int type = item.getTypeId();
        boolean checkDurability = true;
        if (ConfigManager.getBoolean("allowUsedItemsToBeSold") && type >= 256 && type <= 317) {
            checkDurability = false;
        }
        int i = 0;
        while (i < this.chest.usedCases()) {
            ItemStack is = this.chest.getItem(i);
            if (is != null) {
                short durability = item.getDurability();
                int isAmount = is.getAmount();
                if (!(is.getTypeId() != type || checkDurability && durability != -1 && is.getDurability() != durability)) {
                    if (isAmount - amount > 0) {
                        this.chest.setItem(i, new ItemStack(type, isAmount - amount, durability));
                        return;
                    }
                    if (isAmount - amount == 0) {
                        return;
                    }
                    amount -= isAmount;
                    this.chest.setItem(i, null);
                }
            }
            ++i;
        }
    }

    @Override
    public int amount(ItemStack item) {
        return Basic.getItemAmount(this.chest.getContents(), item);
    }

    @Override
    public boolean hasEnough(ItemStack item, int amount) {
        return this.amount(item) >= amount;
    }

    @Override
    public boolean fits(ItemStack item, int amount) {
        return true;
    }

    @Override
    public int getSize() {
        return this.chest.usedCases();
    }
}

