/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaChest;
import com.Acrobot.iConomyChestShop.SignManager;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.yi.acru.bukkit.Lockette.Lockette;

public class ProtectionManager {
    public static LWC lwc = null;
    public static Lockette lockette = null;

    public static boolean isProtected(Block chest) {
        boolean lockProt;
        Protection lwcProt;
        if (lwc != null && (lwcProt = lwc.findProtection(chest)) != null) {
            return true;
        }
        return lockette != null && (lockProt = Lockette.isProtected((Block)chest));
    }

    public static String protectedByWho(Block chest) {
        Protection prot;
        if (chest == null) {
            return null;
        }
        String name = "";
        if (lwc != null && (prot = lwc.findProtection(chest)) != null) {
            name = prot.getOwner();
        }
        if (lockette != null) {
            name = Lockette.getProtectedOwner((Block)chest);
        }
        return name;
    }

    public static boolean protectBlock(Block block, String name) {
        if (!ConfigManager.getBoolean("LWCprotection")) {
            return false;
        }
        if (lwc != null) {
            lwc.getPhysicalDatabase().registerProtection(block.getTypeId(), 2, block.getWorld().getName(), name, "", block.getX(), block.getY(), block.getZ());
            return true;
        }
        return false;
    }

    public static void chestDestroy(Block chest, Player player, BlockBreakEvent event) {
        if (!ProtectionManager.cfgProtection()) {
            return;
        }
        CraftSign sign = ProtectionManager.getSign(chest, false);
        if (sign == null) {
            return;
        }
        if (!SignManager.mySign((Sign)sign)) {
            return;
        }
        if (!sign.getLine(0).equals(player.getName())) {
            player.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
            event.setCancelled(true);
        }
    }

    public static void chestInteract(Block chest, Player player, PlayerInteractEvent event) {
        if (!ProtectionManager.cfgProtection()) {
            return;
        }
        CraftSign sign = ProtectionManager.getSign(chest, false);
        if (sign == null) {
            return;
        }
        if (!SignManager.mySign((Sign)sign)) {
            return;
        }
        if (!sign.getLine(0).equals(player.getName())) {
            player.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
            event.setCancelled(true);
        }
    }

    public static void blockDestroy(Block block, Player player, BlockBreakEvent event) {
        Block[] blocks;
        Block[] blockArray = blocks = new Block[]{block.getFace(BlockFace.EAST), block.getFace(BlockFace.WEST), block.getFace(BlockFace.NORTH), block.getFace(BlockFace.SOUTH)};
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            CraftSign s;
            Block block1 = blockArray[n2];
            Material blockType = block1.getType();
            if ((blockType.equals((Object)Material.SIGN) || blockType.equals((Object)Material.SIGN_POST) || blockType.equals((Object)Material.WALL_SIGN)) && SignManager.mySign((Sign)(s = (CraftSign)block1.getState())) && !s.getLine(0).equals(player.getName())) {
                player.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
                event.setCancelled(true);
            }
            ++n2;
        }
    }

    public static void signDestroy(Block sign, Player player, BlockBreakEvent event) {
        CraftSign s = (CraftSign)sign.getState();
        if (!SignManager.mySign((Sign)s)) {
            return;
        }
        if (!s.getLine(0).equals(player.getName())) {
            player.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
            event.setCancelled(true);
            s.update();
        }
    }

    public static CraftSign getSign(Block chest, boolean recurency) {
        Block neighborChest;
        CraftSign sign = Basic.findSign(chest);
        if (sign != null) {
            return sign;
        }
        if (!recurency && (neighborChest = MinecartManiaChest.getNeightborChestBlock(chest)) != null) {
            return ProtectionManager.getSign(neighborChest, true);
        }
        return null;
    }

    public static boolean cfgProtection() {
        return ConfigManager.getBoolean("protection");
    }
}

