/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.Chests.MinecraftChest;
import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.Logging;
import com.Acrobot.iConomyChestShop.PermissionManager;
import com.Acrobot.iConomyChestShop.ProtectionManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;

public class SignManager
extends BlockListener {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSignChange(SignChangeEvent event) {
        Block ChestB;
        String alias;
        boolean isGoodSign;
        Player p = event.getPlayer();
        Block block = event.getBlock();
        Location blockLoc = block.getLocation();
        String location = String.valueOf(blockLoc.getWorld().getName()) + ", x = " + blockLoc.getBlockX() + ", y = " + blockLoc.getBlockY() + ", z = " + blockLoc.getBlockZ();
        Material type = block.getType();
        String playerName = p.getName();
        boolean isAdmin = PermissionManager.hasPermissions(p, "iConomyChestShop.admin");
        if (!(type.equals((Object)Material.SIGN) || type.equals((Object)Material.SIGN_POST) || type.equals((Object)Material.WALL_SIGN))) {
            return;
        }
        if (!Basic.checkConfig(p)) {
            p.sendMessage("[iConomyChestShop] Aborting!");
            return;
        }
        String[] text = event.getLines();
        MinecraftChest chest = Basic.findChest(block);
        if (!Basic.isInt(text[1])) return;
        String[] split = text[2].split(":");
        boolean isFormated = SignManager.mySign(text);
        try {
            if ((text[0].contains("[") || (split.length == 2 ? !Basic.isFloat(split[0]) || !Basic.isFloat(split[1]) : !Basic.isFloat(text[2]))) && !isFormated) {
                return;
            }
            boolean bl = true;
            isGoodSign = bl;
        }
        catch (Exception ex) {
            return;
        }
        if (!isGoodSign) return;
        if (chest != null) {
            if (!isAdmin) {
                CraftSign sig;
                Block ChestB2 = chest.main.getChest().getBlock();
                CraftSign sign = ProtectionManager.getSign(ChestB2, false);
                if (sign != null && !sign.getLine(0).equals(p.getName())) {
                    p.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
                    Basic.cancelEventAndDropSign(event);
                    return;
                }
                if (ProtectionManager.isProtected(ChestB2) && ProtectionManager.protectedByWho(ChestB2) != null && !ProtectionManager.protectedByWho(ChestB2).equals(Basic.stripName(playerName))) {
                    p.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
                    Basic.cancelEventAndDropSign(event);
                    return;
                }
                if (chest.extended != null && (sig = ProtectionManager.getSign(chest.extended.getChest().getBlock(), true)) != null && !sig.getLine(0).equals(playerName) && !isAdmin) {
                    p.sendMessage(ConfigManager.getLanguage("You_tried_to_steal"));
                    Basic.cancelEventAndDropSign(event);
                    return;
                }
            }
        } else if (!text[0].toLowerCase().replace(" ", "").equals("adminshop")) {
            if (ConfigManager.getBoolean("doNotRemoveSignIfNotCorrect")) {
                return;
            }
            Basic.cancelEventAndDropSign(event);
            p.sendMessage(ConfigManager.getLanguage("Shop_cannot_be_created"));
            return;
        }
        if (text[0].equals("") || text[0].startsWith("[") || !isAdmin) {
            event.setLine(0, playerName);
        }
        if (SignManager.priceIsNegative(text[2])) {
            Basic.cancelEventAndDropSign(event);
            p.sendMessage(ConfigManager.getLanguage("Negative_price"));
            return;
        }
        if (!this.priceIsOK(text[2]) && !isAdmin) {
            p.sendMessage(ConfigManager.getLanguage("Incorrect_price"));
            Basic.cancelEventAndDropSign(event);
            return;
        }
        if (Integer.parseInt(text[1]) < 1) {
            Basic.cancelEventAndDropSign(event);
            p.sendMessage(ConfigManager.getLanguage("Incorrect_item_amount"));
            return;
        }
        ItemStack itemStack = Basic.getItemStack(text[3].replace(":", ";"));
        if (itemStack == null) {
            Basic.cancelEventAndDropSign(event);
            p.sendMessage(ConfigManager.getLanguage("incorrectID"));
            return;
        }
        if (!isAdmin && (PermissionManager.hasPermissions(p, "iConomyChestShop.shop.exclude." + itemStack.getTypeId()) || !PermissionManager.hasPermissions(p, "iConomyChestShop.shop.create") && !PermissionManager.hasPermissions(p, "iConomyChestShop.shop.create." + itemStack.getTypeId()))) {
            p.sendMessage("[Permissions] You can't make this type of shop!");
            Basic.cancelEventAndDropSign(event);
            return;
        }
        if (Basic.isInt(text[3])) {
            Material signMat = itemStack.getType();
            if (signMat == null) {
                Basic.cancelEventAndDropSign(event);
                p.sendMessage(ConfigManager.getLanguage("incorrectID"));
                return;
            }
            String alias2 = Basic.returnAlias(signMat.name());
            if (alias2 != null) {
                event.setLine(3, alias2);
            } else {
                if (signMat.name() == null) {
                    Basic.cancelEventAndDropSign(event);
                    p.sendMessage(ConfigManager.getLanguage("incorrectID"));
                    return;
                }
                event.setLine(3, signMat.name());
            }
        } else if ((text[3].contains(";") || text[3].contains(":")) && (alias = Basic.returnAlias(text[3].replace(":", ";"))) != null) {
            event.setLine(3, alias);
        }
        if (text[2].length() > 11 && !isFormated || text[1].length() > 15) {
            Basic.cancelEventAndDropSign(event);
            p.sendMessage(ConfigManager.getLanguage("Couldnt_fit_on_sign"));
            return;
        }
        if (!isFormated) {
            event.setLine(2, "B " + (split.length == 2 ? String.valueOf(split[0]) + ":" + split[1] + " S" : text[2]));
        }
        if (ConfigManager.getBoolean("signLWCprotection")) {
            ProtectionManager.protectBlock(block, text[0]);
        }
        if (chest != null && ProtectionManager.protectBlock(ChestB = chest.main.getChest().getBlock(), text[0])) {
            p.sendMessage(ConfigManager.getLanguage("Shop_was_LWC_protected"));
        }
        p.sendMessage(ConfigManager.getLanguage("Shop_is_created"));
        text = event.getLines();
        Logging.log(String.valueOf(playerName) + " created shop in " + location + ", which first line is " + text[0] + " and it buys/sells " + text[1] + " " + text[3] + ", and the buy/sell line looks like: \"" + text[2] + "\"");
    }

    private boolean priceIsOK(String signLine) {
        Double maxPrice = ConfigManager.getDouble("maxPrice");
        Double minPrice = ConfigManager.getDouble("minPrice");
        Float buyPrice = Float.valueOf(SignManager.buyPrice(signLine));
        Float sellPrice = Float.valueOf(SignManager.sellPrice(signLine));
        return !(maxPrice != -1.0 && ((double)buyPrice.floatValue() > maxPrice || (double)sellPrice.floatValue() > maxPrice) || minPrice != -1.0 && ((double)buyPrice.floatValue() < minPrice || (double)sellPrice.floatValue() < minPrice));
    }

    public static boolean mySign(Sign sign) {
        return SignManager.mySign(sign.getLines());
    }

    public static boolean mySign(String[] text) {
        try {
            String textToParse = text[2].replace(" ", "");
            return (textToParse.contains("S") || textToParse.contains("B")) && !text[3].isEmpty() && Basic.isInt(text[1]) && !text[0].contains("[");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static float buyPrice(String text) {
        text = text.replace(" ", "");
        String[] bs = (text = text.toLowerCase()).split(":");
        if (bs.length == 1) {
            if (!text.contains("b")) {
                return 0.0f;
            }
            if ((text = text.replace("b", "")).equals("free")) {
                return -1.0f;
            }
            if (Basic.isFloat(text)) {
                return Float.parseFloat(text);
            }
        } else if (bs.length == 2) {
            text = bs[0];
            if ((text = text.replace("b", "")).equals("free")) {
                return -1.0f;
            }
            if (Basic.isFloat(text)) {
                return Float.parseFloat(text);
            }
        }
        return 0.0f;
    }

    public static float buyPrice(Sign sign) {
        String text = sign.getLine(2);
        return SignManager.buyPrice(text);
    }

    public static float sellPrice(String text) {
        text = text.replace(" ", "");
        String[] bs = (text = text.toLowerCase()).split(":");
        if (bs.length == 1) {
            if (!text.contains("s")) {
                return 0.0f;
            }
            if ((text = text.replace("s", "")).equals("free")) {
                return -1.0f;
            }
            if (Basic.isFloat(text)) {
                return Float.parseFloat(text);
            }
        } else if (bs.length == 2) {
            text = bs[1];
            if ((text = text.replace("s", "")).equals("free")) {
                return -1.0f;
            }
            if (Basic.isFloat(text)) {
                return Float.parseFloat(text);
            }
        }
        return 0.0f;
    }

    public static boolean priceIsNegative(String text) {
        String[] bs = (text = text.replace(" ", "")).split(":");
        if (bs.length == 1) {
            String fNum = text.replaceAll("[A-Z,a-z]", "");
            if (Basic.isFloat(fNum) && Float.parseFloat(fNum) < 0.0f) {
                return true;
            }
        } else if (bs.length == 2) {
            int i = 0;
            while (i <= 1) {
                text = bs[i];
                String fNum = text.replaceAll("[A-Z,a-z]", "");
                if (Basic.isFloat(fNum) && Float.parseFloat(fNum) < 0.0f) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static float sellPrice(Sign sign) {
        String text = sign.getLine(2);
        return SignManager.sellPrice(text);
    }

    public static int getItemAmount(Sign sign) {
        String test = sign.getLine(1);
        if (Basic.isInt(test)) {
            return Integer.parseInt(test);
        }
        return 0;
    }

    public static String getOwner(Sign sign) {
        return sign.getLine(0);
    }
}

