/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.Logging;
import com.Acrobot.iConomyChestShop.Transaction;
import com.Acrobot.iConomyChestShop.iConomyChestShop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class StatGenerator
implements Runnable {
    private static iConomyChestShop plugin;
    private static long time;
    private static String row;
    private static String header;
    private static String footer;
    private static boolean unusedItems;
    private static String filePath;
    private static BufferedWriter buf;

    static {
        row = StatGenerator.fileToString("row");
        header = StatGenerator.fileToString("header");
        footer = StatGenerator.fileToString("footer");
        unusedItems = ConfigManager.getBoolean("showUnusedItemsInGeneratedList");
        filePath = ConfigManager.getString("generatedTransactionListPath");
    }

    public static void setPlugin(iConomyChestShop plugin) {
        StatGenerator.plugin = plugin;
    }

    public static void generateStatisticForItem(int itemID) {
        StatGenerator.generateStatisticForItem(itemID, -1);
    }

    public static float generateAverageBuyPrice(int itemID) {
        float price = 0.0f;
        List prices = plugin.getDatabase().find(Transaction.class).where().eq("itemID", (Object)itemID).eq("buy", (Object)1).findList();
        for (Transaction t : prices) {
            price += t.getPrice();
        }
        float toReturn = price / (float)prices.size();
        return !Float.isNaN(toReturn) ? toReturn : 0.0f;
    }

    public static float generateAverageSellPrice(int itemID) {
        float price = 0.0f;
        List prices = plugin.getDatabase().find(Transaction.class).where().eq("itemID", (Object)itemID).eq("buy", (Object)0).findList();
        for (Transaction t : prices) {
            price += t.getPrice() / (float)t.getAmount();
        }
        float toReturn = price / (float)prices.size();
        return !Float.isNaN(toReturn) ? toReturn : 0.0f;
    }

    public static double generateItemTotal(int itemID) {
        return StatGenerator.generateItemTotal(itemID, false);
    }

    public static double generateItemTotal(int itemID, boolean bought) {
        return StatGenerator.generateItemTotal(itemID, bought, false);
    }

    public static double generateItemTotal(int itemID, boolean bought, boolean sold) {
        double amount = 0.0;
        List list = bought ? plugin.getDatabase().find(Transaction.class).where().eq("buy", (Object)1).eq("itemID", (Object)itemID).findList() : (sold ? plugin.getDatabase().find(Transaction.class).where().eq("buy", (Object)0).eq("itemID", (Object)itemID).findList() : plugin.getDatabase().find(Transaction.class).where().eq("itemID", (Object)itemID).findList());
        for (Transaction t : list) {
            amount += (double)t.getAmount();
        }
        return amount;
    }

    public static double generateTotalBought(int itemID) {
        return StatGenerator.generateItemTotal(itemID, true);
    }

    public static double generateTotalSold(int itemID) {
        return StatGenerator.generateItemTotal(itemID, false, true);
    }

    public static void generateStatisticForItem(int itemID, int itemDurability) {
        try {
            double total = StatGenerator.generateItemTotal(itemID);
            double bought = StatGenerator.generateTotalBought(itemID);
            double sold = StatGenerator.generateTotalSold(itemID);
            String matName = Material.getMaterial((int)itemID).name().replace("_", " ").toLowerCase();
            float buyPrice = StatGenerator.generateAverageBuyPrice(itemID);
            int maxStackSize = Material.getMaterial((int)itemID).getMaxStackSize();
            if (total == 0.0 && !unusedItems) {
                return;
            }
            buf.write(row.replace("%material", matName).replace("%total", String.valueOf(total)).replace("%bought", String.valueOf(bought)).replace("%sold", String.valueOf(sold)).replace("%maxStackSize", String.valueOf(maxStackSize)).replace("%pricePerStack", String.valueOf(buyPrice * (float)maxStackSize)).replace("%pricePerItem", String.valueOf(buyPrice)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void fileStart() throws IOException {
        FileWriter fw = new FileWriter(filePath);
        fw.write(header);
        fw.close();
    }

    public static void fileEnd() throws IOException {
        FileWriter fw = new FileWriter(filePath, true);
        fw.write(footer.replace("%time", String.valueOf(time)));
        fw.close();
    }

    public static void generateStatistics() {
        try {
            time = System.currentTimeMillis();
            plugin.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)plugin, (Runnable)new Logging());
            StatGenerator.fileStart();
            FileWriter fileWriter = new FileWriter(filePath, true);
            buf = new BufferedWriter(fileWriter);
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n2 = 0;
            while (n2 < n) {
                Material m = materialArray[n2];
                StatGenerator.generateStatisticForItem(m.getId());
                ++n2;
            }
            buf.close();
            time = System.currentTimeMillis() - time;
            StatGenerator.fileEnd();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String fileToString(String fileName) {
        try {
            File f = new File("plugins/iConomyChestShop/" + fileName + ".txt");
            FileReader rd = new FileReader(f);
            char[] buf = new char[(int)f.length()];
            rd.read(buf);
            return new String(buf);
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public void run() {
        StatGenerator.generateStatistics();
    }
}

