/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import com.gemo.utils.FBBlockType;
import com.gemo.utils.SignUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC0263
extends SelftriggeredBaseIC {
    private boolean oldStatus;
    private Block myBlock = null;
    private boolean result;
    private int BlockID;
    private byte BlockData;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 10;
        this.Name = "BLOCK SENSOR";
        this.MCName = "[MC0263]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Output: High if the block is present", "", "");
        this.chipState.setLines("Y offset, with 0 being the IC block. Leave blank to default to the block below.", "BlockID[:SubID]");
        this.ICDescription = "The MC0263 checks for the presence of a specified block relative to the block behind the IC sign. By default it checks the block directly underneath but this can be changed.";
    }

    public MC0263(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0263(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC0263.isActivated(this.signBlock);
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        Player player;
        block11: {
            if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
                MC0263.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
                return;
            }
            player = event.getPlayer();
            if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
                event.setLine(0, this.Name);
                event.setLine(1, this.MCName);
                if (event.getLine(2).length() < 1) {
                    event.setLine(2, "-1");
                }
                String yOffset = event.getLine(2);
                try {
                    if (yOffset.length() > 0) {
                        Integer.parseInt(yOffset);
                    }
                }
                catch (NumberFormatException e) {
                    MC0263.cancelCreation(event, "The third line must be a number or be blank.");
                    return;
                }
                if (event.getLine(2) == null) {
                    MC0263.cancelCreation(event, "Item not found");
                    return;
                }
                String[] split = event.getLine(3).split(":");
                try {
                    if (!MC0263.isValidBlock(Integer.valueOf(split[0]))) {
                        MC0263.cancelCreation(event, "Block not found");
                        return;
                    }
                    break block11;
                }
                catch (Exception e) {
                    if (!MC0263.isValidBlock(MC0263.getItemIDFromName(event.getLine(3)))) {
                        MC0263.cancelCreation(event, "Block not found");
                        return;
                    }
                    break block11;
                }
            }
            MC0263.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            try {
                this.myBlock = MC0263.getICBlock(this.signBlock).getBlock().getRelative(0, Integer.valueOf(this.signBlock.getLine(2)).intValue(), 0);
                ArrayList thisItems = SignUtils.parseItems((String)this.signBlock.getLine(3), (String)"-", (boolean)true);
                if (thisItems.size() == 1) {
                    this.BlockID = ((FBBlockType)thisItems.get(0)).getItemID();
                    this.BlockData = ((FBBlockType)thisItems.get(0)).getItemData();
                }
                thisItems.clear();
                thisItems = null;
            }
            catch (Exception e) {
                this.myBlock = null;
            }
            this.startUp = false;
        }
        if (this.myBlock == null) {
            return;
        }
        boolean bl = this.result = this.myBlock.getTypeId() == this.BlockID && this.myBlock.getData() == this.BlockData || this.myBlock.getTypeId() == this.BlockID && this.BlockData == -1;
        if (this.result != this.oldStatus) {
            this.oldStatus = this.result;
            MC0263.switchLever(this.signBlock, this.result);
        }
    }
}

