/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import com.gemo.utils.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.Slime;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.event.block.SignChangeEvent;

public class MC0271
extends SelftriggeredBaseIC {
    private boolean oldStatus;
    private boolean result;
    private int detectionRange = -1;
    private int detectionMode = -1;
    List<String> Types = new ArrayList<String>();

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 12;
        this.Name = "DETECTION";
        this.MCName = "[MC0271]";
        this.MCGroup = "selftriggered";
        this.Types.add("PLAYER");
        this.Types.add("MOBHOSTILE");
        this.Types.add("MOBPEACEFUL");
        this.Types.add("ANYMOB");
        this.Types.add("ANY");
        this.Types.add("CART");
        this.Types.add("STORAGECART");
        this.Types.add("POWEREDCART");
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Output", "", "");
        this.chipState.setLines("distance of detection around the IC block", "detection type");
        this.ICDescription = "The MC0271 outputs high if the specified type is detected in the given distance around the ic.<br /><br /><b>Detection types:</b><ul><li>PLAYER</li><li>MOBHOSTILE</li><li>MOBPEACEFUL</li><li>ANYMOB</li><li>ANY</li><li>CART</li><li>STORAGECART</li><li>POWEREDCART</li></ul><br /><br />";
    }

    public MC0271(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0271(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC0271.isActivated(this.signBlock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0271.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC0271.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        if (event.getLine(2).length() <= 0) {
            MC0271.cancelCreation(event, "Line 3 must be a number.");
            return;
        }
        try {
            Integer.valueOf(event.getLine(2));
        }
        catch (Exception e) {
            MC0271.cancelCreation(event, "Line 3 must be a number.");
            return;
        }
        if (event.getLine(3).length() <= 0) {
            MC0271.cancelCreation(event, "Please enter a Type in Line 4.");
            return;
        }
        boolean f = false;
        int i = 0;
        while (i < this.Types.size()) {
            if (this.Types.get(i).equalsIgnoreCase(event.getLine(3))) {
                f = true;
                event.setLine(3, this.Types.get(i));
            }
            ++i;
        }
        if (!f) {
            MC0271.cancelCreation(event, "Type not found.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            try {
                this.detectionRange = Integer.valueOf(this.signBlock.getLine(2));
                int i = 0;
                while (i < this.Types.size()) {
                    if (this.Types.get(i).equalsIgnoreCase(this.signBlock.getLine(3))) {
                        this.detectionMode = i;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.detectionRange = -1;
                this.detectionMode = -1;
            }
            this.startUp = false;
        }
        if (this.detectionMode == -1) {
            return;
        }
        this.result = false;
        Location blockLoc = MC0271.getICBlock(this.signBlock);
        int nowTyp = this.detectionMode;
        switch (nowTyp) {
            case 0: {
                Player[] playerList;
                Player[] playerArray = playerList = FalseBookICCore.server.getOnlinePlayers();
                int n = playerList.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    this.result = BlockUtils.isInRange((Location)player.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                    ++n2;
                }
                playerList = null;
                break;
            }
            case 1: {
                List liste = this.signBlock.getWorld().getLivingEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof Monster) && !(ent instanceof Ghast) && !(ent instanceof Giant) && !(ent instanceof Slime)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                liste = null;
                break;
            }
            case 2: {
                List liste = this.signBlock.getWorld().getLivingEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof Animals)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                liste = null;
                break;
            }
            case 3: {
                List liste = this.signBlock.getWorld().getLivingEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof Animals) && !(ent instanceof Monster) && !(ent instanceof Ghast) && !(ent instanceof Giant) && !(ent instanceof Slime)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                liste = null;
                break;
            }
            case 4: {
                List liste = this.signBlock.getWorld().getLivingEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof Player) && !(ent instanceof Animals) && !(ent instanceof Monster) && !(ent instanceof Ghast) && !(ent instanceof Giant) && !(ent instanceof Slime) && !(ent instanceof Minecart) && !(ent instanceof StorageMinecart) && !(ent instanceof PoweredMinecart)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                liste = null;
                break;
            }
            case 5: {
                List liste = this.signBlock.getWorld().getEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof Minecart)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                liste = null;
                break;
            }
            case 6: {
                List liste = this.signBlock.getWorld().getEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof StorageMinecart)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                liste = null;
                break;
            }
            case 7: {
                List liste = this.signBlock.getWorld().getEntities();
                for (Entity ent : liste) {
                    if (!(ent instanceof PoweredMinecart)) continue;
                    this.result = BlockUtils.isInRange((Location)ent.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                    if (this.result) break;
                }
                liste.clear();
                Object var3_12 = null;
            }
        }
        blockLoc = null;
        if (this.result != this.oldStatus) {
            this.oldStatus = this.result;
            MC0271.switchLever(this.signBlock, this.result);
        }
    }
}

