/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC3034
extends BaseIC {
    public MC3034(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "D EDGE FLIPFLOP";
        this.MCName = "[MC3034]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(false, true, true, "Data", "Clock", "Reset");
        this.chipState.setOutputs("Output", "", "");
        this.ICDescription = "The MC3034 implements a flip flop that sets its output to the state of the D (\"data\") input whenever the clock input goes from low to high. If the D input changes state without the clock going from low to high, the output will not change. If the D input changes while the clock is high, the output will not change. Also, while the reset input is high the output state is forced to low.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC3034.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC3034.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC3034.getBlockPositions(signBlock);
        boolean inputD = MC3034.isPowered(positions.get(0));
        boolean inputC = MC3034.isPowered(positions.get(1));
        boolean inputR = MC3034.isPowered(positions.get(2));
        if (inputR) {
            MC3034.switchLever(signBlock, false);
        } else if (inputC) {
            if (inputD) {
                MC3034.switchLever(signBlock, true);
            } else {
                MC3034.switchLever(signBlock, false);
            }
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

