/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC4110
extends BaseIC {
    public MC4110(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "HALF SUBTRACTOR";
        this.MCName = "[MC4110]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(false, true, true, "Always ignored (front input)", "First bit to subract (subtrahend)", "Second bit to subtract (subtrahend)");
        this.chipState.setOutputs("Difference", "Borrow", "Borrow (always the same as Output2)");
        this.ICDescription = "The MC4110 implements a <a href=\"http://en.wikipedia.org/wiki/Subtractor#Half_subtractor\">half subtractor.</a>";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC4110.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC4110.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC4110.getBlockPositions(signBlock);
        boolean inputB = MC4110.isPowered(positions.get(1));
        boolean inputC = MC4110.isPowered(positions.get(2));
        boolean result = inputB ^ inputC;
        boolean carry = !inputB & inputC;
        MC4110.switchLever(signBlock, result, 3);
        MC4110.switchLeverLeft(signBlock, carry, 2);
        MC4110.switchLeverRight(signBlock, carry, 2);
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

