/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.utils.FBBlockType;
import com.gemo.utils.SignUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1207
extends BaseIC {
    public MC1207(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "SET BLOCK";
        this.MCName = "[MC1207]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("BlockIDOn[:SubID][-BlockIDOff[:SubID]] (Examples: 'wool:15-stone' or 'grass' or 'dirt-44:2')", "Y offset, with 0 being the IC block.");
        this.ICDescription = "The MC1207 sets the specified block to the specified blocktype whenever the input (the \"clock\") changes.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        Player player;
        block14: {
            String[] split;
            String[] lineSplit;
            block13: {
                if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
                    MC1207.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
                    return;
                }
                player = event.getPlayer();
                if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
                    MC1207.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
                    return;
                }
                event.setLine(0, this.Name);
                event.setLine(1, this.MCName);
                if (event.getLine(2) == null) {
                    MC1207.cancelCreation(event, "Item not found");
                    return;
                }
                lineSplit = event.getLine(2).split("-");
                split = lineSplit[0].split(":");
                try {
                    if (!MC1207.isValidBlock(Integer.valueOf(split[0]))) {
                        MC1207.cancelCreation(event, "Block not found");
                        return;
                    }
                }
                catch (Exception e) {
                    if (MC1207.isValidBlock(MC1207.getItemIDFromName(split[0]))) break block13;
                    MC1207.cancelCreation(event, "Block not found.");
                    return;
                }
            }
            if (lineSplit.length > 1) {
                split = lineSplit[1].split(":");
                try {
                    if (!MC1207.isValidBlock(Integer.valueOf(split[0]))) {
                        MC1207.cancelCreation(event, "Block not found");
                        return;
                    }
                }
                catch (Exception e) {
                    if (MC1207.isValidBlock(split[0])) break block14;
                    MC1207.cancelCreation(event, "Block not found.");
                    return;
                }
            }
        }
        if (event.getLine(3).length() <= 0) {
            MC1207.cancelCreation(event, "Line 4 must be a number.");
            return;
        }
        try {
            Integer.valueOf(event.getLine(3));
        }
        catch (Exception e) {
            MC1207.cancelCreation(event, "Line 4 must be a number.");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList items;
        ArrayList<Location> positions = MC1207.getBlockPositions(signBlock);
        int ItemID = -1;
        int ItemID2 = -1;
        Byte ItemData = 0;
        Byte ItemData2 = 0;
        int dist = 1;
        if (signBlock.getLine(3) != null) {
            dist = Integer.valueOf(signBlock.getLine(3));
        }
        if ((items = SignUtils.parseItems((String)signBlock.getLine(2), (String)"-", (boolean)true)).size() >= 1 || items.size() <= 2) {
            ItemID = ((FBBlockType)items.get(0)).getItemID();
            if (((FBBlockType)items.get(0)).getItemData() != -1) {
                ItemData = ((FBBlockType)items.get(0)).getItemData();
            }
            ItemID2 = 0;
            if (items.size() == 2) {
                ItemID2 = ((FBBlockType)items.get(1)).getItemID();
                if (((FBBlockType)items.get(1)).getItemData() != -1) {
                    ItemData2 = ((FBBlockType)items.get(1)).getItemData();
                }
            }
        }
        items.clear();
        items = null;
        if (ItemID < 0 || ItemID2 < 0) {
            return;
        }
        if (!MC1207.isValidBlock(ItemID) || !MC1207.isValidBlock(ItemID2)) {
            return;
        }
        Location newBlockLoc = MC1207.getICBlock(signBlock).getBlock().getRelative(0, dist, 0).getLocation();
        if (MC1207.isPowered(positions.get(0))) {
            newBlockLoc.getBlock().setTypeIdAndData(ItemID, ItemData.byteValue(), true);
            MC1207.switchLever(signBlock, true);
        } else {
            newBlockLoc.getBlock().setTypeIdAndData(ItemID2, ItemData2.byteValue(), true);
            MC1207.switchLever(signBlock, false);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

