/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1285
extends BaseIC {
    public MC1285(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "SET WEATHER";
        this.MCName = "[MC1285]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("SUN or RAIN or STORM", "");
        this.ICDescription = "The MC1285 sets the weather to the specified weather, whenever the input (the \"clock\") goes from low to high.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        String line;
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1285.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            event.setLine(3, "");
            line = event.getLine(2);
            if (!(line.equalsIgnoreCase("sun") || line.equalsIgnoreCase("rain") || line.equalsIgnoreCase("storm"))) {
                MC1285.cancelCreation(event, ChatColor.RED + "Line 3 must be sun, rain or storm");
                return;
            }
        } else {
            MC1285.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(2, line.toUpperCase());
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1285.getBlockPositions(signBlock);
        String line = signBlock.getLine(2);
        if (!(line.equalsIgnoreCase("sun") || line.equalsIgnoreCase("rain") || line.equalsIgnoreCase("storm"))) {
            return;
        }
        if (MC1285.isPowered(positions.get(0))) {
            if (line.equalsIgnoreCase("sun")) {
                signBlock.getWorld().setStorm(false);
                signBlock.getWorld().setThundering(false);
            } else if (line.equalsIgnoreCase("rain")) {
                signBlock.getWorld().setStorm(true);
                signBlock.getWorld().setThundering(false);
            } else if (line.equalsIgnoreCase("storm")) {
                signBlock.getWorld().setStorm(true);
                signBlock.getWorld().setThundering(true);
            }
        }
        MC1285.switchLever(signBlock, MC1285.isPowered(positions.get(0)));
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

