/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1510
extends BaseIC {
    public MC1510(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "MESSAGESENDER";
        this.MCName = "[MC1510]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("Player name OR leave blank to message all players", "The message");
        this.ICDescription = "The MC1510 displays a configurable message when the input (the \"clock\") goes from low to high.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1510.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            if (event.getLine(3).length() < 1) {
                MC1510.cancelCreation(event, "Enter a message in line 4!");
                return;
            }
        } else {
            MC1510.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1510.getBlockPositions(signBlock);
        if (MC1510.isPowered(positions.get(0))) {
            String toName = signBlock.getLine(2);
            String message = signBlock.getLine(3);
            if (message.length() < 1) {
                return;
            }
            if (toName.length() < 1) {
                FalseBookICCore.server.broadcastMessage(ChatColor.LIGHT_PURPLE + "[MC1510 -> all] " + ChatColor.WHITE + message);
            } else {
                Player[] pList;
                Player[] playerArray = pList = FalseBookICCore.server.getOnlinePlayers();
                int n = pList.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    if (player.getName().toLowerCase().contains(toName.toLowerCase())) {
                        player.sendMessage(ChatColor.LIGHT_PURPLE + "[MC1510 -> " + player.getName() + "] " + ChatColor.WHITE + message);
                    }
                    ++n2;
                }
            }
        }
        MC1510.switchLever(signBlock, MC1510.isPowered(positions.get(0)));
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

