/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.StorageCreator;
import com.nijiko.data.UserStorage;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.config.Configuration;

public final class StorageFactory {
    private static final Map<String, StorageCreator> creators = new HashMap<String, StorageCreator>();
    private static StorageCreator defaultCreator;

    private StorageFactory() {
    }

    public static boolean registerCreator(String id, StorageCreator creator) {
        if (creators.containsKey(id.toUpperCase())) {
            return false;
        }
        creators.put(id.toUpperCase(), creator);
        return true;
    }

    public static boolean registerDefaultCreator(StorageCreator creator) {
        if (defaultCreator != null) {
            return false;
        }
        defaultCreator = creator;
        return true;
    }

    public static void unregisterCreator(String id, StorageCreator creator) {
        creators.remove(id.toUpperCase());
        if (defaultCreator == creator) {
            defaultCreator = null;
        }
    }

    public static final UserStorage getUserStorage(String world, Configuration config) throws Exception {
        UserStorage us;
        String userWorld;
        if (world == null) {
            return null;
        }
        if (config == null) {
            return null;
        }
        int reload = 6000;
        boolean autosave = true;
        config.load();
        String parent = config.getString("permissions.storage.worldcopy." + world);
        if (parent != null) {
            world = parent;
        }
        if ((userWorld = config.getString("permissions.storage.user.worldcopy." + world)) == null) {
            userWorld = world;
        }
        parent = null;
        String typename = config.getString("permissions.storage.type");
        String userWorldType = config.getString("permissions.storage.worldtype." + userWorld);
        if (userWorldType == null || userWorldType.isEmpty()) {
            userWorldType = typename;
        }
        reload = config.getInt("permissions.storage.reload", 6000);
        autosave = config.getBoolean("permissions.storage.autosave", true);
        StorageCreator creator = userWorldType == null ? defaultCreator : creators.get(userWorldType.toUpperCase());
        if (creator == null) {
            System.err.println("Error occurred while selecting permissions user config type. Reverting to default creator.");
            creator = defaultCreator;
            if (creator == null) {
                throw new Exception("Error occurred while selecting permissions user config type. Default creator is null.");
            }
        }
        try {
            us = creator.getUserStorage(userWorld, reload, autosave, config);
        }
        catch (Exception e) {
            if (creator == defaultCreator) {
                throw e;
            }
            creator = defaultCreator;
            us = creator.getUserStorage(userWorld, reload, autosave, config);
        }
        return us;
    }

    public static final GroupStorage getGroupStorage(String world, Configuration config) throws Exception {
        GroupStorage gs;
        String groupWorld;
        if (world == null) {
            return null;
        }
        if (config == null) {
            return null;
        }
        int reload = 6000;
        boolean autosave = true;
        config.load();
        String parent = config.getString("permissions.storage.worldcopy." + world);
        if (parent != null) {
            world = parent;
        }
        if ((groupWorld = config.getString("permissions.storage.group.worldcopy." + world)) == null) {
            groupWorld = world;
        }
        parent = null;
        String typename = config.getString("permissions.storage.type");
        String groupWorldType = config.getString("permissions.storage.worldtype." + groupWorld);
        if (groupWorldType == null || groupWorldType.isEmpty()) {
            groupWorldType = typename;
        }
        reload = config.getInt("permissions.storage.reload", 6000);
        autosave = config.getBoolean("permissions.storage.autosave", true);
        StorageCreator creator = groupWorldType == null ? defaultCreator : creators.get(groupWorldType);
        if (creator == null) {
            System.err.println("Error occurred while selecting permissions group config type. Reverting to default creator.");
            creator = defaultCreator;
            if (creator == null) {
                throw new Exception("Error occurred while selecting permissions group config type. Default creator is null.");
            }
        }
        try {
            gs = creator.getGroupStorage(groupWorld, reload, autosave, config);
        }
        catch (Exception e) {
            if (creator == defaultCreator) {
                throw e;
            }
            creator = defaultCreator;
            gs = creator.getGroupStorage(groupWorld, reload, autosave, config);
        }
        return gs;
    }
}

