/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.GroupWorld;
import com.nijiko.permissions.EntryType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.util.config.Configuration;

public class YamlGroupStorage
implements GroupStorage {
    private final Configuration groupConfig;
    private final ReentrantReadWriteLock rwl;
    private boolean modified;
    private final String world;
    private boolean saveOff;

    YamlGroupStorage(Configuration groupConfig, String world, int reloadDelay, boolean autoSave) {
        this.groupConfig = groupConfig;
        this.world = world;
        this.rwl = new ReentrantReadWriteLock(false);
        this.saveOff = !autoSave;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPermissions(String name) {
        List rawPerms;
        this.rwl.readLock().lock();
        try {
            rawPerms = this.groupConfig.getStringList("groups." + name + ".permissions", null);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        HashSet<String> permissions = new HashSet<String>();
        if (rawPerms != null && !rawPerms.isEmpty()) {
            permissions.addAll(rawPerms);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashSet<GroupWorld> getParents(String name) {
        List rawParents = null;
        this.rwl.readLock().lock();
        try {
            rawParents = this.groupConfig.getStringList("groups." + name + ".inheritance", null);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        LinkedHashSet<GroupWorld> parents = new LinkedHashSet<GroupWorld>(rawParents.size());
        for (String raw : rawParents) {
            String[] split = raw.split(",", 2);
            if (split.length == 0) continue;
            if (split.length == 1) {
                parents.add(new GroupWorld(this.world, split[0]));
                continue;
            }
            parents.add(new GroupWorld(split[0], split[1]));
        }
        return parents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermission(String name, String permission) {
        this.rwl.writeLock().lock();
        try {
            HashSet<String> permissions = new HashSet<String>(this.groupConfig.getStringList("groups." + name + ".permissions", null));
            permissions.add(permission);
            this.groupConfig.setProperty("groups." + name + ".permissions", new LinkedList(permissions));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(String name, String permission) {
        this.rwl.writeLock().lock();
        try {
            HashSet permissions = new HashSet(this.groupConfig.getStringList("groups." + name + ".permissions", null));
            permissions.remove(permission);
            this.groupConfig.setProperty("groups." + name + ".permissions", new LinkedList(permissions));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParent(String name, String groupWorld, String groupName) {
        this.rwl.writeLock().lock();
        try {
            LinkedHashSet<String> parents = new LinkedHashSet<String>(this.groupConfig.getStringList("groups." + name + ".inheritance", null));
            if (groupWorld == null || this.world.equalsIgnoreCase(groupWorld)) {
                parents.add(groupName);
            } else {
                parents.add(groupWorld + "," + groupName);
            }
            this.groupConfig.setProperty("groups." + name + ".inheritance", new LinkedList(parents));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParent(String name, String groupWorld, String groupName) {
        this.rwl.writeLock().lock();
        try {
            LinkedHashSet parents = new LinkedHashSet(this.groupConfig.getStringList("groups." + name + ".inheritance", null));
            if (groupWorld == null || this.world.equalsIgnoreCase(groupWorld)) {
                parents.remove(groupName);
            } else {
                parents.remove(groupWorld + "," + groupName);
            }
            this.groupConfig.setProperty("groups." + name + ".inheritance", new LinkedList(parents));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getEntries() {
        this.rwl.readLock().lock();
        List rawGroups = null;
        try {
            rawGroups = this.groupConfig.getKeys("groups");
        }
        finally {
            this.rwl.readLock().unlock();
        }
        LinkedHashSet<String> users = rawGroups == null ? new LinkedHashSet<String>() : new LinkedHashSet(rawGroups);
        return users;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceSave() {
        this.rwl.writeLock().lock();
        try {
            if (this.modified) {
                this.groupConfig.save();
            }
            this.groupConfig.load();
            this.modified = false;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        this.rwl.writeLock().lock();
        try {
            if (!this.saveOff) {
                this.forceSave();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        this.rwl.writeLock().lock();
        try {
            this.groupConfig.load();
            this.modified = false;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoSave() {
        this.rwl.readLock().lock();
        boolean save = true;
        try {
            save = this.saveOff;
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return save;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoSave(boolean autoSave) {
        this.rwl.writeLock().lock();
        try {
            this.saveOff = autoSave;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefault(String name) {
        boolean isDefault = false;
        this.rwl.readLock().lock();
        try {
            isDefault = this.groupConfig.getBoolean("groups." + name + ".default", false);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return isDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String name) {
        boolean created = false;
        this.rwl.writeLock().lock();
        try {
            if (this.groupConfig.getProperty("groups." + name) == null) {
                HashMap<String, Object> template = new HashMap<String, Object>();
                template.put("inheritance", null);
                template.put("permissions", null);
                this.groupConfig.setProperty("groups." + name, template);
                this.modified = true;
                created = true;
                this.save();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String name) {
        boolean exists = false;
        this.rwl.writeLock().lock();
        try {
            exists = this.groupConfig.getProperty("groups." + name) != null;
            this.groupConfig.removeProperty("groups." + name);
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String name, String path, Object data) {
        this.rwl.writeLock().lock();
        try {
            this.groupConfig.setProperty("groups." + name + ".info." + path, data);
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getTracks() {
        List<String> rawTracks = null;
        this.rwl.readLock().lock();
        try {
            rawTracks = this.groupConfig.getKeys("tracks");
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (this.groupConfig.getProperty("track") instanceof List) {
            if (rawTracks == null) {
                rawTracks = Arrays.asList(new String[]{null});
            } else {
                rawTracks.add(null);
            }
        }
        return new HashSet<String>(rawTracks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedList<GroupWorld> getTrack(String trackName) {
        List rawGroups = null;
        this.rwl.readLock().lock();
        try {
            rawGroups = trackName == null ? this.groupConfig.getStringList("track", null) : this.groupConfig.getStringList("tracks." + trackName, null);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (rawGroups == null) {
            return null;
        }
        LinkedHashSet<GroupWorld> track = new LinkedHashSet<GroupWorld>(rawGroups.size());
        for (String raw : rawGroups) {
            String[] split = raw.split(",", 2);
            if (split.length == 0) continue;
            if (split.length == 1) {
                track.add(new GroupWorld(this.world, split[0]));
                continue;
            }
            track.add(new GroupWorld(split[0], split[1]));
        }
        return new LinkedList<GroupWorld>(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(String name, String path) {
        this.rwl.writeLock().lock();
        try {
            this.groupConfig.removeProperty("groups." + name + ".info." + path);
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public String getString(String name, String path) {
        Object raw = this.getObj(name, path);
        if (raw instanceof String) {
            return (String)raw;
        }
        if (raw == null) {
            return null;
        }
        return raw.toString();
    }

    @Override
    public Integer getInt(String name, String path) {
        int val;
        Object raw = this.getObj(name, path);
        if (raw instanceof Integer) {
            return (Integer)raw;
        }
        if (raw == null) {
            return null;
        }
        try {
            val = Integer.valueOf(raw.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    @Override
    public Double getDouble(String name, String path) {
        double val;
        Object raw = this.getObj(name, path);
        if (raw instanceof Double) {
            return (Double)raw;
        }
        if (raw == null) {
            return null;
        }
        try {
            val = Double.valueOf(raw.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    @Override
    public Boolean getBool(String name, String path) {
        Object raw = this.getObj(name, path);
        if (raw instanceof Boolean) {
            return (Boolean)raw;
        }
        if (raw == null) {
            return null;
        }
        boolean val = Boolean.valueOf(raw.toString());
        return val;
    }

    private Object getObj(String name, String path) {
        this.rwl.readLock().lock();
        Object data = this.groupConfig.getProperty("groups." + name + ".info." + path);
        this.rwl.readLock().unlock();
        return data;
    }

    @Override
    public EntryType getType() {
        return EntryType.GROUP;
    }
}

