/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.permissions.CheckResult;
import com.nijiko.permissions.Entry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PermissionCache {
    private Map<Entry, Set<CheckResult>> permCache = new HashMap<Entry, Set<CheckResult>>();
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheResult(CheckResult result) {
        if (result == null) {
            return;
        }
        this.rwl.readLock().lock();
        try {
            if (this.permCache.get(result.getChecked()) == null) {
                this.permCache.put(result.getChecked(), new HashSet());
            }
            this.permCache.get(result.getChecked()).add(result);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        this.rwl.writeLock().lock();
        try {
            for (Set<CheckResult> val : this.permCache.values()) {
                for (CheckResult cr : val) {
                    cr.invalidate();
                }
            }
            this.permCache.clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePerms(Entry entry, String node) {
        if (entry == null) {
            return;
        }
        if (node == null) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            if (node.equals("*") || node.equals("-*")) {
                for (Map.Entry<Entry, Set<CheckResult>> mapEntry : this.permCache.entrySet()) {
                    if (!mapEntry.getKey().isChildOf(entry)) continue;
                    Iterator<CheckResult> iter = mapEntry.getValue().iterator();
                    while (iter.hasNext()) {
                        iter.next().invalidate();
                        iter.remove();
                    }
                }
            } else {
                LinkedHashSet<String> relevant = Entry.relevantPerms(node);
                String wild = node.endsWith(".*") ? node.substring(0, node.length() - 2) : null;
                for (Map.Entry<Entry, Set<CheckResult>> mapEntry : this.permCache.entrySet()) {
                    if (!mapEntry.getKey().isChildOf(entry)) continue;
                    Iterator<CheckResult> iter = mapEntry.getValue().iterator();
                    while (iter.hasNext()) {
                        CheckResult cached = iter.next();
                        String testNode = cached.getNode();
                        if (!relevant.contains(testNode) && (wild == null || !testNode.startsWith(wild) && !Entry.negationOf(testNode).startsWith(wild))) continue;
                        cached.invalidate();
                        iter.remove();
                    }
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateParent(Entry child, Entry parent) {
        if (child == null || parent == null) {
            return;
        }
        Set<String> perms = parent.getAllPermissions();
        this.rwl.writeLock().lock();
        try {
            for (String perm : perms) {
                this.updatePerms(child, perm);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadWorld(String world) {
        if (world == null) {
            this.flushAll();
            return;
        }
        this.rwl.writeLock().lock();
        try {
            Iterator<Map.Entry<Entry, Set<CheckResult>>> iter = this.permCache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Entry, Set<CheckResult>> mapEntry = iter.next();
                if (!mapEntry.getKey().getWorld().equals(world)) continue;
                for (CheckResult cr : mapEntry.getValue()) {
                    cr.invalidate();
                }
                iter.remove();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }
}

