/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.GroupWorld;
import com.nijiko.data.Storage;
import com.nijiko.data.UserStorage;
import com.nijiko.permissions.Entry;
import com.nijiko.permissions.EntryType;
import com.nijiko.permissions.Group;
import com.nijiko.permissions.ModularControl;
import com.nijiko.permissions.PermissionWorld;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class User
extends Entry {
    private UserStorage data;

    User(ModularControl controller, UserStorage data, String name, PermissionWorld worldObj, boolean create) {
        super(controller, name, worldObj);
        Group g;
        this.data = data;
        if (create && !this.world.equals("?")) {
            System.out.println("Creating user " + name);
            data.create(name);
        }
        if (this.addDefault() && (g = worldObj.getDefaultGroup()) != null) {
            if (this.world.equals("*")) {
                Group qDef = controller.getGrp("?", g.name);
                if (qDef != null) {
                    this.addParent(qDef);
                }
            } else {
                this.addParent(g);
            }
        }
    }

    private boolean addDefault() {
        if (this.getRawParents().isEmpty()) {
            User u = this.controller.getUserObject("*", this.name);
            if (u != null) {
                LinkedHashSet<GroupWorld> gwSet = u.getRawParents();
                for (GroupWorld gw : gwSet) {
                    if (!gw.getWorld().equals("?")) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public EntryType getType() {
        return EntryType.USER;
    }

    @Override
    public String toString() {
        return "User " + this.name + " in " + this.world;
    }

    public Group getPrimaryGroup() {
        LinkedHashSet<Entry> parents = this.getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        for (Entry e : parents) {
            LinkedHashSet<Entry> grandparents;
            User p;
            if (e instanceof Group) {
                return (Group)e;
            }
            if (!(e instanceof User) || !(p = (User)e).getWorld().equals("*") || this.world.equals("*") || (grandparents = p.getParents(this.world)) == null || grandparents.isEmpty()) continue;
            for (Entry pe : grandparents) {
                if (!(pe instanceof Group)) continue;
                return (Group)pe;
            }
        }
        return null;
    }

    public boolean demote(Group g, String track) {
        if (g == null) {
            return false;
        }
        if (!this.getParents(null).contains(g)) {
            return false;
        }
        GroupStorage gStore = this.worldObj.getGroupStorage();
        if (gStore == null) {
            return false;
        }
        LinkedList<GroupWorld> trackGroups = gStore.getTrack(track);
        if (trackGroups == null) {
            return false;
        }
        GroupWorld groupW = g.toGroupWorld();
        ListIterator<GroupWorld> iter = trackGroups.listIterator(trackGroups.size());
        while (iter.hasPrevious()) {
            GroupWorld gw = iter.previous();
            if (!gw.equals(groupW)) continue;
            this.removeParent(g);
            if (iter.hasPrevious()) {
                GroupWorld prev = iter.previous();
                this.addParent(this.controller.getGrp(prev.getWorld(), prev.getName()));
            }
            return true;
        }
        return false;
    }

    public boolean promote(Group g, String track) {
        if (!this.getParents(null).contains(g)) {
            return false;
        }
        GroupStorage gStore = this.worldObj.getGroupStorage();
        if (gStore == null) {
            return false;
        }
        LinkedList<GroupWorld> trackGroups = gStore.getTrack(track);
        if (trackGroups == null) {
            return false;
        }
        if (g == null) {
            GroupWorld gw;
            ListIterator iter = trackGroups.listIterator();
            if (iter.hasNext() && (gw = (GroupWorld)iter.next()) != null) {
                this.addParent(this.controller.getGrp(gw.getWorld(), gw.getName()));
            }
            return false;
        }
        GroupWorld groupW = g.toGroupWorld();
        ListIterator iter = trackGroups.listIterator();
        while (iter.hasNext()) {
            GroupWorld gw = (GroupWorld)iter.next();
            if (!gw.equals(groupW) || !iter.hasNext()) continue;
            GroupWorld next = (GroupWorld)iter.next();
            this.removeParent(g);
            this.addParent(this.controller.getGrp(next.getWorld(), next.getName()));
            return true;
        }
        return false;
    }

    @Override
    protected Storage getStorage() {
        return this.data;
    }

    @Override
    public boolean delete() {
        this.worldObj.delUsr(this.name);
        return super.delete();
    }
}

