/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.BackupUnit;
import com.mysticx.bukkit.backupplugin.CacheControl;
import com.mysticx.bukkit.backupplugin.Configuration;
import com.mysticx.bukkit.backupplugin.MapperUnit;
import com.mysticx.bukkit.backupplugin.MessageHandler;
import com.mysticx.bukkit.backupplugin.PluginUnit;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public final class BackupPlugin
extends JavaPlugin
implements Observer {
    private final Map<Player, Boolean> debugees = new HashMap<Player, Boolean>();
    private TimeUnit timeunit = TimeUnit.MINUTES;
    private CacheControl cc;
    private BackupUnit bu;
    private MapperUnit mu;
    private Permissions permissions = null;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private List<String> authorizedUsers = new ArrayList<String>();

    public void onEnable() {
        MessageHandler.setServer(this.getServer());
        PluginDescriptionFile pdfFile = this.getDescription();
        MessageHandler.info(pdfFile.getName() + " version " + pdfFile.getVersion() + " is enabled!");
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Permissions");
        if (plugin == null) {
            MessageHandler.log(Level.INFO, "No group users plugin found, falling back to own config!");
        } else {
            this.permissions = (Permissions)plugin;
            MessageHandler.log(Level.INFO, "Permissions plugin found, using Permission config");
        }
        this.load();
    }

    protected boolean load() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        Configuration config = new Configuration(this.getDataFolder(), "config.properties");
        config.load();
        String separator = System.getProperty("file.separator");
        String world = config.getString("level-name", "world");
        String backupFolder = config.getString("backup-path", "world-backups");
        String mapperPath = config.getString("mapper-executable", "mcmap" + separator + "mcmap.exe");
        String mapFolder = config.getString("map-path", "world-maps");
        String mapOptions = config.getString("map-options", "-png -file $o $w;-night -png -file $o $w");
        int autobackupPeriod = config.getInt("autobackup-period", 0);
        int automapPeriod = config.getInt("automap-period", 0);
        int cacheLifetime = config.getInt("cache-lifetime", 30);
        String tempdir = config.getString("temp-path", backupFolder + "/temp");
        String loglevel = config.getString("log-level", "INFO");
        String timeUnit = config.getString("time-unit", "MINUTES");
        int numBackups = config.getInt("backup-history", 5);
        boolean useLatest = config.getBoolean("use-latest", false);
        String firstRun = config.getString("first-run", "1200");
        String admins = config.getString("authorized-users", "");
        MessageHandler.setLogLevel(loglevel);
        this.authorizedUsers = new ArrayList<String>();
        String[] access = admins.split(";");
        StringBuilder logInfo = new StringBuilder();
        for (String name : access) {
            if (name.isEmpty()) continue;
            this.authorizedUsers.add(name.toLowerCase());
            logInfo.append(name).append(", ");
        }
        MessageHandler.log(Level.FINE, String.format("There are %d user(s) in the authorized-users list: %s", this.authorizedUsers.size(), logInfo));
        try {
            TimeUnit tu;
            this.timeunit = tu = TimeUnit.valueOf(timeUnit);
        }
        catch (Exception e) {
            MessageHandler.warning("Failed to parse time-unit, using default.");
        }
        this.cc = CacheControl.getInstance();
        this.cc.setWorld(world);
        this.cc.setTimeUnit(this.timeunit);
        this.cc.setCacheLifetime(cacheLifetime);
        this.cc.setTempDir(new File(tempdir));
        this.cc.setCacheHistory(numBackups);
        this.bu = new BackupUnit(this.getServer(), new File(backupFolder), true);
        this.bu.addObserver(this);
        this.mu = new MapperUnit(this.getServer(), new File(mapFolder), false);
        this.mu.setMapperPath(new File(mapperPath));
        this.mu.setUseLatest(useLatest);
        this.mu.addObserver(this);
        String[] parameters = mapOptions.split(";");
        this.mu.setMapOptions(parameters);
        this.scheduler.shutdownNow();
        this.scheduler = Executors.newScheduledThreadPool(2);
        long backupDelay = -1L;
        long mapDelay = -1L;
        try {
            long timeToExecuteB = this.calcNextPointOfTime(firstRun, "HHmm", TimeUnit.MILLISECONDS.convert(autobackupPeriod, this.timeunit));
            backupDelay = timeToExecuteB - System.currentTimeMillis();
            long timeToExecuteM = this.calcNextPointOfTime(firstRun, "HHmm", TimeUnit.MILLISECONDS.convert(automapPeriod, this.timeunit));
            mapDelay = timeToExecuteM - System.currentTimeMillis();
        }
        catch (ParseException pe) {
            MessageHandler.log(Level.WARNING, "Failed to parse firstRun, disabled automatic execution", pe);
        }
        if (backupDelay >= 0L && autobackupPeriod > 0) {
            this.setupTimer(this.bu, backupDelay, autobackupPeriod, this.timeunit);
        }
        if (mapDelay >= 0L && automapPeriod > 0) {
            this.setupTimer(this.mu, mapDelay, automapPeriod, this.timeunit);
        }
        return true;
    }

    public void onDisable() {
        MessageHandler.log(Level.INFO, "BackupPlugin disabled!");
    }

    public boolean isDebugging(Player player) {
        if (this.debugees.containsKey(player)) {
            return this.debugees.get(player);
        }
        return false;
    }

    public void setDebugging(Player player, boolean value) {
        this.debugees.put(player, value);
    }

    private long calcNextPointOfTime(String time, String pattern, long period) throws ParseException {
        if (period <= 0L) {
            return 0L;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setLenient(true);
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar calendarBis = Calendar.getInstance();
        calendarBis.setTime(df.parse(time));
        calendar.set(11, calendarBis.get(11));
        calendar.set(12, calendarBis.get(12));
        MessageHandler.log(Level.FINEST, "firstRun : " + calendar.getTime().toString());
        long nextRun = calendar.getTimeInMillis();
        int addPeriod = 0;
        while (nextRun < System.currentTimeMillis()) {
            nextRun += period;
            ++addPeriod;
        }
        if (addPeriod > 0) {
            MessageHandler.log(Level.FINEST, "(" + addPeriod + " times) Date is in the past, adding some minutes: " + period / 1000L / 60L);
        }
        return nextRun;
    }

    private boolean setupTimer(Runnable r, long delay, Integer period, TimeUnit tu) {
        this.scheduler.scheduleAtFixedRate(r, tu.convert(delay, TimeUnit.MILLISECONDS), period.intValue(), tu);
        MessageHandler.info("Finished setting up a thread: " + r.getClass().getSimpleName() + " Next run in: " + TimeUnit.MINUTES.convert(delay, TimeUnit.MILLISECONDS) + " minutes.");
        return true;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof PluginUnit) {
            PluginUnit pu = (PluginUnit)arg0;
            pu.resetForce();
        }
    }

    protected void performBackup(boolean force) {
        this.bu.setForce(force);
        this.scheduler.execute(this.bu);
    }

    protected void performMapping(boolean force) {
        this.mu.setForce(force);
        this.scheduler.execute(this.mu);
    }

    protected boolean isAuthorized(String userName) {
        return this.authorizedUsers.contains(userName.toLowerCase());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String commandName = cmd.getName().toLowerCase();
        String name = sender instanceof Player ? ((Player)sender).getName() : "An Administrator";
        if ("backup".equals(commandName) && this.canUseCommand(sender, "BackupPlugin.backup")) {
            return this.backup(args, name);
        }
        if ("map".equals(commandName) && this.canUseCommand(sender, "BackupPlugin.map")) {
            return this.map(args, name);
        }
        if ("breload".equals(commandName) && this.canUseCommand(sender, "BackupPlugin.admin")) {
            return this.reload(name);
        }
        if ("loglevel".equals(commandName) && this.canUseCommand(sender, "BackupPlugin.admin")) {
            return this.loglevel(args, name, sender);
        }
        return true;
    }

    private boolean loglevel(String[] args, String name, CommandSender sender) {
        if (args.length == 1) {
            MessageHandler.info(name + " is changing log level to " + args[0]);
            String message = MessageHandler.setLogLevel(args[0]) ? "Done!" : "Failed!";
            if (sender instanceof Player) {
                ((Player)sender).sendMessage(message);
            } else {
                MessageHandler.info(message);
            }
            return true;
        }
        return false;
    }

    private boolean reload(String name) {
        String broadcast = name + " triggered config reload.";
        MessageHandler.info(broadcast);
        MessageHandler.broadcast(broadcast);
        this.load();
        return true;
    }

    private boolean map(String[] args, String name) {
        if (args.length > 1) {
            return false;
        }
        boolean force = false;
        if (args.length == 1) {
            force = Boolean.valueOf(args[0]);
        }
        String broadcast = name + " triggered world mapping.";
        MessageHandler.info(broadcast + " force = " + force);
        MessageHandler.broadcast(broadcast);
        this.performMapping(force);
        return true;
    }

    private boolean backup(String[] args, String name) {
        if (args.length > 1) {
            return false;
        }
        boolean force = false;
        if (args.length == 1) {
            force = Boolean.valueOf(args[0]);
        }
        String broadcast = name + " triggered world backup.";
        MessageHandler.info(broadcast + " force = " + force);
        MessageHandler.broadcast(broadcast);
        this.performBackup(force);
        return true;
    }

    private boolean canUseCommand(CommandSender sender, String permission) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.permissions != null) {
                return this.permissions.getHandler().permission(player, permission);
            }
            return this.isAuthorized(player.getName());
        }
        return true;
    }
}

