/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.MessageHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

public final class Configuration {
    private Properties properties = new Properties();
    private File file;

    public Configuration(File dataFolder, String name) {
        this.file = new File(dataFolder, name);
        if (this.file.exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            FileInputStream inStream = new FileInputStream(this.file);
            try {
                this.properties.load(inStream);
            }
            catch (IOException ioex) {
                MessageHandler.log(Level.SEVERE, "Can't load config!", ioex);
            }
            finally {
                inStream.close();
            }
        }
        catch (IOException ioex) {
            MessageHandler.log(Level.SEVERE, "Can't load config!", ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                this.properties.store(out, "BackupPlugin Config File");
            }
            catch (IOException ioex) {
                MessageHandler.log(Level.SEVERE, "Can't save config!", ioex);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioex) {
            MessageHandler.log(Level.SEVERE, "Can't save config!", ioex);
        }
    }

    public void removeKey(String key) {
        this.properties.remove(key);
        this.save();
    }

    public boolean keyExists(String key) {
        return this.properties.containsKey(key);
    }

    public String getString(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return "";
    }

    public String getString(String key, String value) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        this.setString(key, value);
        return value;
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
        this.save();
    }

    public int getInt(String key) {
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        return 0;
    }

    public int getInt(String key, int value) {
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        this.setInt(key, value);
        return value;
    }

    public void setInt(String key, int value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }

    public double getDouble(String key) {
        if (this.properties.containsKey(key)) {
            return Double.parseDouble(this.properties.getProperty(key));
        }
        return 0.0;
    }

    public double getDouble(String key, double value) {
        if (this.properties.containsKey(key)) {
            return Double.parseDouble(this.properties.getProperty(key));
        }
        this.setDouble(key, value);
        return value;
    }

    public void setDouble(String key, double value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }

    public long getLong(String key) {
        if (this.properties.containsKey(key)) {
            return Long.parseLong(this.properties.getProperty(key));
        }
        return 0L;
    }

    public long getLong(String key, long value) {
        if (this.properties.containsKey(key)) {
            return Long.parseLong(this.properties.getProperty(key));
        }
        this.setLong(key, value);
        return value;
    }

    public void setLong(String key, long value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }

    public boolean getBoolean(String key) {
        if (this.properties.containsKey(key)) {
            return Boolean.parseBoolean(this.properties.getProperty(key));
        }
        return false;
    }

    public boolean getBoolean(String key, boolean value) {
        if (this.properties.containsKey(key)) {
            return Boolean.parseBoolean(this.properties.getProperty(key));
        }
        this.setBoolean(key, value);
        return value;
    }

    public void setBoolean(String key, boolean value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }
}

