/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.MessageHandler;
import com.mysticx.bukkit.backupplugin.PluginUnit;
import com.mysticx.bukkit.backupplugin.SysCommandExecutor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.World;

public final class MapperUnit
extends PluginUnit {
    private File mapperPath;
    private String[] mapOptions;
    private boolean useLatest;

    public MapperUnit(Server instance, File workdir) {
        super(instance, workdir);
        this.name = "MapperUnit";
    }

    public MapperUnit(Server instance, File workdir, boolean force) {
        super(instance, workdir, force);
        this.name = "MapperUnit";
    }

    public void setMapperPath(File mapperTool) {
        this.mapperPath = mapperTool;
        if (this.mapperPath == null || !this.mapperPath.exists()) {
            this.setEnabled(false);
            MessageHandler.warning("Disabled MapperUnit, mapper_path invalid: " + this.mapperPath);
        }
    }

    public void setMapOptions(String[] mapOptions) {
        this.mapOptions = Arrays.copyOf(mapOptions, mapOptions.length);
    }

    public void setUseLatest(boolean useLatest) {
        this.useLatest = useLatest;
    }

    @Override
    public void run() {
        while (!this.isEnabled) {
            MessageHandler.log(Level.WARNING, " is disabled. Thread goes to sleep.");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                MessageHandler.log(Level.WARNING, "woke up from sleep unexpectedly!", e);
            }
        }
        MessageHandler.log(Level.INFO, "Starting map generation process.. this could take a while!");
        this.server.savePlayers();
        String worldname = this.cc.getWorld().getName();
        World world = this.server.getWorld(worldname);
        if (world == null) {
            MessageHandler.warning(String.format("World %s don't exist", worldname));
        } else {
            world.save();
            File inputFolder = null;
            try {
                inputFolder = this.cc.getCache(this.isForce());
            }
            catch (Exception e) {
                MessageHandler.log(Level.SEVERE, "An error ocurred during mapping", e);
                return;
            }
            if (!this.getWorkDir().exists()) {
                this.getWorkDir().mkdirs();
            }
            this.cc.getLock().lock();
            MessageHandler.log(Level.FINEST, "got lock, starting map generation");
            for (int i = 0; i < this.mapOptions.length; ++i) {
                MessageHandler.info("Mapping pass " + (i + 1) + " of " + this.mapOptions.length + "...");
                String filename = this.generateFilename(".png");
                String mapParameters = this.mapOptions[i];
                mapParameters = mapParameters.replace("$o", new File(this.getWorkDir(), filename).getAbsolutePath());
                mapParameters = mapParameters.replace("$w", inputFolder.getAbsolutePath());
                if (mapParameters.contains("$m")) {
                    mapParameters = mapParameters.replace("$m", this.mapperPath.getParent());
                }
                MessageHandler.log(Level.FINE, "Mapper usage: " + this.mapperPath + " " + mapParameters);
                this.executeExternal(this.mapperPath, mapParameters);
                if (i != 0 || !this.useLatest) continue;
                try {
                    this.iohelper.deleteFile(new File(this.getWorkDir(), "latest.png"));
                    this.iohelper.copyFile(new File(this.getWorkDir(), filename), new File(this.getWorkDir(), "latest.png"), false);
                    continue;
                }
                catch (IOException e) {
                    MessageHandler.log(Level.WARNING, "Creating latest.png failed: ", e);
                }
            }
            MessageHandler.info("Mapping process finished.");
            this.cc.getLock().unlock();
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void executeExternal(File program, String arguments) {
        try {
            long start = System.currentTimeMillis();
            SysCommandExecutor cmdExecutor = new SysCommandExecutor();
            int exitStatus = cmdExecutor.runCommand(program + " " + arguments);
            if (exitStatus != 0) {
                MessageHandler.warning("Mapping failed, something went wrong while executing external code! Exit Status: " + exitStatus);
            } else {
                MessageHandler.info("Mapping successful! Executing mapper took " + this.calculateTimeDifference(start, System.currentTimeMillis()) + " seconds.");
            }
        }
        catch (Exception e) {
            MessageHandler.log(Level.SEVERE, "Error while executing external code!", e);
        }
    }
}

