/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.AsyncStreamReader;
import com.mysticx.bukkit.backupplugin.EnvironmentVar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SysCommandExecutor {
    private String fWorkingDirectory = null;
    private List<EnvironmentVar> fEnvironmentVarList = null;
    private StringBuffer fCmdOutput = null;
    private StringBuffer fCmdError = null;
    private AsyncStreamReader fCmdOutputThread = null;
    private AsyncStreamReader fCmdErrorThread = null;

    public void setWorkingDirectory(String workingDirectory) {
        this.fWorkingDirectory = workingDirectory;
    }

    public void setEnvironmentVar(String name, String value) {
        if (this.fEnvironmentVarList == null) {
            this.fEnvironmentVarList = new ArrayList<EnvironmentVar>();
        }
        this.fEnvironmentVarList.add(new EnvironmentVar(name, value));
    }

    public String getCommandOutput() {
        return this.fCmdOutput.toString();
    }

    public String getCommandError() {
        return this.fCmdError.toString();
    }

    public int runCommand(String commandLine) throws Exception {
        Process process = this.runCommandHelper(commandLine);
        this.startOutputAndErrorReadThreads(process.getInputStream(), process.getErrorStream());
        int exitStatus = -1;
        try {
            exitStatus = process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new Exception(ex);
        }
        finally {
            this.notifyOutputAndErrorReadThreadsToStopReading();
        }
        return exitStatus;
    }

    private Process runCommandHelper(String commandLine) throws IOException {
        Process process = null;
        process = this.fWorkingDirectory == null ? Runtime.getRuntime().exec(commandLine, this.getEnvTokens()) : Runtime.getRuntime().exec(commandLine, this.getEnvTokens(), new File(this.fWorkingDirectory));
        return process;
    }

    private void startOutputAndErrorReadThreads(InputStream processOut, InputStream processErr) {
        this.fCmdOutput = new StringBuffer();
        this.fCmdOutputThread = new AsyncStreamReader(processOut, this.fCmdOutput, "OUTPUT");
        this.fCmdOutputThread.start();
        this.fCmdError = new StringBuffer();
        this.fCmdErrorThread = new AsyncStreamReader(processErr, this.fCmdError, "ERROR");
        this.fCmdErrorThread.start();
    }

    private void notifyOutputAndErrorReadThreadsToStopReading() {
        this.fCmdOutputThread.stopReading();
        this.fCmdErrorThread.stopReading();
    }

    private String[] getEnvTokens() {
        if (this.fEnvironmentVarList == null) {
            return new String[0];
        }
        String[] envTokenArray = new String[this.fEnvironmentVarList.size()];
        Iterator<EnvironmentVar> envVarIter = this.fEnvironmentVarList.iterator();
        int nEnvVarIndex = 0;
        while (envVarIter.hasNext()) {
            EnvironmentVar envVar = envVarIter.next();
            String envVarToken = envVar.getfName() + "=" + envVar.getfValue();
            envTokenArray[nEnvVarIndex++] = envVarToken;
        }
        return envTokenArray;
    }
}

