/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50;

import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcPermissions;
import com.gmail.nossr50.party.Party;
import com.gmail.nossr50.skills.Acrobatics;
import com.gmail.nossr50.skills.Archery;
import com.gmail.nossr50.skills.Axes;
import com.gmail.nossr50.skills.Skills;
import com.gmail.nossr50.skills.Swords;
import com.gmail.nossr50.skills.Taming;
import com.gmail.nossr50.skills.Unarmed;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageByProjectileEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class Combat {
    public static void combatChecks(EntityDamageEvent event, mcMMO pluginx) {
        Wolf theWolf;
        Wolf theWolf2;
        EntityDamageByEntityEvent eventb;
        if (event.isCancelled() || event.getDamage() == 0) {
            return;
        }
        if (event instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
            eventb = (EntityDamageByEntityEvent)event;
            Player attacker = (Player)((EntityDamageByEntityEvent)event).getDamager();
            PlayerProfile PPa = Users.getProfile(attacker);
            if (mcPermissions.getInstance().unarmed(attacker) && attacker.getItemInHand().getTypeId() == 0) {
                Unarmed.unarmedBonus(attacker, eventb);
            }
            if (m.isAxes(attacker.getItemInHand()) && mcPermissions.getInstance().axes(attacker) && PPa.getSkillLevel(SkillType.AXES) >= 500) {
                event.setDamage(event.getDamage() + 4);
            }
            Combat.combatAbilityChecks(attacker, PPa, (Plugin)pluginx);
            if (!(event instanceof EntityDamageByProjectileEvent)) {
                Player defender;
                if (mcPermissions.getInstance().axes(attacker)) {
                    Axes.axeCriticalCheck(attacker, eventb, (Plugin)pluginx);
                }
                if (!pluginx.misc.bleedTracker.contains((LivingEntity)event.getEntity())) {
                    Swords.bleedCheck(attacker, (LivingEntity)event.getEntity(), pluginx);
                }
                if (event.getEntity() instanceof Player && mcPermissions.getInstance().unarmed(attacker)) {
                    defender = (Player)event.getEntity();
                    Unarmed.disarmProcCheck(attacker, defender);
                }
                if (PPa.getBerserkMode()) {
                    event.setDamage(event.getDamage() + event.getDamage() / 2);
                }
                if (PPa.getSkullSplitterMode() && m.isAxes(attacker.getItemInHand())) {
                    Axes.applyAoeDamage(attacker, eventb, (Plugin)pluginx);
                }
                if (PPa.getSerratedStrikesMode() && m.isSwords(attacker.getItemInHand())) {
                    Swords.applySerratedStrikes(attacker, eventb, pluginx);
                }
                if (event.getEntity() instanceof Player) {
                    defender = (Player)event.getEntity();
                    PlayerProfile PPd = Users.getProfile(defender);
                    if (attacker != null && defender != null && LoadProperties.pvpxp.booleanValue() && System.currentTimeMillis() >= PPd.getRespawnATS() + 5000L && (long)((PPd.getLastLogin() + 5) * 1000) < System.currentTimeMillis() && defender.getHealth() >= 1) {
                        if (m.isAxes(attacker.getItemInHand()) && mcPermissions.getInstance().axes(attacker)) {
                            PPa.addXP(SkillType.AXES, event.getDamage() * 2 * LoadProperties.pvpxprewardmodifier);
                        }
                        if (m.isSwords(attacker.getItemInHand()) && mcPermissions.getInstance().swords(attacker)) {
                            PPa.addXP(SkillType.SWORDS, event.getDamage() * 2 * LoadProperties.pvpxprewardmodifier);
                        }
                        if (attacker.getItemInHand().getTypeId() == 0 && mcPermissions.getInstance().unarmed(attacker)) {
                            PPa.addXP(SkillType.UNARMED, event.getDamage() * 2 * LoadProperties.pvpxprewardmodifier);
                        }
                    }
                }
                if (event.getEntity() instanceof Monster && !pluginx.misc.mobSpawnerList.contains(event.getEntity())) {
                    int xp = 0;
                    if (event.getEntity() instanceof Creeper) {
                        xp = event.getDamage() * 4 * LoadProperties.xpGainMultiplier;
                    }
                    if (event.getEntity() instanceof Spider) {
                        xp = event.getDamage() * 3 * LoadProperties.xpGainMultiplier;
                    }
                    if (event.getEntity() instanceof Skeleton) {
                        xp = event.getDamage() * 2 * LoadProperties.xpGainMultiplier;
                    }
                    if (event.getEntity() instanceof Zombie) {
                        xp = event.getDamage() * 2 * LoadProperties.xpGainMultiplier;
                    }
                    if (event.getEntity() instanceof PigZombie) {
                        xp = event.getDamage() * 3 * LoadProperties.xpGainMultiplier;
                    }
                    if (event.getEntity() instanceof Slime) {
                        xp = event.getDamage() * 3 * LoadProperties.xpGainMultiplier;
                    }
                    if (event.getEntity() instanceof Ghast) {
                        xp = event.getDamage() * 3 * LoadProperties.xpGainMultiplier;
                    }
                    if (m.isSwords(attacker.getItemInHand()) && mcPermissions.getInstance().swords(attacker)) {
                        PPa.addXP(SkillType.SWORDS, xp);
                    } else if (m.isAxes(attacker.getItemInHand()) && mcPermissions.getInstance().axes(attacker)) {
                        PPa.addXP(SkillType.AXES, xp);
                    } else if (attacker.getItemInHand().getTypeId() == 0 && mcPermissions.getInstance().unarmed(attacker)) {
                        PPa.addXP(SkillType.UNARMED, xp);
                    }
                }
                Skills.XpCheckAll(attacker);
                if (event.getEntity() instanceof Wolf) {
                    Wolf theWolf3 = (Wolf)event.getEntity();
                    if (attacker.getItemInHand().getTypeId() == 352 && mcPermissions.getInstance().taming(attacker)) {
                        event.setCancelled(true);
                        if (theWolf3.isTamed()) {
                            attacker.sendMessage(String.valueOf(mcLocale.getString("Combat.BeastLore")) + " " + mcLocale.getString("Combat.BeastLoreOwner", new Object[]{Taming.getOwnerName(theWolf3)}) + " " + mcLocale.getString("Combat.BeastLoreHealthWolfTamed", new Object[]{theWolf3.getHealth()}));
                        } else {
                            attacker.sendMessage(String.valueOf(mcLocale.getString("Combat.BeastLore")) + " " + mcLocale.getString("Combat.BeastLoreHealthWolf", new Object[]{theWolf3.getHealth()}));
                        }
                    }
                }
            }
        }
        if (event instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)event).getDamager() instanceof Wolf && (theWolf2 = (Wolf)(eventb = (EntityDamageByEntityEvent)event).getDamager()).isTamed() && Taming.ownerOnline(theWolf2, (Plugin)pluginx)) {
            if (Taming.getOwner((Entity)theWolf2, (Plugin)pluginx) == null) {
                return;
            }
            Player master = Taming.getOwner((Entity)theWolf2, (Plugin)pluginx);
            PlayerProfile PPo = Users.getProfile(master);
            if (mcPermissions.getInstance().taming(master)) {
                if (PPo.getSkillLevel(SkillType.TAMING) >= 750) {
                    event.setDamage(event.getDamage() + 2);
                }
                if (Math.random() * 1000.0 <= (double)PPo.getSkillLevel(SkillType.TAMING).intValue()) {
                    event.setDamage(event.getDamage() * 2);
                    if (event.getEntity() instanceof Player) {
                        Player target = (Player)event.getEntity();
                        target.sendMessage(mcLocale.getString("Combat.StruckByGore"));
                        Users.getProfile(target).setBleedTicks(2);
                    } else {
                        pluginx.misc.addToBleedQue((LivingEntity)event.getEntity());
                    }
                    master.sendMessage(mcLocale.getString("Combat.Gore"));
                }
                if (!event.getEntity().isDead() && !pluginx.misc.mobSpawnerList.contains(event.getEntity())) {
                    int xp = 0;
                    if (event.getEntity() instanceof Monster) {
                        if (event.getEntity() instanceof Creeper) {
                            xp = event.getDamage() * 6 * LoadProperties.xpGainMultiplier;
                        }
                        if (event.getEntity() instanceof Spider) {
                            xp = event.getDamage() * 5 * LoadProperties.xpGainMultiplier;
                        }
                        if (event.getEntity() instanceof Skeleton) {
                            xp = event.getDamage() * 3 * LoadProperties.xpGainMultiplier;
                        }
                        if (event.getEntity() instanceof Zombie) {
                            xp = event.getDamage() * 3 * LoadProperties.xpGainMultiplier;
                        }
                        if (event.getEntity() instanceof PigZombie) {
                            xp = event.getDamage() * 4 * LoadProperties.xpGainMultiplier;
                        }
                        if (event.getEntity() instanceof Slime) {
                            xp = event.getDamage() * 4 * LoadProperties.xpGainMultiplier;
                        }
                        if (event.getEntity() instanceof Ghast) {
                            xp = event.getDamage() * 4 * LoadProperties.xpGainMultiplier;
                        }
                        Users.getProfile(master).addXP(SkillType.TAMING, xp);
                    }
                    if (event.getEntity() instanceof Player) {
                        xp = event.getDamage() * 2 * LoadProperties.xpGainMultiplier;
                        Users.getProfile(master).addXP(SkillType.TAMING, xp);
                    }
                    Skills.XpCheckSkill(SkillType.TAMING, master);
                }
            }
        }
        if (event instanceof EntityDamageByProjectileEvent) {
            Combat.archeryCheck((EntityDamageByProjectileEvent)event, pluginx);
        }
        if (event instanceof EntityDamageByEntityEvent && event.getEntity() instanceof Player) {
            Player defender = (Player)event.getEntity();
            Swords.parryCheck((EntityDamageByEntityEvent)event, defender);
            Swords.counterAttackChecks(event);
            Acrobatics.dodgeChecks((EntityDamageByEntityEvent)event);
        }
        if (event.getEntity() instanceof Wolf && (theWolf = (Wolf)event.getEntity()).isTamed() && Taming.ownerOnline(theWolf, (Plugin)pluginx)) {
            if (Taming.getOwner((Entity)theWolf, (Plugin)pluginx) == null) {
                return;
            }
            Player master = Taming.getOwner((Entity)theWolf, (Plugin)pluginx);
            PlayerProfile PPo = Users.getProfile(master);
            if (mcPermissions.getInstance().taming(master)) {
                if ((event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && PPo.getSkillLevel(SkillType.TAMING) >= 500) {
                    event.setDamage(2);
                }
                if (PPo.getSkillLevel(SkillType.TAMING) >= 250) {
                    event.setDamage(event.getDamage() / 2);
                }
            }
        }
    }

    public static void combatAbilityChecks(Player attacker, PlayerProfile PPa, Plugin pluginx) {
        if (PPa.getAxePreparationMode()) {
            Axes.skullSplitterCheck(attacker, pluginx);
        }
        if (PPa.getSwordsPreparationMode()) {
            Swords.serratedStrikesActivationCheck(attacker, pluginx);
        }
        if (PPa.getFistsPreparationMode()) {
            Unarmed.berserkActivationCheck(attacker, pluginx);
        }
    }

    public static void archeryCheck(EntityDamageByProjectileEvent event, mcMMO pluginx) {
        Entity y = event.getDamager();
        Entity x = event.getEntity();
        Projectile projectile = event.getProjectile();
        if (projectile.toString().equals("CraftArrow") && x instanceof Player) {
            Player defender = (Player)x;
            PlayerProfile PPd = Users.getProfile(defender);
            if (PPd == null) {
                Users.addUser(defender);
            }
            if (mcPermissions.getInstance().unarmed(defender) && defender.getItemInHand().getTypeId() == 0) {
                if (defender != null && PPd.getSkillLevel(SkillType.UNARMED) >= 1000) {
                    if (Math.random() * 1000.0 <= 500.0) {
                        event.setCancelled(true);
                        defender.sendMessage(mcLocale.getString("Combat.ArrowDeflect"));
                        return;
                    }
                } else if (defender != null && Math.random() * 1000.0 <= (double)(PPd.getSkillLevel(SkillType.UNARMED) / 2)) {
                    event.setCancelled(true);
                    defender.sendMessage(mcLocale.getString("Combat.ArrowDeflect"));
                    return;
                }
            }
        }
        if (y instanceof Player) {
            Player attacker = (Player)y;
            PlayerProfile PPa = Users.getProfile(attacker);
            if (projectile.toString().equals("CraftArrow") && mcPermissions.getInstance().archery(attacker)) {
                Archery.trackArrows(pluginx, x, event, attacker);
                if (PPa.getSkillLevel(SkillType.ARCHERY) >= 50 && PPa.getSkillLevel(SkillType.ARCHERY) < 250) {
                    event.setDamage(event.getDamage() + 1);
                }
                if (PPa.getSkillLevel(SkillType.ARCHERY) >= 250 && PPa.getSkillLevel(SkillType.ARCHERY) < 575) {
                    event.setDamage(event.getDamage() + 2);
                }
                if (PPa.getSkillLevel(SkillType.ARCHERY) >= 575 && PPa.getSkillLevel(SkillType.ARCHERY) < 725) {
                    event.setDamage(event.getDamage() + 3);
                }
                if (PPa.getSkillLevel(SkillType.ARCHERY) >= 725 && PPa.getSkillLevel(SkillType.ARCHERY) < 1000) {
                    event.setDamage(event.getDamage() + 4);
                }
                if (PPa.getSkillLevel(SkillType.ARCHERY) >= 1000) {
                    event.setDamage(event.getDamage() + 5);
                }
                Archery.ignitionCheck(x, event, attacker);
                if (!pluginx.misc.mobSpawnerList.contains(x) && x instanceof Monster) {
                    if (x instanceof Creeper) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 4 * LoadProperties.xpGainMultiplier);
                    }
                    if (x instanceof Spider) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 3 * LoadProperties.xpGainMultiplier);
                    }
                    if (x instanceof Skeleton) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 2 * LoadProperties.xpGainMultiplier);
                    }
                    if (x instanceof Zombie) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 2 * LoadProperties.xpGainMultiplier);
                    }
                    if (x instanceof PigZombie) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 3 * LoadProperties.xpGainMultiplier);
                    }
                    if (x instanceof Slime) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 3 * LoadProperties.xpGainMultiplier);
                    }
                    if (x instanceof Ghast) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 3 * LoadProperties.xpGainMultiplier);
                    }
                }
                if (x instanceof Player) {
                    Player defender = (Player)x;
                    PlayerProfile PPd = Users.getProfile(defender);
                    if (PPa.inParty() && PPd.inParty() && Party.getInstance().inSameParty(defender, attacker)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (LoadProperties.pvpxp.booleanValue() && !Party.getInstance().inSameParty(attacker, defender) && (long)((PPd.getLastLogin() + 5) * 1000) < System.currentTimeMillis()) {
                        PPa.addXP(SkillType.ARCHERY, event.getDamage() * 3 * LoadProperties.pvpxprewardmodifier);
                    }
                    Archery.dazeCheck(defender, attacker);
                }
            }
            Skills.XpCheckSkill(SkillType.ARCHERY, attacker);
        }
    }

    public static void dealDamage(Entity target, int dmg) {
        if (target instanceof Player) {
            ((Player)target).damage(dmg);
        }
        if (target instanceof Animals) {
            ((Animals)target).damage(dmg);
        }
        if (target instanceof Monster) {
            ((Monster)target).damage(dmg);
        }
    }

    public static boolean pvpAllowed(EntityDamageByEntityEvent event, World world) {
        return event.getEntity().getWorld().getPVP();
    }
}

