/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.Combat;
import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.Party;
import com.gmail.nossr50.skills.Acrobatics;
import com.gmail.nossr50.skills.Skills;
import com.gmail.nossr50.skills.Taming;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class mcEntityListener
extends EntityListener {
    private final mcMMO plugin;

    public mcEntityListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    public void onEntityDamage(EntityDamageEvent event) {
        LivingEntity entityliving;
        EntityDamageByEntityEvent eventb;
        if (event.isCancelled()) {
            return;
        }
        if (event instanceof EntityDamageByEntityEvent && (eventb = (EntityDamageByEntityEvent)event).getEntity() instanceof Player && eventb.getDamager() instanceof Player && !event.getEntity().getWorld().getPVP()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player defender = (Player)event.getEntity();
            PlayerProfile PPd = Users.getProfile(defender);
            if (defender != null && PPd.getGodMode()) {
                event.setCancelled(true);
            }
            if (PPd == null) {
                Users.addUser(defender);
            }
        }
        if (event.getEntity() instanceof LivingEntity && (float)(entityliving = (LivingEntity)event.getEntity()).getNoDamageTicks() < (float)entityliving.getMaximumNoDamageTicks() / 2.0f) {
            Entity x = event.getEntity();
            EntityDamageEvent.DamageCause type = event.getCause();
            if (event.getEntity() instanceof Wolf && ((Wolf)event.getEntity()).isTamed() && Taming.getOwner((Entity)((Wolf)event.getEntity()), (Plugin)this.plugin) != null) {
                Wolf theWolf = (Wolf)event.getEntity();
                Player master = Taming.getOwner((Entity)theWolf, (Plugin)this.plugin);
                PlayerProfile PPo = Users.getProfile(master);
                if (master == null || PPo == null) {
                    return;
                }
                if ((event.getCause() == EntityDamageEvent.DamageCause.CONTACT || event.getCause() == EntityDamageEvent.DamageCause.LAVA || event.getCause() == EntityDamageEvent.DamageCause.FIRE) && PPo.getSkillLevel(SkillType.TAMING) >= 100 && event.getDamage() < ((Wolf)event.getEntity()).getHealth()) {
                    event.getEntity().teleport(Taming.getOwner((Entity)theWolf, (Plugin)this.plugin).getLocation());
                    master.sendMessage(mcLocale.getString("mcEntityListener.WolfComesBack"));
                    event.getEntity().setFireTicks(0);
                }
                if (event.getCause() == EntityDamageEvent.DamageCause.FALL && PPo.getSkillLevel(SkillType.TAMING) >= 100) {
                    event.setCancelled(true);
                }
                if (event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
                    event.getEntity().setFireTicks(0);
                }
            }
            if (x instanceof Player) {
                Player player = (Player)x;
                if (type == EntityDamageEvent.DamageCause.FALL) {
                    Acrobatics.acrobaticsCheck(player, event);
                }
            }
            if (event instanceof EntityDamageByEntityEvent && !event.isCancelled()) {
                EntityDamageByEntityEvent eventb2 = (EntityDamageByEntityEvent)event;
                Entity f = eventb2.getDamager();
                Entity e = event.getEntity();
                if (event.getEntity() instanceof Player && f instanceof Player) {
                    Player defender = (Player)e;
                    Player attacker = (Player)f;
                    if (Party.getInstance().inSameParty(defender, attacker)) {
                        event.setCancelled(true);
                    }
                }
                Combat.combatChecks(event, this.plugin);
            }
            if (event.getEntity() instanceof Player && !event.isCancelled() && event.getDamage() >= 1) {
                Player herpderp = (Player)event.getEntity();
                Users.getProfile(herpderp).setRecentlyHurt(System.currentTimeMillis());
            }
        }
    }

    public void onEntityDeath(EntityDeathEvent event) {
        Entity x = event.getEntity();
        x.setFireTicks(0);
        if (this.plugin.mob.mobDiff.containsKey(event.getEntity().getEntityId())) {
            this.plugin.mob.mobDiff.remove(event.getEntity().getEntityId());
        }
        if (this.plugin.misc.bleedTracker.contains((LivingEntity)x)) {
            this.plugin.misc.addToBleedRemovalQue((LivingEntity)x);
        }
        Skills.arrowRetrievalCheck(x, this.plugin);
        if (x instanceof Player) {
            Player player = (Player)x;
            Users.getProfile(player).setBleedTicks(0);
        }
    }

    public void onCreatureSpawn(CreatureSpawnEvent event) {
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason == CreatureSpawnEvent.SpawnReason.SPAWNER && !LoadProperties.xpGainsMobSpawners.booleanValue()) {
            this.plugin.misc.mobSpawnerList.add(event.getEntity());
        } else if (event.getEntity() instanceof Monster && !this.plugin.mob.mobDiff.containsKey(event.getEntity().getEntityId())) {
            this.plugin.mob.assignDifficulty(event.getEntity());
        }
    }

    public void onEntityTarget(EntityTargetEvent event) {
        int type = event.getEntity().getEntityId();
        if (event.getEntity() instanceof Monster && this.plugin.mob.mobDiff.containsKey(type) && this.plugin.mob.isAggressive.containsKey(type) && this.plugin.mob.mobDiff.get(type) >= 2 && !this.plugin.mob.isAggressive.get(type).booleanValue()) {
            event.setCancelled(true);
            event.setTarget(null);
        }
    }

    public boolean isBow(ItemStack is) {
        return is.getTypeId() == 261;
    }

    public boolean isPlayer(Entity entity) {
        return entity instanceof Player;
    }
}

