/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.party;

import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.mcMMO;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class Party {
    public static String partyPlayersFile = String.valueOf(mcMMO.maindirectory) + File.separator + "FlatFileStuff" + File.separator + "partyPlayers";
    public static String partyLocksFile = String.valueOf(mcMMO.maindirectory) + File.separator + "FlatFileStuff" + File.separator + "partyLocks";
    public static String partyPasswordsFile = String.valueOf(mcMMO.maindirectory) + File.separator + "FlatFileStuff" + File.separator + "partyPasswords";
    HashMap<String, HashMap<String, Boolean>> partyPlayers = new HashMap();
    HashMap<String, Boolean> partyLocks = new HashMap();
    HashMap<String, String> partyPasswords = new HashMap();
    private static mcMMO plugin;
    private static volatile Party instance;

    public Party(mcMMO instance) {
        new File(String.valueOf(mcMMO.maindirectory) + File.separator + "FlatFileStuff").mkdir();
        plugin = instance;
    }

    public static Party getInstance() {
        if (instance == null) {
            instance = new Party(plugin);
        }
        return instance;
    }

    public boolean inSameParty(Player playera, Player playerb) {
        if (Users.getProfile(playera) == null || Users.getProfile(playerb) == null) {
            Users.addUser(playera);
            Users.addUser(playerb);
        }
        if (Users.getProfile(playera).inParty() && Users.getProfile(playerb).inParty()) {
            return Users.getProfile(playera).getParty().equals(Users.getProfile(playerb).getParty());
        }
        return false;
    }

    public int partyCount(Player player, Player[] players) {
        int x = 0;
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player hurrdurr = playerArray[n2];
            if (player != null && hurrdurr != null && Users.getProfile(player).getParty().equals(Users.getProfile(hurrdurr).getParty())) {
                ++x;
            }
            ++n2;
        }
        return x;
    }

    public void informPartyMembers(Player player) {
        Player[] players = plugin.getPlayersOnline();
        this.informPartyMembers(player, players);
    }

    public void informPartyMembers(Player player, Player[] players) {
        int x = 0;
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (player != null && p != null && this.inSameParty(player, p) && !p.getName().equals(player.getName())) {
                p.sendMessage(mcLocale.getString("Party.InformedOnJoin", new Object[]{player.getName()}));
                ++x;
            }
            ++n2;
        }
    }

    public void informPartyMembersOwnerChange(String newOwner) {
        Player newOwnerPlayer = plugin.getServer().getPlayer(newOwner);
        Player[] players = plugin.getPlayersOnline();
        this.informPartyMembersOwnerChange(newOwnerPlayer, players);
    }

    public void informPartyMembersOwnerChange(Player newOwner, Player[] players) {
        int x = 0;
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (newOwner != null && p != null && this.inSameParty(newOwner, p) && !p.getName().equals(newOwner.getName())) {
                p.sendMessage(String.valueOf(newOwner.getName()) + " is the new party owner.");
                ++x;
            }
            ++n2;
        }
    }

    public void informPartyMembersQuit(Player player) {
        Player[] players = plugin.getPlayersOnline();
        this.informPartyMembersQuit(player, players);
    }

    public void informPartyMembersQuit(Player player, Player[] players) {
        int x = 0;
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (player != null && p != null && this.inSameParty(player, p) && !p.getName().equals(player.getName())) {
                p.sendMessage(mcLocale.getString("Party.InformedOnQuit", new Object[]{player.getName()}));
                ++x;
            }
            ++n2;
        }
    }

    public void removeFromParty(Player player, PlayerProfile PP) {
        if (!this.isParty(PP.getParty()) || !this.isInParty(player, PP)) {
            this.addToParty(player, PP, PP.getParty(), false);
        }
        this.informPartyMembersQuit(player);
        String party = PP.getParty();
        if (this.isPartyLeader(player, party) && this.isPartyLocked(party)) {
            this.unlockParty(party);
        }
        this.partyPlayers.get(party).remove(player.getName());
        if (this.isPartyEmpty(party)) {
            this.deleteParty(party);
        }
        PP.removeParty();
        this.savePartyPlayers();
    }

    public void addToParty(Player player, PlayerProfile PP, String newParty, Boolean invite) {
        this.addToParty(player, PP, newParty, invite, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addToParty(Player player, PlayerProfile PP, String newParty, Boolean invite, String password) {
        if (!invite.booleanValue()) {
            if (this.isPartyLocked(newParty)) {
                if (!this.isPartyPasswordProtected(newParty)) {
                    player.sendMessage("Party is locked.");
                    return;
                }
                if (password == null) {
                    player.sendMessage("This party requires a password. Use " + LoadProperties.party + " <party> <password> to join it.");
                    return;
                }
                if (!password.equalsIgnoreCase(this.getPartyPassword(newParty))) {
                    player.sendMessage("Party password incorrect.");
                    return;
                }
            }
        } else {
            PP.acceptInvite();
        }
        if (!this.isParty(newParty)) {
            Party.putNestedEntry(this.partyPlayers, newParty, player.getName(), true);
            this.partyLocks.put(newParty, false);
            this.partyPasswords.put(newParty, null);
            this.saveParties();
        } else {
            Party.putNestedEntry(this.partyPlayers, newParty, player.getName(), false);
            this.savePartyPlayers();
        }
        PP.setParty(newParty);
        this.informPartyMembers(player);
        if (!invite.booleanValue()) {
            player.sendMessage(mcLocale.getString("mcPlayerListener.JoinedParty", new Object[]{newParty}));
            return;
        }
        player.sendMessage(mcLocale.getString("mcPlayerListener.InviteAccepted", new Object[]{PP.getParty()}));
    }

    private static <U, V, W> W putNestedEntry(HashMap<U, HashMap<V, W>> nest, U nestKey, V nestedKey, W nestedValue) {
        HashMap<Object, Object> nested = nest.get(nestKey);
        if (nested == null) {
            nested = new HashMap();
            nest.put(nestKey, nested);
        }
        return nested.put(nestedKey, nestedValue);
    }

    public void dump(Player player) {
        player.sendMessage(this.partyPlayers.toString());
        player.sendMessage(this.partyLocks.toString());
        player.sendMessage(this.partyPasswords.toString());
        for (String nestkey : this.partyPlayers.keySet()) {
            player.sendMessage(nestkey);
            for (String nestedkey : this.partyPlayers.get(nestkey).keySet()) {
                player.sendMessage("." + nestedkey);
                if (this.partyPlayers.get(nestkey).get(nestedkey).booleanValue()) {
                    player.sendMessage("..True");
                    continue;
                }
                player.sendMessage("..False");
            }
        }
    }

    public void lockParty(String partyName) {
        this.partyLocks.put(partyName, true);
        this.savePartyLocks();
    }

    public void unlockParty(String partyName) {
        this.partyLocks.put(partyName, false);
        this.savePartyLocks();
    }

    public void deleteParty(String partyName) {
        this.partyPlayers.remove(partyName);
        this.partyLocks.remove(partyName);
        this.partyPasswords.remove(partyName);
        this.saveParties();
    }

    public void setPartyPassword(String partyName, String password) {
        if (password.equalsIgnoreCase("\"\"")) {
            password = null;
        }
        this.partyPasswords.put(partyName, password);
        this.savePartyPasswords();
    }

    public void setPartyLeader(String partyName, String playerName) {
        for (String playerKey : this.partyPlayers.get(partyName).keySet()) {
            if (playerKey.equalsIgnoreCase(playerName)) {
                this.partyPlayers.get(partyName).put(playerName, true);
                this.informPartyMembersOwnerChange(playerName);
                plugin.getServer().getPlayer(playerName).sendMessage("You are now the party owner.");
                continue;
            }
            if (!this.partyPlayers.get(partyName).get(playerKey).booleanValue()) continue;
            plugin.getServer().getPlayer(playerKey).sendMessage("You are no longer party owner.");
            this.partyPlayers.get(partyName).put(playerKey, false);
        }
    }

    public String getPartyPassword(String partyName) {
        return this.partyPasswords.get(partyName);
    }

    public boolean canInvite(Player player, PlayerProfile PP) {
        return !this.isPartyLocked(PP.getParty()) || this.isPartyLeader(player, PP.getParty());
    }

    public boolean isParty(String partyName) {
        return this.partyPlayers.containsKey(partyName);
    }

    public boolean isPartyEmpty(String partyName) {
        return this.partyPlayers.get(partyName).isEmpty();
    }

    public boolean isPartyLeader(Player player, String partyName) {
        if (this.partyPlayers.get(partyName).get(player.getName()) == null) {
            return false;
        }
        return this.partyPlayers.get(partyName).get(player.getName());
    }

    public boolean isPartyLocked(String partyName) {
        if (this.partyLocks.get(partyName) == null) {
            return false;
        }
        return this.partyLocks.get(partyName);
    }

    public boolean isPartyPasswordProtected(String partyName) {
        return this.partyPasswords.get(partyName) != null;
    }

    public boolean isInParty(Player player, PlayerProfile PP) {
        return this.partyPlayers.get(PP.getParty()).containsKey(player.getName());
    }

    public void loadParties() {
        ObjectInputStream obj;
        if (new File(partyPlayersFile).exists()) {
            try {
                obj = new ObjectInputStream(new FileInputStream(partyPlayersFile));
                this.partyPlayers = (HashMap)obj.readObject();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (EOFException e) {
                mcMMO.log.info("partyPlayersFile empty.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (new File(partyLocksFile).exists()) {
            try {
                obj = new ObjectInputStream(new FileInputStream(partyLocksFile));
                this.partyLocks = (HashMap)obj.readObject();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (EOFException e) {
                mcMMO.log.info("partyLocksFile empty.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (new File(partyPasswordsFile).exists()) {
            try {
                obj = new ObjectInputStream(new FileInputStream(partyPasswordsFile));
                this.partyPasswords = (HashMap)obj.readObject();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (EOFException e) {
                mcMMO.log.info("partyPasswordsFile empty.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveParties() {
        this.savePartyPlayers();
        this.savePartyLocks();
        this.savePartyPasswords();
    }

    public void savePartyPlayers() {
        try {
            new File(partyPlayersFile).createNewFile();
            ObjectOutputStream obj = new ObjectOutputStream(new FileOutputStream(partyPlayersFile));
            obj.writeObject(this.partyPlayers);
            obj.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void savePartyLocks() {
        try {
            new File(partyLocksFile).createNewFile();
            ObjectOutputStream obj = new ObjectOutputStream(new FileOutputStream(partyLocksFile));
            obj.writeObject(this.partyLocks);
            obj.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void savePartyPasswords() {
        try {
            new File(partyPasswordsFile).createNewFile();
            ObjectOutputStream obj = new ObjectOutputStream(new FileOutputStream(partyPasswordsFile));
            obj.writeObject(this.partyPasswords);
            obj.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

