/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills;

import com.gmail.nossr50.Leaderboard;
import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.contrib.SpoutStuff;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.datatypes.PlayerStat;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcPermissions;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.getspout.spoutapi.SpoutManager;
import org.getspout.spoutapi.player.SpoutPlayer;

public class Skills {
    protected static final Logger log = Logger.getLogger("Minecraft");

    public void updateSQLfromFile(Player player) {
    }

    public static boolean cooldownOver(Player player, long oldTime, int cooldown) {
        long currentTime = System.currentTimeMillis();
        return currentTime - oldTime >= (long)(cooldown * 1000);
    }

    public boolean hasArrows(Player player) {
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack x = itemStackArray[n2];
            if (x.getTypeId() == 262) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addArrows(Player player) {
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack x = itemStackArray[n2];
            if (x.getTypeId() == 262) {
                x.setAmount(x.getAmount() + 1);
                return;
            }
            ++n2;
        }
    }

    public static int calculateTimeLeft(Player player, long deactivatedTimeStamp, int cooldown) {
        return (int)((deactivatedTimeStamp + (long)(cooldown * 1000) - System.currentTimeMillis()) / 1000L);
    }

    public static void watchCooldowns(Player player) {
        PlayerProfile PP = Users.getProfile(player);
        if (!PP.getGreenTerraInformed() && System.currentTimeMillis() - PP.getGreenTerraDeactivatedTimeStamp() >= (long)(LoadProperties.greenTerraCooldown * 1000)) {
            PP.setGreenTerraInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourGreenTerra"));
        }
        if (!PP.getTreeFellerInformed() && System.currentTimeMillis() - PP.getTreeFellerDeactivatedTimeStamp() >= (long)(LoadProperties.greenTerraCooldown * 1000)) {
            PP.setTreeFellerInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourTreeFeller"));
        }
        if (!PP.getSuperBreakerInformed() && System.currentTimeMillis() - PP.getSuperBreakerDeactivatedTimeStamp() >= (long)(LoadProperties.superBreakerCooldown * 1000)) {
            PP.setSuperBreakerInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourSuperBreaker"));
        }
        if (!PP.getSerratedStrikesInformed() && System.currentTimeMillis() - PP.getSerratedStrikesDeactivatedTimeStamp() >= (long)(LoadProperties.serratedStrikeCooldown * 1000)) {
            PP.setSerratedStrikesInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourSerratedStrikes"));
        }
        if (!PP.getBerserkInformed() && System.currentTimeMillis() - PP.getBerserkDeactivatedTimeStamp() >= (long)(LoadProperties.berserkCooldown * 1000)) {
            PP.setBerserkInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourBerserk"));
        }
        if (!PP.getSkullSplitterInformed() && System.currentTimeMillis() - PP.getSkullSplitterDeactivatedTimeStamp() >= (long)(LoadProperties.skullSplitterCooldown * 1000)) {
            PP.setSkullSplitterInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourSkullSplitter"));
        }
        if (!PP.getGigaDrillBreakerInformed() && System.currentTimeMillis() - PP.getGigaDrillBreakerDeactivatedTimeStamp() >= (long)(LoadProperties.gigaDrillBreakerCooldown * 1000)) {
            PP.setGigaDrillBreakerInformed(true);
            player.sendMessage(mcLocale.getString("Skills.YourGigaDrillBreaker"));
        }
    }

    public static void hoeReadinessCheck(Player player) {
        PlayerProfile PP = Users.getProfile(player);
        if (mcPermissions.getInstance().herbalismAbility(player) && m.isHoe(player.getItemInHand()) && !PP.getHoePreparationMode()) {
            if (!PP.getGreenTerraMode() && !Skills.cooldownOver(player, PP.getGreenTerraDeactivatedTimeStamp(), LoadProperties.greenTerraCooldown)) {
                player.sendMessage(String.valueOf(mcLocale.getString("Skills.TooTired")) + ChatColor.YELLOW + " (" + Skills.calculateTimeLeft(player, PP.getGreenTerraDeactivatedTimeStamp(), LoadProperties.greenTerraCooldown) + "s)");
                return;
            }
            player.sendMessage(mcLocale.getString("Skills.ReadyHoe"));
            PP.setHoePreparationATS(System.currentTimeMillis());
            PP.setHoePreparationMode(true);
        }
    }

    public static void monitorSkills(Player player) {
        PlayerProfile PP = Users.getProfile(player);
        if (PP != null) {
            if (PP.getHoePreparationMode() && System.currentTimeMillis() - PP.getHoePreparationATS() >= 4000L) {
                PP.setHoePreparationMode(false);
                player.sendMessage(mcLocale.getString("Skills.LowerHoe"));
            }
            if (PP.getAxePreparationMode() && System.currentTimeMillis() - PP.getAxePreparationATS() >= 4000L) {
                PP.setAxePreparationMode(false);
                player.sendMessage(mcLocale.getString("Skills.LowerAxe"));
            }
            if (PP.getPickaxePreparationMode() && System.currentTimeMillis() - PP.getPickaxePreparationATS() >= 4000L) {
                PP.setPickaxePreparationMode(false);
                player.sendMessage(mcLocale.getString("Skills.LowerPickAxe"));
            }
            if (PP.getSwordsPreparationMode() && System.currentTimeMillis() - PP.getSwordsPreparationATS() >= 4000L) {
                PP.setSwordsPreparationMode(false);
                player.sendMessage(mcLocale.getString("Skills.LowerSword"));
            }
            if (PP.getFistsPreparationMode() && System.currentTimeMillis() - PP.getFistsPreparationATS() >= 4000L) {
                PP.setFistsPreparationMode(false);
                player.sendMessage(mcLocale.getString("Skills.LowerFists"));
            }
            if (PP.getShovelPreparationMode() && System.currentTimeMillis() - PP.getShovelPreparationATS() >= 4000L) {
                PP.setShovelPreparationMode(false);
                player.sendMessage(mcLocale.getString("Skills.LowerShovel"));
            }
            if (mcPermissions.getInstance().herbalismAbility(player) && PP.getGreenTerraMode() && PP.getGreenTerraDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setGreenTerraMode(false);
                PP.setGreenTerraInformed(false);
                player.sendMessage(mcLocale.getString("Skills.GreenTerraOff"));
            }
            if (mcPermissions.getInstance().axesAbility(player) && PP.getSkullSplitterMode() && PP.getSkullSplitterDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setSkullSplitterMode(false);
                PP.setSkullSplitterInformed(false);
                player.sendMessage(mcLocale.getString("Skills.SkullSplitterOff"));
            }
            if (mcPermissions.getInstance().woodCuttingAbility(player) && PP.getTreeFellerMode() && PP.getTreeFellerDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setTreeFellerMode(false);
                PP.setTreeFellerInformed(false);
                player.sendMessage(mcLocale.getString("Skills.TreeFellerOff"));
            }
            if (mcPermissions.getInstance().miningAbility(player) && PP.getSuperBreakerMode() && PP.getSuperBreakerDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setSuperBreakerMode(false);
                PP.setSuperBreakerInformed(false);
                player.sendMessage(mcLocale.getString("Skills.SuperBreakerOff"));
            }
            if (mcPermissions.getInstance().excavationAbility(player) && PP.getGigaDrillBreakerMode() && PP.getGigaDrillBreakerDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setGigaDrillBreakerMode(false);
                PP.setGigaDrillBreakerInformed(false);
                player.sendMessage(mcLocale.getString("Skills.GigaDrillBreakerOff"));
            }
            if (mcPermissions.getInstance().swordsAbility(player) && PP.getSerratedStrikesMode() && PP.getSerratedStrikesDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setSerratedStrikesMode(false);
                PP.setSerratedStrikesInformed(false);
                player.sendMessage(mcLocale.getString("Skills.SerratedStrikesOff"));
            }
            if (mcPermissions.getInstance().unarmedAbility(player) && PP.getBerserkMode() && PP.getBerserkDeactivatedTimeStamp() <= System.currentTimeMillis()) {
                PP.setBerserkMode(false);
                PP.setBerserkInformed(false);
                player.sendMessage(mcLocale.getString("Skills.BerserkOff"));
            }
        }
    }

    public static void abilityActivationCheck(Player player) {
        PlayerProfile PP = Users.getProfile(player);
        if (PP != null) {
            if (!PP.getAbilityUse()) {
                return;
            }
            if (mcPermissions.getInstance().miningAbility(player) && m.isMiningPick(player.getItemInHand()) && !PP.getPickaxePreparationMode()) {
                if (!PP.getSuperBreakerMode() && !Skills.cooldownOver(player, PP.getSuperBreakerDeactivatedTimeStamp(), LoadProperties.superBreakerCooldown)) {
                    player.sendMessage(String.valueOf(mcLocale.getString("Skills.TooTired")) + ChatColor.YELLOW + " (" + Skills.calculateTimeLeft(player, PP.getSuperBreakerDeactivatedTimeStamp(), LoadProperties.superBreakerCooldown) + "s)");
                    return;
                }
                player.sendMessage(mcLocale.getString("Skills.ReadyPickAxe"));
                PP.setPickaxePreparationATS(System.currentTimeMillis());
                PP.setPickaxePreparationMode(true);
            }
            if (mcPermissions.getInstance().excavationAbility(player) && m.isShovel(player.getItemInHand()) && !PP.getShovelPreparationMode()) {
                if (!PP.getGigaDrillBreakerMode() && !Skills.cooldownOver(player, PP.getGigaDrillBreakerDeactivatedTimeStamp(), LoadProperties.gigaDrillBreakerCooldown)) {
                    player.sendMessage(String.valueOf(mcLocale.getString("Skills.TooTired")) + ChatColor.YELLOW + " (" + Skills.calculateTimeLeft(player, PP.getGigaDrillBreakerDeactivatedTimeStamp(), LoadProperties.gigaDrillBreakerCooldown) + "s)");
                    return;
                }
                player.sendMessage(mcLocale.getString("Skills.ReadyShovel"));
                PP.setShovelPreparationATS(System.currentTimeMillis());
                PP.setShovelPreparationMode(true);
            }
            if (mcPermissions.getInstance().swordsAbility(player) && m.isSwords(player.getItemInHand()) && !PP.getSwordsPreparationMode()) {
                if (!PP.getSerratedStrikesMode() && !Skills.cooldownOver(player, PP.getSerratedStrikesDeactivatedTimeStamp(), LoadProperties.serratedStrikeCooldown)) {
                    player.sendMessage(String.valueOf(mcLocale.getString("Skills.TooTired")) + ChatColor.YELLOW + " (" + Skills.calculateTimeLeft(player, PP.getSerratedStrikesDeactivatedTimeStamp(), LoadProperties.serratedStrikeCooldown) + "s)");
                    return;
                }
                player.sendMessage(mcLocale.getString("Skills.ReadySword"));
                PP.setSwordsPreparationATS(System.currentTimeMillis());
                PP.setSwordsPreparationMode(true);
            }
            if (mcPermissions.getInstance().unarmedAbility(player) && player.getItemInHand().getTypeId() == 0 && !PP.getFistsPreparationMode()) {
                if (!PP.getBerserkMode() && !Skills.cooldownOver(player, PP.getBerserkDeactivatedTimeStamp(), LoadProperties.berserkCooldown)) {
                    player.sendMessage(String.valueOf(mcLocale.getString("Skills.TooTired")) + ChatColor.YELLOW + " (" + Skills.calculateTimeLeft(player, PP.getBerserkDeactivatedTimeStamp(), LoadProperties.berserkCooldown) + "s)");
                    return;
                }
                player.sendMessage(mcLocale.getString("Skills.ReadyFists"));
                PP.setFistsPreparationATS(System.currentTimeMillis());
                PP.setFistsPreparationMode(true);
            }
            if ((mcPermissions.getInstance().axes(player) || mcPermissions.getInstance().woodcutting(player)) && !PP.getAxePreparationMode() && m.isAxes(player.getItemInHand())) {
                player.sendMessage(mcLocale.getString("Skills.ReadyAxe"));
                PP.setAxePreparationATS(System.currentTimeMillis());
                PP.setAxePreparationMode(true);
            }
        }
    }

    public static void ProcessLeaderboardUpdate(SkillType skillType, Player player) {
        PlayerProfile PP = Users.getProfile(player);
        PlayerStat ps = new PlayerStat();
        ps.statVal = skillType != SkillType.ALL ? PP.getSkillLevel(skillType) : m.getPowerLevel(player);
        ps.name = player.getName();
        Leaderboard.updateLeaderboard(ps, skillType);
    }

    public static void XpCheckSkill(SkillType skillType, Player player) {
        PlayerProfile PP = Users.getProfile(player);
        if (PP.getSkillXpLevel(skillType) >= PP.getXpToLevel(skillType)) {
            int skillups = 0;
            while (PP.getSkillXpLevel(skillType) >= PP.getXpToLevel(skillType)) {
                ++skillups;
                PP.removeXP(skillType, PP.getXpToLevel(skillType));
                PP.skillUp(skillType, 1);
            }
            if (!LoadProperties.useMySQL.booleanValue()) {
                Skills.ProcessLeaderboardUpdate(skillType, player);
                Skills.ProcessLeaderboardUpdate(SkillType.ALL, player);
            }
            String capitalized = m.getCapitalized(skillType.toString());
            if (LoadProperties.spoutEnabled.booleanValue() && player instanceof SpoutPlayer) {
                SpoutPlayer sPlayer = SpoutManager.getPlayerFromId((int)player.getEntityId());
                if (sPlayer.isSpoutCraftEnabled()) {
                    SpoutStuff.levelUpNotification(skillType, sPlayer);
                } else {
                    player.sendMessage(mcLocale.getString("Skills." + capitalized + "Up", new Object[]{String.valueOf(skillups), PP.getSkillLevel(skillType)}));
                }
            } else {
                player.sendMessage(mcLocale.getString("Skills." + capitalized + "Up", new Object[]{String.valueOf(skillups), PP.getSkillLevel(skillType)}));
            }
        }
    }

    public static void XpCheckAll(Player player) {
        SkillType[] skillTypeArray = SkillType.values();
        int n = skillTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkillType x = skillTypeArray[n2];
            if (x != SkillType.ALL) {
                Skills.XpCheckSkill(x, player);
            }
            ++n2;
        }
    }

    public static SkillType getSkillType(String skillName) {
        SkillType[] skillTypeArray = SkillType.values();
        int n = skillTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkillType x = skillTypeArray[n2];
            if (x.toString().equals(skillName.toUpperCase())) {
                return x;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isSkill(String skillname) {
        skillname = skillname.toUpperCase();
        SkillType[] skillTypeArray = SkillType.values();
        int n = skillTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkillType x = skillTypeArray[n2];
            if (x.toString().equals(skillname)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void arrowRetrievalCheck(Entity entity, mcMMO plugin) {
        if (plugin.misc.arrowTracker.containsKey(entity)) {
            Integer x = 0;
            while (x < plugin.misc.arrowTracker.get(entity)) {
                m.mcDropItem(entity.getLocation(), 262);
                x = x + 1;
            }
        }
        plugin.misc.arrowTracker.remove(entity);
    }

    public static String getSkillStats(String skillname, Integer level, Integer XP, Integer XPToLevel) {
        ChatColor parColor = ChatColor.DARK_AQUA;
        ChatColor xpColor = ChatColor.GRAY;
        ChatColor LvlColor = ChatColor.GREEN;
        ChatColor skillColor = ChatColor.YELLOW;
        return skillColor + skillname + LvlColor + level + parColor + " XP" + "(" + xpColor + XP + parColor + "/" + xpColor + XPToLevel + parColor + ")";
    }

    public static boolean hasCombatSkills(Player player) {
        return mcPermissions.getInstance().axes(player) || mcPermissions.getInstance().archery(player) || mcPermissions.getInstance().sorcery(player) || mcPermissions.getInstance().swords(player) || mcPermissions.getInstance().taming(player) || mcPermissions.getInstance().unarmed(player);
    }

    public static boolean hasGatheringSkills(Player player) {
        return mcPermissions.getInstance().excavation(player) || mcPermissions.getInstance().herbalism(player) || mcPermissions.getInstance().mining(player) || mcPermissions.getInstance().woodcutting(player);
    }

    public static boolean hasMiscSkills(Player player) {
        return mcPermissions.getInstance().acrobatics(player) || mcPermissions.getInstance().repair(player);
    }
}

