/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block;

import com.bukkit.gemo.FalseBook.Block.DoorArea;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockBlockListener;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockCore;
import com.gemo.utils.SignUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class Door {
    public static boolean isBlockTypeAllowed(int ID, String worldName) {
        ArrayList<Integer> list = FalseBookBlockCore.getAllowedDoorBlocks(worldName);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == ID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int toggle(Sign signBlock) {
        if (signBlock.getTypeId() != Material.WALL_SIGN.getId() && signBlock.getTypeId() != Material.SIGN_POST.getId()) {
            return -10;
        }
        int signDir = SignUtils.getDirection((Sign)signBlock);
        if (signDir == -1) {
            return -9;
        }
        int doorLeft = 1;
        int doorRight = 1;
        try {
            doorLeft = Integer.valueOf(signBlock.getLine(2));
        }
        catch (Exception e) {
            doorLeft = 1;
        }
        try {
            doorRight = Integer.valueOf(signBlock.getLine(3));
        }
        catch (Exception e) {
            doorRight = 1;
        }
        Sign opSign = Door.getOppositeSign(signBlock, signDir);
        if (opSign == null) {
            return -8;
        }
        int door2ndLeft = 1;
        int door2ndRight = 1;
        try {
            door2ndLeft = Integer.valueOf(opSign.getLine(2));
        }
        catch (Exception e) {
            door2ndLeft = 1;
        }
        try {
            door2ndRight = Integer.valueOf(opSign.getLine(3));
        }
        catch (Exception e) {
            door2ndRight = 1;
        }
        if (doorLeft != door2ndLeft || doorRight != door2ndRight) {
            return -7;
        }
        int result = -10;
        if (signBlock.getLine(1).equalsIgnoreCase("[Door Up]")) {
            result = Door.toggle(signBlock, opSign, signBlock.getBlock().getRelative(0, 1, 0), signDir, doorLeft, doorRight);
        } else if (signBlock.getLine(1).equalsIgnoreCase("[Door Down]")) {
            result = Door.toggle(signBlock, opSign, signBlock.getBlock().getRelative(0, -1, 0), signDir, doorLeft, doorRight);
        }
        return result;
    }

    public static int toggle(Sign signBlock, Sign opSign, Block originBlock, int signDir, int doorLeft, int doorRight) {
        boolean toggleOn;
        if (!Door.isBlockTypeAllowed(originBlock.getTypeId(), originBlock.getWorld().getName())) {
            originBlock = null;
            return 0;
        }
        ArrayList<Block> BaseBlocks = Door.getBase(signBlock, opSign, signDir, doorLeft, doorRight);
        if (!Door.verifyBaseBlocks(BaseBlocks, originBlock, true)) {
            BaseBlocks.clear();
            BaseBlocks = null;
            return 1;
        }
        ArrayList<Block> newArea = Door.getArea(signBlock, opSign, signDir, doorLeft, doorRight);
        if (newArea.size() == 0) {
            return 2;
        }
        boolean bl = toggleOn = newArea.get(0).getTypeId() != originBlock.getTypeId();
        if (toggleOn) {
            if (!Door.verifyBaseBlocks(newArea, 0, (byte)0, false)) {
                BaseBlocks.clear();
                BaseBlocks = null;
                return 1;
            }
        } else if (!Door.verifyBaseBlocks(newArea, originBlock, false)) {
            BaseBlocks.clear();
            BaseBlocks = null;
            return 1;
        }
        int i = 0;
        while (i < newArea.size()) {
            if (toggleOn) {
                newArea.get(i).setTypeIdAndData(originBlock.getTypeId(), originBlock.getData(), true);
            } else {
                newArea.get(i).setTypeIdAndData(0, (byte)0, true);
            }
            ++i;
        }
        DoorArea now = new DoorArea(signBlock, opSign);
        if (!toggleOn) {
            if (FalseBookBlockBlockListener.isInDoorList(now) != -1) {
                FalseBookBlockBlockListener.getDoorAreas().remove(FalseBookBlockBlockListener.isInDoorList(now));
            }
        } else {
            if (FalseBookBlockBlockListener.isInDoorList(now) == -1) {
                FalseBookBlockBlockListener.getDoorAreas().add(now);
            }
            now.addBlock(signBlock.getBlock());
            now.addBlock(opSign.getBlock());
            if (signBlock.getLine(1).equalsIgnoreCase("[Door Up]")) {
                now.addBlock(signBlock.getBlock().getRelative(0, -1, 0));
            } else {
                now.addBlock(opSign.getBlock().getRelative(0, -1, 0));
            }
            int i2 = 0;
            while (i2 < BaseBlocks.size()) {
                now.addBlock(BaseBlocks.get(i2));
                ++i2;
            }
            i2 = 0;
            while (i2 < newArea.size()) {
                now.addBlock(newArea.get(i2));
                ++i2;
            }
        }
        originBlock = null;
        newArea.clear();
        newArea = null;
        BaseBlocks.clear();
        BaseBlocks = null;
        return 8;
    }

    public static ArrayList<Block> getArea(Sign firstSign, Sign secondSign, int signDir, int widthLeft, int widthRight) {
        ArrayList<Block> newArea = new ArrayList<Block>();
        Block originBlock = firstSign.getBlock();
        Block originBlock2nd = secondSign.getBlock();
        int flagX = 0;
        int flagZ = 0;
        int noteFlag = 1;
        if (signDir == 1) {
            flagX = 1;
            noteFlag = -1;
        } else if (signDir == 3) {
            flagX = -1;
            noteFlag = -1;
        } else if (signDir == 2) {
            flagZ = -1;
            noteFlag = -1;
        } else if (signDir == 4) {
            flagZ = 1;
            noteFlag = -1;
        }
        int doorHeight = Math.abs(originBlock.getY() - originBlock2nd.getY()) - 2;
        Block downBlock = firstSign.getBlock();
        if (firstSign.getY() > secondSign.getY()) {
            downBlock = secondSign.getBlock();
        }
        int i = 2;
        while (i < doorHeight + 1) {
            newArea.add(downBlock.getRelative(0, i, 0));
            int left = 1;
            while (left <= widthLeft) {
                newArea.add(downBlock.getRelative(left * flagX * noteFlag, i, left * flagZ * noteFlag));
                ++left;
            }
            int right = 1;
            while (right <= widthRight) {
                newArea.add(downBlock.getRelative(right * -flagX * noteFlag, i, right * -flagZ * noteFlag));
                ++right;
            }
            ++i;
        }
        return newArea;
    }

    public static ArrayList<Block> getBase(Sign firstSign, Sign secondSign, int signDir, int widthLeft, int widthRight) {
        ArrayList<Block> newArea = new ArrayList<Block>();
        Block originBlock = firstSign.getBlock();
        Block originBlock2nd = secondSign.getBlock();
        int flagX = 0;
        int flagZ = 0;
        int noteFlag = 1;
        if (signDir == 1) {
            flagX = 1;
            noteFlag = -1;
        } else if (signDir == 3) {
            flagX = -1;
            noteFlag = -1;
        } else if (signDir == 2) {
            flagZ = -1;
            noteFlag = -1;
        } else if (signDir == 4) {
            flagZ = 1;
            noteFlag = -1;
        }
        int signFlag = 1;
        if (firstSign.getLine(1).equalsIgnoreCase("[Door Down]")) {
            signFlag = -1;
        }
        newArea.add(originBlock.getRelative(0, 1 * signFlag, 0));
        newArea.add(originBlock2nd.getRelative(0, -1 * signFlag, 0));
        int left = 1;
        while (left <= widthLeft) {
            newArea.add(originBlock.getRelative(left * flagX * noteFlag, 1 * signFlag, left * flagZ * noteFlag));
            newArea.add(originBlock2nd.getRelative(left * flagX * noteFlag, -1 * signFlag, left * flagZ * noteFlag));
            ++left;
        }
        int right = 1;
        while (right <= widthRight) {
            newArea.add(originBlock.getRelative(right * -flagX * noteFlag, 1 * signFlag, right * -flagZ * noteFlag));
            newArea.add(originBlock2nd.getRelative(right * -flagX * noteFlag, -1 * signFlag, right * -flagZ * noteFlag));
            ++right;
        }
        return newArea;
    }

    public static boolean verifyBaseBlocks(ArrayList<Block> BaseBlocks, Block origin, boolean base) {
        return Door.verifyBaseBlocks(BaseBlocks, origin.getTypeId(), origin.getData(), base);
    }

    public static boolean verifyBaseBlocks(ArrayList<Block> BaseBlocks, int TypeID, byte Data, boolean base) {
        int i = 0;
        while (i < BaseBlocks.size()) {
            if (BaseBlocks.get(i).getTypeId() != TypeID) {
                if (base) {
                    return false;
                }
                if (!BaseBlocks.get(i).isLiquid()) {
                    return false;
                }
            } else if (BaseBlocks.get(i).getData() != Data) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Sign getOppositeSign(Sign signBlock, int signDir) {
        block5: {
            int thisID;
            Block block;
            block4: {
                block = signBlock.getBlock();
                thisID = -1;
                if (!signBlock.getLine(1).equalsIgnoreCase("[Door Up]")) break block4;
                int i = 2;
                while (i <= 128 && block.getY() + i <= 128) {
                    Sign opSign;
                    thisID = block.getRelative(0, i, 0).getTypeId();
                    if ((thisID == Material.WALL_SIGN.getId() || thisID == Material.SIGN_POST.getId()) && signDir == SignUtils.getDirection((Sign)(opSign = (Sign)block.getRelative(0, i, 0).getState())) && opSign.getLine(1).equalsIgnoreCase("[Door Down]")) {
                        return opSign;
                    }
                    ++i;
                }
                break block5;
            }
            if (!signBlock.getLine(1).equalsIgnoreCase("[Door Down]")) break block5;
            int i = 2;
            while (i <= 128 && block.getY() - i >= 0) {
                Sign opSign;
                thisID = block.getRelative(0, -i, 0).getTypeId();
                if ((thisID == Material.WALL_SIGN.getId() || thisID == Material.SIGN_POST.getId()) && signDir == SignUtils.getDirection((Sign)(opSign = (Sign)block.getRelative(0, -i, 0).getState())) && opSign.getLine(1).equalsIgnoreCase("[Door Up]")) {
                    return opSign;
                }
                ++i;
            }
        }
        return null;
    }
}

