/*
 * Decompiled with CFR 0.152.
 */
package com.enigmasm.serverbot;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.util.config.Configuration;

public class Bot {
    private String name;
    private String color;
    private Map<String[], String> actionCatches = new HashMap<String[], String>();
    private Map<String[], String> spokenCatches = new HashMap<String[], String>();
    private Map<String, String> otherCatches = new HashMap<String, String>();
    private Map<String, Integer> knownUsers = new HashMap<String, Integer>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        if (!color.matches("[0-9a-fA-F]")) {
            return;
        }
        this.color = color.toLowerCase();
    }

    public String getActionCatch(String caughtText) {
        if (!(caughtText = caughtText.replace("/me ", "")).contains(this.name)) {
            return null;
        }
        String[] split = caughtText.split(this.name);
        String[] caughtKey = null;
        for (String[] catcher : this.actionCatches.keySet()) {
            if (!split[0].contains(catcher[0])) continue;
            caughtKey = catcher;
        }
        if (caughtKey == null) {
            return null;
        }
        if (split.length == 1 && (caughtKey[1] == null || caughtKey[1].equals("")) || split.length == 2 && split[1].contains(caughtKey[1])) {
            return this.actionCatches.get(caughtKey);
        }
        return null;
    }

    public String getSpokenCatch(String caughtText) {
        if (!caughtText.contains(this.name)) {
            return null;
        }
        String[] split = caughtText.split(this.name);
        String[] caughtKey = null;
        for (String[] catcher : this.spokenCatches.keySet()) {
            if (!split[0].contains(catcher[0])) continue;
            caughtKey = catcher;
        }
        if (caughtKey == null) {
            return null;
        }
        if (split.length == 1 && (caughtKey[1] == null || caughtKey[1].equals("")) || split.length == 2 && split[1].contains(caughtKey[1])) {
            return this.spokenCatches.get(caughtKey);
        }
        return null;
    }

    public String getOtherCatch(String caller) {
        String caughtKey = null;
        for (String catcher : this.otherCatches.keySet()) {
            if (!caller.contains(catcher)) continue;
            caughtKey = catcher;
        }
        if (caughtKey == null) {
            return null;
        }
        return this.otherCatches.get(caughtKey);
    }

    public void writeActionCatch(String before, String after, String response) {
    }

    public String getDisplayName() {
        return "\u00a7" + this.color + this.name;
    }

    public void loadCatches(Configuration config) {
        List keys3;
        List keys2;
        List keys = config.getKeys("bot.action");
        if (keys != null) {
            for (String s : keys) {
                List values = config.getStringList("bot.action." + s, null);
                if (values == null) continue;
                Object[] test = values.toArray();
                String[] insert = new String[test.length + 1];
                int i = 0;
                while (i < test.length) {
                    insert[i] = test[i] == null ? "" : test[i].toString();
                    ++i;
                }
                if (insert[1] == null) {
                    insert[1] = "";
                }
                if (insert == null || insert.length != 2) continue;
                this.actionCatches.put(insert, s);
            }
        }
        if ((keys2 = config.getKeys("bot.spoken")) != null) {
            for (String s : keys2) {
                List values = config.getStringList("bot.spoken." + s, null);
                if (values == null) continue;
                Object[] test = values.toArray();
                String[] insert = new String[test.length + 1];
                int i = 0;
                while (i < test.length) {
                    insert[i] = test[i] == null ? "" : test[i].toString();
                    ++i;
                }
                if (insert[1] == null) {
                    insert[1] = "";
                }
                if (insert == null || insert.length != 2) continue;
                this.spokenCatches.put(insert, s);
            }
        }
        if ((keys3 = config.getKeys("bot.other")) != null) {
            for (String s : keys3) {
                String value = config.getString("bot.other." + s, null);
                if (value == null) continue;
                this.otherCatches.put(value, s);
            }
        }
    }

    public void loadUsers(Configuration config) {
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + config.getString("db-file-name", "users.db"));
            Statement stat = conn.createStatement();
            stat.executeUpdate("CREATE TABLE IF NOT EXISTS users (name, rank);");
            ResultSet rs = stat.executeQuery("SELECT * FROM users;");
            while (rs.next()) {
                this.knownUsers.put(rs.getString("username"), rs.getInt("rank"));
            }
            rs.close();
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveUsers(Configuration config) {
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + config.getString("db-file-name", "users.db"));
            Statement stat = conn.createStatement();
            stat.executeUpdate("DROP TABLE IF EXISTS users;");
            stat.executeUpdate("CREATE TABLE users (name, rank);");
            PreparedStatement prep = conn.prepareStatement("INSERT INTO users VALUES (?, ?);");
            for (String s : this.knownUsers.keySet()) {
                if (this.knownUsers.get(s) == 0) continue;
                prep.setString(1, s);
                prep.setInt(2, this.knownUsers.get(s));
                prep.addBatch();
            }
            conn.setAutoCommit(false);
            prep.executeBatch();
            conn.setAutoCommit(true);
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer modifyPlayer(String name, int rank) {
        return this.knownUsers.put(name, rank);
    }

    public Integer getPlayer(String name) {
        return this.knownUsers.get(name);
    }
}

