/*
 * Decompiled with CFR 0.152.
 */
package com.enigmasm.serverbot;

import com.enigmasm.serverbot.ServerBot;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ServerBotListener
extends PlayerListener {
    private final String TIME_FORMAT = "hh:mm a";
    private final String DATE_FORMAT = "MM-dd-yyyy";
    private ServerBot parent;
    private Server server;

    public ServerBotListener(ServerBot serverBot) {
        this.parent = serverBot;
        this.server = serverBot.getServer();
    }

    private String getTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm a");
        return sdf.format(cal.getTime());
    }

    private String getDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
        return sdf.format(cal.getTime());
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp()) {
            if (this.parent.getBot().getOtherCatch("playerjoinop") != null) {
                String message = this.botParse(this.parent.getBot().getOtherCatch("playerjoinop"), event.getPlayer());
                this.server.broadcastMessage(message);
            }
        } else if (this.isFriend(event.getPlayer()) && this.parent.getBot().getOtherCatch("playerjoinfriend") != null) {
            String message = this.botParse(this.parent.getBot().getOtherCatch("playerjoinfriend"), event.getPlayer());
            this.server.broadcastMessage(message);
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        if (event.getPlayer().isOp()) {
            if (this.parent.getBot().getOtherCatch("playerleaveop") != null) {
                String message = this.botParse(this.parent.getBot().getOtherCatch("playerleaveop"), event.getPlayer());
                this.server.broadcastMessage(message);
            }
        } else if (this.isFriend(event.getPlayer()) && this.parent.getBot().getOtherCatch("playerleavefriend") != null) {
            String message = this.botParse(this.parent.getBot().getOtherCatch("playerleavefriend"), event.getPlayer());
            this.server.broadcastMessage(message);
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        if (!event.isCancelled()) {
            String outText = event.getMessage();
            String caught = this.parent.getBot().getSpokenCatch(outText);
            if (caught != null) {
                event.setCancelled(true);
                String response = this.botParse(caught, event.getPlayer());
                this.server.broadcastMessage("<" + event.getPlayer().getDisplayName() + "\u00a7f> " + event.getMessage());
                this.server.broadcastMessage(response);
            }
        }
    }

    private String botParse(String caught, Player player) {
        caught = caught.replace("{P}", player.getName());
        caught = caught.replace("{B}", this.parent.getBot().getName());
        caught = caught.replace("{T}", this.getTime());
        caught = caught.replace("{D}", this.getDate());
        caught = caught.replace("{ST}", "" + player.getWorld().getTime());
        caught = caught.replace("{DT}", this.getTimeDecription());
        caught = caught.replace("{SDT}", this.getTimeDescription(player.getWorld()));
        caught = "<" + this.parent.getBot().getDisplayName() + "\u00a7f> " + caught;
        return caught;
    }

    private String getTimeDescription(World world) {
        long time = world.getTime();
        if (time < 6000L) {
            return "Morning";
        }
        if (time < 12000L) {
            return "Afternoon";
        }
        return "Evening";
    }

    private String getTimeDecription() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        Calendar cal = Calendar.getInstance();
        String n = sdf.format(cal.getTime());
        int i = Integer.parseInt(n);
        if (i < 6 || i > 18) {
            return "Evening";
        }
        if (i > 6 && i < 12) {
            return "Morning";
        }
        return "Afternoon";
    }

    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult().equals((Object)PlayerLoginEvent.Result.KICK_FULL)) {
            if (this.parent.getBot().getOtherCatch("playerkickfull") != null) {
                String message = this.botParse(this.parent.getBot().getOtherCatch("playerkickfull"), event.getPlayer());
                this.server.broadcastMessage(message);
            }
            return;
        }
        if (event.getResult().equals((Object)PlayerLoginEvent.Result.KICK_BANNED)) {
            if (this.parent.getBot().getOtherCatch("playerkickbanned") != null) {
                String message = this.botParse(this.parent.getBot().getOtherCatch("playerkickbanned"), event.getPlayer());
                this.server.broadcastMessage(message);
            }
            return;
        }
        if (event.getResult().equals((Object)PlayerLoginEvent.Result.KICK_OTHER)) {
            if (this.parent.getBot().getOtherCatch("playerkickother") != null) {
                String message = this.botParse(this.parent.getBot().getOtherCatch("playerkickother"), event.getPlayer());
                this.server.broadcastMessage(message);
            }
            return;
        }
    }

    private boolean isFriend(Player player) {
        Integer i = this.parent.getBot().getPlayer(player.getName());
        return i != null && i >= 2;
    }
}

