/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Extra;

import com.gemo.FalseBook.Core.FalseBookCore;
import com.gemo.FalseBook.Extra.ExtraWorldSettings;
import com.gemo.FalseBook.Extra.FalseBookExtraBlockListener;
import com.gemo.utils.FileUtils;
import java.io.File;
import java.util.HashMap;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FalseBookExtraCore
extends JavaPlugin {
    private FalseBookCore core;
    private static String pluginName;
    public static Server server;
    private static HashMap<String, ExtraWorldSettings> Settings;
    private FalseBookExtraBlockListener blockListener;

    public static void printInConsole(String str) {
        System.out.println("[FalseBook Extra] " + str);
    }

    public void onDisable() {
        if (this.searchCore()) {
            System.out.println(String.valueOf(pluginName) + " disabled");
        }
    }

    private boolean searchCore() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("FalseBookCore") != null) {
            if (pm.getPlugin("FalseBookCore").isEnabled()) {
                this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
                return true;
            }
            this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
            return true;
        }
        return false;
    }

    public void onEnable() {
        if (!this.searchCore()) {
            FalseBookExtraCore.printInConsole(">>>>> FalseBookCore.jar not found! FalseBookExtra.jar is being disabled!");
            return;
        }
        this.loadVersion();
        server = this.getServer();
        this.checkForDefaultSettings();
        this.loadWorldSettings();
        this.blockListener = new FalseBookExtraBlockListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.REDSTONE_CHANGE, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PHYSICS, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        System.out.println(String.valueOf(pluginName) + " enabled");
    }

    public FalseBookExtraBlockListener getBlockListener() {
        return this.blockListener;
    }

    public void loadVersion() {
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginName = String.valueOf(pdfFile.getName()) + " v" + pdfFile.getVersion() + " by GeMo";
    }

    public void checkForDefaultSettings() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        File f = new File("plugins/FalseBook/FalseBookExtra.properties");
        if (!f.exists()) {
            return;
        }
        f = null;
        int i = 0;
        while (i < server.getWorlds().size()) {
            this.checkForDefaultSettings(((World)server.getWorlds().get(i)).getName());
            ++i;
        }
    }

    public void checkForDefaultSettings(String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        File f = new File("plugins/FalseBook/FalseBookExtra.properties");
        if (!f.exists()) {
            return;
        }
        f = null;
        if (server.getWorld(worldName) == null) {
            return;
        }
        folder = new File("plugins/FalseBook/" + server.getWorld(worldName).getName());
        folder.mkdirs();
        try {
            f = new File("plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookExtra.properties");
            if (!f.exists()) {
                FileUtils.copyFile((String)"plugins/FalseBook/FalseBookExtra.properties", (String)("plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookExtra.properties"));
            }
        }
        catch (Exception e) {
            FalseBookExtraCore.printInConsole("Error while copying 'plugins/FalseBook/FalseBookExtra.properties' to 'plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookExtra.properties'");
        }
    }

    public void loadWorldSettings() {
        if (Settings != null) {
            Settings.clear();
        } else {
            Settings = new HashMap();
        }
        int i = 0;
        while (i < server.getWorlds().size()) {
            this.loadWorldSettings(((World)server.getWorlds().get(i)).getName());
            ++i;
        }
    }

    public void loadWorldSettings(String worldName) {
        if (server.getWorld(worldName) == null) {
            return;
        }
        Settings.put(server.getWorld(worldName).getName(), new ExtraWorldSettings("FalseBookExtra.properties", server.getWorld(worldName).getName()));
    }

    public void setCore(FalseBookCore core) {
        this.core = core;
    }

    public FalseBookCore getCore() {
        return this.core;
    }

    public static HashMap<String, ExtraWorldSettings> getSettings() {
        return Settings;
    }

    public static void setSettings(HashMap<String, ExtraWorldSettings> settings) {
        Settings = settings;
    }
}

