/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat;

import cc.co.evenprime.bukkit.nocheat.config.tree.ActionListOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.BooleanOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ConfigurationTree;
import cc.co.evenprime.bukkit.nocheat.config.tree.IntegerOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.LogLevelOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.MediumStringOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ParentOption;
import cc.co.evenprime.bukkit.nocheat.log.LogLevel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class DefaultConfiguration {
    public static ConfigurationTree buildDefaultConfigurationTree() {
        ConfigurationTree root = new ConfigurationTree();
        ParentOption loggingNode = new ParentOption("logging");
        root.add(loggingNode);
        loggingNode.add(new BooleanOption("active", true, true));
        loggingNode.add(new MediumStringOption("filename", "nocheat.log"));
        loggingNode.add(new LogLevelOption("filelevel", LogLevel.LOW));
        loggingNode.add(new LogLevelOption("consolelevel", LogLevel.HIGH));
        loggingNode.add(new LogLevelOption("chatlevel", LogLevel.MED));
        ParentOption movingNode = new ParentOption("moving");
        root.add(movingNode);
        movingNode.add(new BooleanOption("check", true, true));
        ParentOption flyingNode = new ParentOption("flying");
        movingNode.add(flyingNode);
        flyingNode.add(new BooleanOption("check", true, true));
        flyingNode.add(new IntegerOption("speedlimitvertical", 100));
        flyingNode.add(new IntegerOption("speedlimithorizontal", 22));
        ActionListOption actions = new ActionListOption("actions");
        flyingNode.add(actions);
        actions.add(0, "moveLogLowShort moveCancel");
        actions.add(100, "moveLogMedShort moveCancel");
        actions.add(400, "moveLogHighShort moveCancel");
        ParentOption runningNode = new ParentOption("running");
        movingNode.add(runningNode);
        runningNode.add(new BooleanOption("check", true, true));
        runningNode.add(new IntegerOption("speedlimit", 22));
        ParentOption swimmingNode = new ParentOption("swimming");
        runningNode.add(swimmingNode);
        swimmingNode.add(new BooleanOption("check", true, true));
        swimmingNode.add(new IntegerOption("speedlimit", 18));
        ParentOption sneakingNode = new ParentOption("sneaking");
        runningNode.add(sneakingNode);
        sneakingNode.add(new BooleanOption("check", true, true));
        sneakingNode.add(new IntegerOption("speedlimit", 14));
        actions = new ActionListOption("actions");
        runningNode.add(actions);
        actions.add(0, "moveLogLowShort moveCancel");
        actions.add(100, "moveLogMedShort moveCancel");
        actions.add(400, "moveLogHighShort moveCancel");
        ParentOption morePacketsNode = new ParentOption("morepackets");
        movingNode.add(morePacketsNode);
        morePacketsNode.add(new BooleanOption("check", true, true));
        actions = new ActionListOption("actions");
        morePacketsNode.add(actions);
        actions.add(0, "morepacketsLow moveCancel");
        actions.add(30, "morepacketsMed moveCancel");
        actions.add(60, "morepacketsHigh moveCancel");
        ParentOption noclipNode = new ParentOption("noclip");
        movingNode.add(noclipNode);
        noclipNode.add(new BooleanOption("check", false, true));
        actions = new ActionListOption("actions");
        noclipNode.add(actions);
        actions.add(1, "noclipLog");
        ParentOption interactNode = new ParentOption("blockbreak");
        root.add(interactNode);
        interactNode.add(new BooleanOption("check", true, true));
        ParentOption reachNode = new ParentOption("reach");
        interactNode.add(reachNode);
        reachNode.add(new BooleanOption("check", true, true));
        reachNode.add(new IntegerOption("reachlimit", 485));
        actions = new ActionListOption("actions");
        reachNode.add(actions);
        actions.add(0, "reachLog blockbreakCancel");
        ParentOption directionNode = new ParentOption("direction");
        interactNode.add(directionNode);
        directionNode.add(new BooleanOption("check", true, true));
        actions = new ActionListOption("actions");
        directionNode.add(actions);
        actions.add(0, "directionLog blockbreakCancel");
        ParentOption blockPlaceNode = new ParentOption("blockplace");
        root.add(blockPlaceNode);
        blockPlaceNode.add(new BooleanOption("check", true, true));
        reachNode = new ParentOption("reach");
        blockPlaceNode.add(reachNode);
        reachNode.add(new BooleanOption("check", true, true));
        reachNode.add(new IntegerOption("reachlimit", 485));
        actions = new ActionListOption("actions");
        reachNode.add(actions);
        actions.add(0, "reachLog blockplaceCancel");
        ParentOption onliquidNode = new ParentOption("onliquid");
        blockPlaceNode.add(onliquidNode);
        onliquidNode.add(new BooleanOption("check", true, true));
        actions = new ActionListOption("actions");
        onliquidNode.add(actions);
        actions.add(0, "onliquidLog blockplaceCancel");
        interactNode = new ParentOption("interact");
        root.add(interactNode);
        interactNode.add(new BooleanOption("check", true, true));
        ParentOption durabilityNode = new ParentOption("durability");
        interactNode.add(durabilityNode);
        durabilityNode.add(new BooleanOption("check", true, true));
        actions = new ActionListOption("actions");
        durabilityNode.add(actions);
        actions.add(0, "durabilityLog interactCancel");
        return root;
    }

    public static void writeActionFile(File file) {
        try {
            if (!file.exists()) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BufferedWriter w = new BufferedWriter(new FileWriter(file));
            DefaultConfiguration.w(w, "# This file contains the definitions of the default actions of NoCheat.");
            DefaultConfiguration.w(w, "# DO NOT EDIT THIS FILE DIRECTLY. If you want to change any of these, copy");
            DefaultConfiguration.w(w, "# them to your \"actions.txt\" file and modify them there. If an action with");
            DefaultConfiguration.w(w, "# the same name exists here and in your file, yours will be used.");
            DefaultConfiguration.w(w, "");
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeDefaultActionFile(File file) {
        try {
            if (!file.exists()) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BufferedWriter w = new BufferedWriter(new FileWriter(file));
            DefaultConfiguration.w(w, "# This file contains the definitions of the default actions of NoCheat.");
            DefaultConfiguration.w(w, "# DO NOT EDIT THIS FILE DIRECTLY. If you want to change any of these, copy");
            DefaultConfiguration.w(w, "# them to your \"actions.txt\" file and modify them there. If an action with");
            DefaultConfiguration.w(w, "# the same name exists here and in your file, yours will be used.");
            DefaultConfiguration.w(w, "#");
            DefaultConfiguration.w(w, "# LOG Actions: They will print messages in your log file, console, chat, ...");
            DefaultConfiguration.w(w, "#   - They start with the word 'log'");
            DefaultConfiguration.w(w, "#   - Then comes their name. That name is used in the config file to identify them");
            DefaultConfiguration.w(w, "#   - Then comes the 'delay', that is how often has this action to be called before it really gets executed");
            DefaultConfiguration.w(w, "#   - Then comes the 'repeat', that is how many seconds have to be between two executions of the action");
            DefaultConfiguration.w(w, "#   - Then comes the 'loglevel', that is how the log message gets categorized (low, med, high)");
            DefaultConfiguration.w(w, "#   - Then comes the 'message', depending on where the action is used, different keywords in [ ] may be used");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# Gives a very short log message of the violation, only containing name, violation type and total violation value, at most once every 15 seconds, only if more than 3 violations happened within the last minute (low) and immediatly (med,high)");
            DefaultConfiguration.w(w, "log moveLogLowShort 3 15 low NC: [player] failed [check]");
            DefaultConfiguration.w(w, "log moveLogMedShort 0 15 med NC: [player] failed [check]");
            DefaultConfiguration.w(w, "log moveLogHighShort 0 15 high NC: [player] failed [check]");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# Gives a log message of the violation, only containing name, violation type and total violation value, at most once every second, only if more than 5 violations happened within the last minute (low) and immediatly (med,high)");
            DefaultConfiguration.w(w, "log morepacketsLow 5 1 low NC: [player] failed [check]: Sent [packets] more packets than expected. Total violation level [violations].");
            DefaultConfiguration.w(w, "log morepacketsMed 0 1 med NC: [player] failed [check]: Sent [packets] more packets than expected. Total violation level [violations].");
            DefaultConfiguration.w(w, "log morepacketsHigh 0 1 high NC: [player] failed [check]: Sent [packets] more packets than expected. Total violation level [violations].");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# Gives a lengthy log message of the violation, containing name, location, violation type and total violation, at most once every 15 seconds, only if more than 3 violations happened within the last minute (low) and immediatly (med,high)");
            DefaultConfiguration.w(w, "log moveLogLowLong 3 15 low NC: [player] in [world] at [location] moving to [locationto] over distance [distance] failed check [check]. Total violation level so far [violations].");
            DefaultConfiguration.w(w, "log moveLogMedLong 0 15 med NC: [player] in [world] at [location] moving to [locationto] over distance [distance] failed check [check]. Total violation level so far [violations].");
            DefaultConfiguration.w(w, "log moveLogHighLong 0 15 high NC: [player] in [world] at [location] moving to [locationto] over distance [distance] failed check [check]. Total violation level so far [violations].");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# Some other log messages that are limited a bit by default, to avoid too extreme spam");
            DefaultConfiguration.w(w, "log noclipLog 0 1 high NC: [player] failed [check]: at [location] to [locationto].");
            DefaultConfiguration.w(w, "log reachLog 0 1 med NC: [player] failed [check]: tried to interact with a block over distance [distance].");
            DefaultConfiguration.w(w, "log directionLog 2 1 med NC: [player] failed [check]: tried to destroy a block out of line of sight.");
            DefaultConfiguration.w(w, "log durabilityLog 0 1 med NC: [player] failed [check]: tried to use infinity durability hack.");
            DefaultConfiguration.w(w, "log onliquidLog 2 1 med NC: [player] failed [check]: tried to place a block on liquids.");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# SPECIAL Actions: They will do something check dependant, usually cancel an event.");
            DefaultConfiguration.w(w, "#   - They start with the word 'special'");
            DefaultConfiguration.w(w, "#   - Then comes their name. That name is used in the config file to identify them");
            DefaultConfiguration.w(w, "#   - Then comes the 'delay', that is how often has this action to be called before it really gets executed");
            DefaultConfiguration.w(w, "#   - Then comes the 'repeat', that is how many seconds have to be between two executions of the action");
            DefaultConfiguration.w(w, "#   - Then come further instructions, if necessary");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# Cancels the event in case of an violation. Always. No delay. These are equivalent. The different names are just for better readability");
            DefaultConfiguration.w(w, "special moveCancel 0 0");
            DefaultConfiguration.w(w, "special blockbreakCancel 0 0");
            DefaultConfiguration.w(w, "special blockplaceCancel 0 0");
            DefaultConfiguration.w(w, "special interactCancel 0 0");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# CONSOLECOMMAND Actions: They will execute a command as if it were typed into the console.");
            DefaultConfiguration.w(w, "#   - They start with the word 'consolecommand'");
            DefaultConfiguration.w(w, "#   - Then comes their name. That name is used in the config file to identify them");
            DefaultConfiguration.w(w, "#   - Then comes the 'delay', that is how often has this action to be called before it really gets executed");
            DefaultConfiguration.w(w, "#   - Then comes the 'repeat', that is how many seconds have to be between two executions of the action");
            DefaultConfiguration.w(w, "#   - Then comes the command. You can use the same [ ] that you use for log actions. You'll most likely want to use [player] at some point.");
            DefaultConfiguration.w(w, "");
            DefaultConfiguration.w(w, "# E.g. Kick a player");
            DefaultConfiguration.w(w, "consolecommand kick 0 0 kick [player]");
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void w(BufferedWriter writer, String text) throws IOException {
        writer.write(text);
        writer.newLine();
    }
}

