/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.actions;

import cc.co.evenprime.bukkit.nocheat.actions.types.Action;
import cc.co.evenprime.bukkit.nocheat.actions.types.ConsolecommandAction;
import cc.co.evenprime.bukkit.nocheat.actions.types.LogAction;
import cc.co.evenprime.bukkit.nocheat.actions.types.SpecialAction;
import cc.co.evenprime.bukkit.nocheat.log.LogLevel;
import cc.co.evenprime.bukkit.nocheat.log.LogManager;
import java.util.HashMap;
import java.util.Map;

public class ActionManager {
    private final Map<String, Action> actionIdsToActionMap = new HashMap<String, Action>();
    private final LogManager log;
    private final String[] knownTypes = new String[]{"log", "consolecommand", "special"};

    public ActionManager(LogManager log) {
        this.log = log;
    }

    public void createActionFromStrings(String type, String actionId, String stringDelay, String stringRepeat, String theRest) {
        int repeat;
        int delay;
        Action action = null;
        type = type.toLowerCase();
        actionId = actionId.toLowerCase();
        try {
            delay = Integer.parseInt(stringDelay);
        }
        catch (NumberFormatException e) {
            this.log.logToConsole(LogLevel.HIGH, "Can't parse action: \"" + actionId + "\", first parameter " + stringDelay + " not a number");
            return;
        }
        try {
            repeat = Integer.parseInt(stringRepeat);
        }
        catch (NumberFormatException e) {
            this.log.logToConsole(LogLevel.HIGH, "Can't parse action: \"" + actionId + "\", second parameter " + stringRepeat + " not a number");
            return;
        }
        if (type.equals("log")) {
            String[] pieces = null;
            if (theRest != null && ((pieces = theRest.split("\\s+", 2)) == null || pieces.length < 2)) {
                this.log.logToConsole(LogLevel.HIGH, "Can't parse log action: \"" + actionId + "\", missing parameters");
                return;
            }
            action = this.createLogActionFromString(delay, repeat, pieces[0], pieces[1]);
        } else if (type.equals("special")) {
            action = this.createCancelActionFromString(delay, repeat);
        } else if (type.equals("consolecommand")) {
            if (theRest == null) {
                this.log.logToConsole(LogLevel.HIGH, "Can't parse consolecommand action: \"" + actionId + "\", missing parameter");
                return;
            }
            action = this.createConsolecommandActionFromString(delay, repeat, theRest);
        } else {
            this.log.logToConsole(LogLevel.HIGH, "Can't parse action: \"" + actionId + "\", unknown action type");
            return;
        }
        if (action != null) {
            this.actionIdsToActionMap.put(actionId, action);
        }
    }

    public String[] getKnownTypes() {
        return this.knownTypes;
    }

    private ConsolecommandAction createConsolecommandActionFromString(int delay, int repeat, String command) {
        return new ConsolecommandAction(delay, repeat, command);
    }

    private SpecialAction createCancelActionFromString(int delay, int repeat) {
        return new SpecialAction(delay, repeat);
    }

    private Action createLogActionFromString(int delay, int repeat, String logLevel, String message) {
        LogLevel level = LogLevel.getLogLevelFromString(logLevel);
        if (level.equals((Object)LogLevel.OFF)) {
            return null;
        }
        return new LogAction(delay, repeat, level, message);
    }

    public Action getActionByName(String name) {
        return this.actionIdsToActionMap.get(name.toLowerCase());
    }
}

